<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/html.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/view.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/mailbox.inc.php");

require ("./includes/options.inc.php");

$id = intval(strip_tags($_GET['id']));
$pid = intval(strip_tags($_GET['pid']));
$icsmode = strip_tags($_GET['icsmode']);
$folder = strip_tags($_GET['f']);
$folderencode = urlencode($folder);
$rr = strip_tags($_GET['rr']);
$switch = strip_tags($_GET['switch']);

if ($_GET['f']) {
	$_SESSION['folder'] = strip_tags(trim($_GET['f']));
}

if (isset($_GET['w']) && $_GET['w'] == 'popup') {
	$prependheader = "popup_";
}
elseif (isset($_GET['w']) && $_GET['w'] == 'preview') {
	$prependheader = "preview_";
}
else {
	$prependheader = "";
}

if (isset($_GET['ap']) && $_GET['ap'] == 0) {
	$eoptions['AutoPreview'] = $_GET['ap'];
	$AutoPreview = 0;
	$_SESSION['extoptions'] = serialize($eoptions);
	if ($UseDatabase == 1) {
		$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($eoptions), 'extended');
	}
}

if ($switch == $lang['SView']['ViewHTML']) {
	$HTMLemailmode = "1";
}
elseif ($switch == $lang['SView']['ViewHTMLImages']) {
	$HTMLemailmode = "5";
}
elseif ($switch == $lang['SView']['ViewText']) {
	$HTMLemailmode = "4";
}

// If you want to display the file type instead of file icons, set this to 0
$useattachmenticons = 1;

if (isset($HTMLemailmode)) {
	$myoptions['HTMLemail'] = $HTMLemailmode;
	$_SESSION['dwmailoptions'] = serialize($myoptions);
	if ($UseDatabase == 1) {
		$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
	}
	else {
		if ($AllowCookies == 1) {
			$expiretime = 3600 * 8760;
			setcookie ("dwmailoptions", serialize($myoptions), time()+$expiretime);
		}
	}
	$HTMLemail = $HTMLemailmode;
}

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead($prependheader . 'header');
$PageFooter = $getFile->fileRead($prependheader . 'footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageView = $getFile->fileRead('viewmessage');
$PageViewMenu = $getFile->fileRead('viewmenu');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SView']['Title'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

$IMAPConnection->WM_IMAPGetHeader($id);
$headerdetails = $IMAPConnection->WM_IMAPFullHeaders();

if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
	$movemessage = "<script language=\"javascript\" type=\"text/javascript\">
<!--
function domove(select_box_name) {
	if (select_box_name.options[select_box_name.options.selectedIndex].value != '') {
		document.location = 'movemessage.php?selection=" . $id . "&f=' + select_box_name.options[select_box_name.options.selectedIndex].value + '&" . strip_tags(SID) . "';
	}

}
// -->
</script>
<select name=\"df\" onchange=\"domove(this);\">
<option value=\"\">-- " . $lang['SMove']['MoveSelection'] . " --</option>";
	$folderget = $IMAPConnection->WM_IMAPFolders($IMAPSubscriptions);
	$folders = $IMAPConnection->_folders;
	sort($folders);
	for($i=0; $i<count($folders); $i++) {
		$movemessage .= "<option value=\"" . urlencode($folders[$i]['id']) . "\">" . str_replace("INBOX.", " - ", $folders[$i]['name']) . "</option>\n";
	}
	$movemessage .= "</select>";
}
else {
	$movemessage = "";
}

include ("./includes/folderpane.inc.php");
$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
echo $PageHeader;

$subj = $IMAPConnection->WM_IMAPGetSubject();

if ($subj == "") {
	$subj = $lang['SView']['NoSubject'];
}

$CodeSearch = array (
	"[view_id]",
	"[session]",
	"[session_append]"
);

$CodeReplace = array (
	$id,
	$MainSettings->SessAppend_noecho($TransIDEnabled, 1),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 0)
);

$PageViewMenu = str_replace ($CodeSearch, $CodeReplace, $PageViewMenu);

$crlf = $MainSettings->GetCRLF();
$IMAPConnection->_crlf = $crlf;
$IMAPConnection->_charset = $_SESSION['DefaultCharSet'];

// Find a read receipt header
$header_full = $IMAPConnection->WM_IMAPRFCHeader($id);
$header_arry = explode ("\n", $header_full);
$line_number = 0; 
$have_notification = 0;

// This sets the message headers to read
$SetRead = $IMAPConnection->WM_IMAPSetFlag("\\Seen", $id);

// Find an importance header
if (strstr($header_full, 'Importance:')) {
	$header_arry = explode ("\n", $header_full);
	$line_number = 0; 
	$have_importance = 0;
	while ($line = $header_arry[$line_number]) { 
		$line = trim($line);
		if (strstr($line, "Importance:")) {
			$importancelevel = str_replace ("Importance:", "", $line);
			$importancelevel = trim($importancelevel);
			$have_importance = 1;
		}
		$line_number++; 
	}
}

if ($importancelevel == "High") {
	$importancegraphic = '<img src="templates/' . $DefaultTemplate . '/images/mailbox/important.gif" alt="' . $lang['SMbox']['Importance'] . ': ' . $lang['SMbox']['ImportanceHigh'] . '" />';	
	$importancetext = $lang['SMbox']['ImportanceHighDesc'];
}
elseif ($importancelevel == "Low") {
	$importancegraphic = '<img src="templates/' . $DefaultTemplate . '/images/mailbox/low.gif" alt="' . $lang['SMbox']['Importance'] . ': ' . $lang['SMbox']['ImportanceLow'] . '" />';	
	$importancetext = $lang['SMbox']['ImportanceLowDesc'];
}
elseif ($importancelevel == "Normal") {
	$have_importance = 0;
}
else {
	$importancegraphic = '&nbsp;';	
}

if ($have_importance == 1) {
	$PageView = str_replace('[importance_icon]', $importancegraphic, $PageView);
	$PageView = str_replace('[importance_message]', $importancetext, $PageView);
	$PageView = str_replace('[ifimportance]', '', $PageView);
	$PageView = str_replace('[/ifimportance]', '', $PageView);
}
else {
	$PageView = preg_replace("/(\[)(ifimportance)(])(\r\n)*(.*)(\[\/ifimportance\])/siU", "", $PageView);
}

$PageView = preg_replace("/(\[)(ifattachments)(])(\r\n)*(.*)(\[\/ifattachments\])/siU", "", $PageView);

$structure = $IMAPConnection->WM_IMAPGetStructure($id);
$contenttype = strtolower($type[$structure->type] . '/' . $structure->subtype);

if (!empty($pid)) {
	// The ICS file we have is an attachment rather than body of message

	$sections = parseBody($structure);

	for($x=0; $x<sizeof($sections); $x++) {
		if($sections[$x]["pid"] == $pid) {
			$contenttype = $sections[$x]["type"];
			$encoding = $sections[$x]["encoding"];
			$filedescription = $sections[$x]["description"];
			$filename = $sections[$x]["name"];
			$size = $sections[$x]["size"];
			$attachment_size = ceil($size/1024). "Kb";
		}
	}

	$attachment = $IMAPConnection->WM_IMAPGetBody($id, $pid, -1);
	$body = parseEncoding($attachment, $encoding);

	// Decoded file size in bytes
	$decodedsize = strlen($finalfile);
	$decodedsize2 = ceil($decodedsize/1024) . "Kb";
}
else {
	$body = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);

}

$view_styleformat = "view_text";

$foundlocal = 0;

if ($contenttype == 'text/calendar') {
	require_once ('./includes/iCalendar.inc.php');
	require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/utils.inc.php");
	$CalendarFile = new iCal_Parse();
	$CalendarFile->parsecal($body);
	// iCalendar array located in $CalendarFile->_icalobj[];

	$checkuid = $MySQLConnection->DB_CheckUID($CalendarFile->_icalobj[0]['uid']);

	$to_array  = imap_rfc822_parse_adrlist($headerdetails['fromaddress'], "localhost");
	if (is_array($to_array)) {
	while(list($key,$val) = each($to_array)){
		if ($val->mailbox <> "" && $val->host <> "") {
			$fromemailaddress = $val->mailbox . "@" . $val->host;
		}
	}
	}

	unset ($content);
	if (is_array ($CalendarFile->_icalobj)) {
		if (is_array($CalendarFile->_icalobj[0]['attendee'])) {
			$content .= $lang['SCalendar']['Required'] . ': ';
			for ($c=0; $c<sizeof($CalendarFile->_icalobj[0]['attendee']); $c++) {
				if (strtolower($CalendarFile->_icalobj[0]['attendee'][$c]["email"]) == strtolower($_SESSION['currentemailaddress']) && $CalendarFile->_icalobj[0]['attendee'][$c]["rsvp"] == true && strtoupper($CalendarFile->_icalobj[0]["method"]) == 'REQUEST') {
					// We have found the user's email address in the list of required attendees and RSVP is true
					$foundlocal = 1;
				}
				if (strtolower($CalendarFile->_icalobj[0]['attendee'][$c]["email"]) == strtolower($fromemailaddress) && strtoupper($CalendarFile->_icalobj[0]["method"]) == 'REPLY') {
					$newstatus = $CalendarFile->_icalobj[0]['attendee'][$c]["status"];

				}
				$content .= $CalendarFile->_icalobj[0]['attendee'][$c]["email"];
				if ($c < sizeof($CalendarFile->_icalobj[0]['attendee']) - 1) {
					$content .= ", ";
				}
			}
			$content .= "<br />";
		}

		if (isset($CalendarFile->_icalobj[0]['dtstart'])) {
			$startdate = date('r', $CalendarFile->_icalobj[0]['dtstart']);
			$startdate = DateToLocal($tz, $startdate, $DateFormattingFull);
			$content .= $lang['SCalendar']['Start'] . ': ' . $startdate . '<br />';
		}
		if (isset($CalendarFile->_icalobj[0]['dtend'])) {
			$enddate = date('r', $CalendarFile->_icalobj[0]['dtend']);
			$enddate = DateToLocal($tz, $enddate, $DateFormattingFull);
			$content .= $lang['SCalendar']['End'] . ': ' . $enddate . '<br />';
		}
		if (isset($CalendarFile->_icalobj[0]['location'])) {
			$content .= $lang['SCalendar']['Location'] . ': ' . $CalendarFile->_icalobj[0]['location'] . '<br />';
		}
		if (isset($CalendarFile->_icalobj[0]['summary'])) {
			$content .= $lang['SCalendar']['Subject'] . ': ' . $CalendarFile->_icalobj[0]['summary'] . '<br />';
		}
		if (isset($CalendarFile->_icalobj[0]['url'])) {
			$content .= $lang['SCalendar']['URL'] . ': ' . $CalendarFile->_icalobj[0]['url'] . '<br />';
		}

		if (isset($CalendarFile->_icalobj[0]['description'])) {
			$content .= '<br />' . $lang['SCalendar']['Description'] . ':<br /><blockquote>' . nl2br($CalendarFile->_icalobj[0]['description']) . '</blockquote><br />';
		}
	}

	if (strtoupper($CalendarFile->_icalobj[0]['method']) == 'REPLY') {
		// We have a reply

		// Determine type of reply
		if (!empty($checkuid) && !empty($newstatus)) {
			// Save status against from address
			$updatestatus = $MySQLConnection->DB_AttendeeStatus($checkuid, $fromemailaddress, $newstatus);
		}

	}
}

if ($foundlocal == 1 && empty($icsmode) && empty($checkuid)) {
	$PageView = str_replace('[ifappointment]', '', $PageView);
	$PageView = str_replace('[/ifappointment]', '', $PageView);
}
else {
	$PageView = preg_replace("/(\[)(ifappointment)(])(\r\n)*(.*)(\[\/ifappointment\])/siU", "", $PageView);
}

$PageView = preg_replace("/(\[)(ifhtmlnoimages)(])(\r\n)*(.*)(\[\/ifhtmlnoimages\])/siU", "", $PageView);
$PageView = preg_replace("/(\[)(iftext)(])(\r\n)*(.*)(\[\/iftext\])/siU", "", $PageView);
$PageView = preg_replace("/(\[)(ifhtml)(])(\r\n)*(.*)(\[\/ifhtml\])/siU", "", $PageView);

$CurrentSeqNo = $IMAPConnection->GetSeqNum($id);

if ($CurrentSeqNo > 1) {
	$prevmsgid = $IMAPConnection->GetSeqNum($id) - 1;
	if ($_SESSION['servertype'] == 'imap' || $_SESSION['servertype'] == "imapssl") {
		$prevmsgid = $IMAPConnection->GetUID($prevmsgid);
	}
	$nextprev .= "<a href=\"view.php?id=" . $prevmsgid . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['SView']['PrevMess'] . "</a> | ";
}
else {
	$nextprev .= $lang['SView']['PrevMess'] . ' | ';
}

$numberofmessages = $IMAPConnection->WM_IMAPNumMessages();

if ($CurrentSeqNo < $numberofmessages) {
	$nextmsgid = $IMAPConnection->GetSeqNum($id) + 1;
	if ($_SESSION['servertype'] == 'imap' || $_SESSION['servertype'] == "imapssl") {
		$nextmsgid = $IMAPConnection->GetUID($nextmsgid);
	}
	$nextprev .= "<a href=\"view.php?id=" . $nextmsgid . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['SView']['NextMess'] . "</a>";
}
else {
	$nextprev .= $lang['SView']['NextMess'];
}

// Save from address to addressbook button
if ($UseDatabase == 1) {
	$from_array  = imap_rfc822_parse_adrlist($headerdetails['fromaddress'], 'localhost');
	if (($from_array[0]->mailbox <> "") && ($from_array[0]->host <> "") && ($from_array[0]->host <> "localhost")) {
		$urlenc_from_name = urlencode($from_array[0]->personal);
		$urlenc_from_email = urlencode($from_array[0]->mailbox) . "@" . urlencode($from_array[0]->host);
		$PageView = str_replace("[ifcontacts]", "", $PageView);
		$PageView = str_replace("[/ifcontacts]", "", $PageView);
	}
	else {
		$PageView = preg_replace("/(\[)(ifcontacts)(])(\r\n)*(.*)(\[\/ifcontacts\])/siU", "", $PageView);
	}
}
else {
	$savelink = "";
	$PageView = preg_replace("/(\[)(ifcontacts)(])(\r\n)*(.*)(\[\/ifcontacts\])/siU", "", $PageView);
}

if ($headerdetails['ccaddress'] == '') {
	$PageView = preg_replace("/(\[)(ifcc)(])(\r\n)*(.*)(\[\/ifcc\])/siU", "", $PageView);
}
else {
	$PageView = str_replace('[ifcc]', '', $PageView);
	$PageView = str_replace('[/ifcc]', '', $PageView);
}

if ($headerdetails['bccaddress'] == '') {
	$PageView = preg_replace("/(\[)(ifbcc)(])(\r\n)*(.*)(\[\/ifbcc\])/siU", "", $PageView);
}
else {
	$PageView = str_replace('[ifbcc]', '', $PageView);
	$PageView = str_replace('[/ifbcc]', '', $PageView);
}

if ($icsmode == 'accept') {
	$PageView = str_replace('[ifcalendarerror]', '', $PageView);
	$PageView = str_replace('[/ifcalendarerror]', '', $PageView);
	$PageView = str_replace('[error_icon]', "<img src=\"templates/$DefaultTemplate/images/mailbox/appointment.gif\" alt=\"\" />", $PageView);
	$PageView = str_replace('[calendar_message]', $lang['SCalendar']['SavedICS'], $PageView);
}
elseif (!empty($checkuid) && strtoupper($CalendarFile->_icalobj[0]['method']) <> 'REPLY') {
	$PageView = str_replace('[ifcalendarerror]', '', $PageView);
	$PageView = str_replace('[/ifcalendarerror]', '', $PageView);
	$PageView = str_replace('[error_icon]', "<img src=\"templates/$DefaultTemplate/images/alert.gif\" alt=\"\" />", $PageView);
	$PageView = str_replace('[calendar_message]', $lang['SCalendar']['AlreadyExists'], $PageView);
}
else {
	$PageView = preg_replace("/(\[)(ifcalendarerror)(])(\r\n)*(.*)(\[\/ifcalendarerror\])/siU", "", $PageView);
}

$PageView = preg_replace("/(\[)(ifzip)(])(\r\n)*(.*)(\[\/ifzip\])/siU", "", $PageView);

$localtime_date = DateToLocal($tz, $headerdetails['date'], $DateFormattingFull);

if ($charset == "") {
	$charset = $_SESSION['DefaultCharSet'];
}

if (isset($headerdetails['senderaddress']) && $headerdetails['senderaddress'] <> $headerdetails['fromaddress']) {
	$view_from = parseLinks(htmlspecialchars($headerdetails['senderaddress']), 1, 1) . ' ' . $lang['SView']['Sender'] . ' ' . parseLinks(htmlspecialchars($headerdetails['fromaddress']), 1, 1);
}
else {
	$view_from = parseLinks(htmlspecialchars($headerdetails['fromaddress']), 1, 1);
}

$CodeSearch = array (
	"[view_from]",
	"[view_to]",
	"[view_cc]",
	"[view_bcc]",
	"[view_subject]",
	"[view_date]",
	"[view_messagedate]",
	"[view_attachments]",
	"[view_body]",
	"[nextprev]",
	"[view_menu]",
	"[view_folder]",
	"[view_styleformat]",
	"[session_form]",
	"[session_append]",
	"[session_force]",
	"[session]",
	"[imap_move]",
	"[view_fromname_urlencoded]",
	"[view_fromemail_urlencoded]",
	"[view_autopreview]",
	"[view_id]",
	"[view_partid]",
	"[view]",
	"[view_charset]"
);

$CodeReplace = array (
	$view_from,
	parseLinks(htmlspecialchars($headerdetails['toaddress']), 1, 1),
	parseLinks(htmlspecialchars($headerdetails['ccaddress']), 1, 1),
	parseLinks(htmlspecialchars($headerdetails['bccaddress']), 1, 1),
	$subj,
	$localtime_date,
	$headerdetails['date'],
	$attachmentdetails,
	$content,
	$nextprev,
	$PageViewMenu,
	urlencode($_SESSION['folder']),
	$view_styleformat,
	$MainSettings->SessAppend_form($TransIDEnabled),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 0),
	"&amp;" . strip_tags(SID),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 1),
	$movemessage,
	$urlenc_from_name,
	$urlenc_from_email,
	$autopreviewimages,
	$id,
	$pid,
	'view.ics',
	$charset
);

$PageView = str_replace ($CodeSearch, $CodeReplace, $PageView);
$PageView = LangReplace('SView', $PageView, $lang);
echo $PageView;

$IMAPConnection->WM_IMAPClose();

if ($icsmode == 'accept' || $icsmode == 'decline') {
	if ($icsmode == 'accept') {
		$submitteddetails['subject'] = strip_tags(addslashes($CalendarFile->_icalobj[0]['summary']));
		$submitteddetails['location'] = strip_tags(addslashes($CalendarFile->_icalobj[0]['location']));
		$submitteddetails['description'] = strip_tags(addslashes($CalendarFile->_icalobj[0]['description']));
		$submitteddetails['url'] = strip_tags(addslashes($CalendarFile->_icalobj[0]['url']));

		$submitteddetails['starttime'] = date('Y-m-d H:i:s', $CalendarFile->_icalobj[0]['dtstart']);;
		$submitteddetails['endtime'] = date('Y-m-d H:i:s', $CalendarFile->_icalobj[0]['dtend']);
		$submitteddetails['uid'] = $CalendarFile->_icalobj[0]['uid'];

		$cal_addentry = $MySQLConnection->DB_CalNewEntry($submitteddetails);

		$CalendarFile->_icalobj[0]['summary'] = "Accepted: " . $CalendarFile->_icalobj[0]['summary'];
	}
	else {
		$CalendarFile->_icalobj[0]['summary'] = "Declined: " . $CalendarFile->_icalobj[0]['summary'];
	}
	$crlf = $MainSettings->GetCRLF();
	$IMAPConnection->_crlf = $crlf;

	$CalendarFile->_crlf = $crlf;

	$attendees[0] = $_SESSION['currentemailaddress'];

	$BuildiCal = $CalendarFile->BuildiCal($_SESSION, 'reply', $CalendarFile->_icalobj[0]['dtstart'], $CalendarFile->_icalobj[0]['dtend'], $CalendarFile->_icalobj[0]['location'], $CalendarFile->_icalobj[0]['summary'], $CalendarFile->_icalobj[0]['description'], $CalendarFile->_icalobj[0]['url'], $attendees, $icsmode, $CalendarFile->_icalobj[0]['uid'], $CalendarFile->_icalobj[0]['organizer'][0]["email"]);

	if (($DWmailMode == 1) && ($UseSMTP == 1)) {
		require ("./includes/smtp.inc.php");
		$SMTPConnection = new WM_SMTPConnection($_SESSION);
		$SMTPConnection->_helodomain = $HELOServerName;
		$smtpconnect = $SMTPConnection->WM_SMTPConnect($DefaultSMTP);
		if (!$smtpconnect) {
			$smtperror[] = "Failed to connect to SMTP server";
		}
		$smtphelo = $SMTPConnection->WM_HELO();
		if (!$smtphelo) {
			$smtperror[] = "HELO to SMTP server failed";
		}
		if ($UseSMTPAuth == 1) {
			$smtpauth = $SMTPConnection->WM_SMTPAuth();
			if (!$smtpauth) {
				$smtperror[] = "Authentication to SMTP server failed";
			}
		}
		$smtpfrom = $SMTPConnection->WM_EnvelopeFROM($_SESSION['currentemailaddress']);
		if (!$smtpfrom) {
			$smtperror[] = "Could not set from address";
		}
		$to_array  = imap_rfc822_parse_adrlist($CalendarFile->_icalobj[0]['organizer'][0]["email"], "localhost");
		if (is_array($to_array)) {
		while(list($key,$val) = each($to_array)){
			if ($val->mailbox <> "" && $val->host <> "") {
				$smtpto = $SMTPConnection->WM_EnvelopeTO($val->mailbox . "@" . $val->host);
				if (!$smtpto) {
					$smtperror[] = "Could not set to address";
				}
			}
		}
		}

		// Build the email first
		$sendemail = $IMAPConnection->WM_IMAPBuildEmail($smtpto, '', '', '', $CalendarFile->_icalobj[0]['summary'], $BuildiCal, '', '', 0, 'text', '', '', $_SESSION['currentemailaddress'], 1, $pname, '', 'text/calendar; method=REPLY');
	
		// Make sure all new lines are \n and then force all \n to \r\n
		// to strip and bare line feeds (as SMTP will not allow this)
		$sendemail['header'] = str_replace ("\r\n", "\n", $sendemail['header']);
		$sendemail['header'] = str_replace ("\n", "\r\n", $sendemail['header']);

		$sendemail['message'] = str_replace ("\r\n", "\n", $sendemail['message']);
		$sendemail['message'] = str_replace ("\n", "\r\n", $sendemail['message']);

		$emailsent = $SMTPConnection->WM_Data($sendemail['header'] . $sendemail['message']);
		if (!$emailsent) {
			$smtperror[] = "Could not send data";
			$emailsent = $smtperror;
		}

		$smtpclose = $SMTPConnection->WM_SMTPClose();

	}
	else {
		// Build the email first
		$sendemail = $IMAPConnection->WM_IMAPBuildEmail($CalendarFile->_icalobj[0]['organizer'][0]["email"], '', '', '', $CalendarFile->_icalobj[0]['summary'], $BuildiCal, '', '', 0, 'text', '', '', $_SESSION['currentemailaddress'], 0, $pname, '', 'text/calendar; method=REPLY');

		// This bit actually calls the sendmail routine
		$emailsent = $IMAPConnection->WM_IMAPSendMail($sendemail);
	}

}
echo $PageFooter;
?>