<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");
require ("./includes/browser.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/view.inc.php");

require ("./includes/options.inc.php");

$id = $_GET['id'];
$pid = $_GET['pid'];

$folder = strip_tags($_GET['f']);

if ($_GET['f']) {
	$_SESSION['folder'] = strip_tags(trim($_GET['f']));
}

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageAttachment = $getFile->fileRead('downloadattachment');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SView']['DownloadAttachment'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);

$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();
$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$allowzip = 0;
if (function_exists('gzcompress')) {
	$allowzip = 1;
}

if ($id == "" || $pid == "") {
	echo ("<p align=\"center\">" . $lang['SErrors']['AttachmentError'] . "</p>");
	echo $PageFooter;
	exit;
}

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

$pidparsed = $pid;

if (strstr($pid, ".") && $_GET['rfc'] == 1) {
	require ("./includes/rfc822.inc.php");
	require ("./includes/3rdparty/MIME/mimeDecode.inc.php");

	$pidexp = explode(".", $pid);
	$headerfull = $IMAPConnection->WM_IMAPRFCHeader($id);
	$bodyfull = $IMAPConnection->WM_IMAPGetBody($id, -1, -1, 1);

	$RFC822Message = new RFC822($_SESSION);
	$RFC822Parts = $RFC822Message->GetParts($headerfull, $bodyfull);
	unset ($headerfull);
	unset ($bodyfull);

	$RFC822Content = $RFC822Parts[$pidexp[0]];
	unset ($RFC822Parts);

	$params['include_bodies'] = true;
	$params['decode_bodies']  = true;
	$params['decode_headers'] = true;

	$RFC822Decode = new Mail_mimeDecode($RFC822Content);

	$ReturnMessage = $RFCDecode->decode($params);

	$type = $ReturnMessage->parts[$pidexp[1]]->ctype_primary . "/" . $ReturnMessage->parts[$pidexp[1]]->ctype_secondary;
	$filedescription = $ReturnMessage->parts[$pidexp[1]]->ctype_parameters['description'];
	$filename = $ReturnMessage->parts[$pidexp[1]]->ctype_parameters['name'];
	$decodedsize = ceil(strlen($ReturnMessage->parts[$pidexp[1]]->body));
	$decodedsize2 = ($decodedsize/1024) . "Kb";
	$finalfile = $ReturnMessage->parts[$pidexp[1]]->body;
}
elseif ($pid == 0) {
	$structure = $IMAPConnection->WM_IMAPGetStructure($id);
	$type2 = $type[$structure->type] . '/' . $structure->subtype;
	$type = $type2;
	$encoding2 = $encoding[$structure->encoding];
	$encoding = $encoding2;
	$size = $structure->bytes;
	$attachment_size = ceil($size/1024). "Kb";
	$filedescription = $structure->description;

	if ($structure->parameters) {
		foreach ($structure->parameters as $p2) {
			$filename = $p2->value;
		}
	}

	if (strtolower($structure->disposition) == "attachment" || strtolower($structure->disposition) == "inline") {
		$params = $structure->dparameters;
		if ($params) {
			foreach ($params as $p) {
				if($p->attribute == "FILENAME" || $p->attribute == "filename")	{
					$filename = $p->value;
					break;
				}
			}
		}
	}

	unset ($structure);

	$finalfile = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
	$finalfile = parseEncoding($finalfile, $encoding);

	// Decoded file size in bytes
	$decodedsize = strlen($finalfile);
	$decodedsize2 = ceil($decodedsize/1024) . "Kb";
	
}
else {
	$structure = $IMAPConnection->WM_IMAPGetStructure($id);

	$sections = parseBody($structure);

	for($x=0; $x<sizeof($sections); $x++) {
		if($sections[$x]["pid"] == $pid) {
			$type = $sections[$x]["type"];
			$encoding = $sections[$x]["encoding"];
			$filedescription = $sections[$x]["description"];
			$filename = $sections[$x]["name"];
			$size = $sections[$x]["size"];
			$attachment_size = ceil($size/1024). "Kb";
		}
	}

	unset ($structure);
	unset ($sections);

	$finalfile = $IMAPConnection->WM_IMAPGetBody($id, $pid, -1);
	$finalfile = parseEncoding($finalfile, $encoding);

	// Decoded file size in bytes
	$decodedsize = strlen($finalfile);
	$decodedsize2 = ceil($decodedsize/1024) . "Kb";
}

$PageAttachment = LangReplace('SView', $PageAttachment, $lang);

if (!$filename) {
	if ($filedescription <> "") {
		$filename = $filedescription;
	}
	else {
		$filename = $lang['SView']['NoAttachmentName'];
	}
	$downloadfilename = 'unknown';
}
else {
	$downloadfilename = $filename;
}

$CodeSearch = array (
	"[message_number]",
	"[messages_folder]",
	"[messages_folderencode]",
	"[attachment_number]",
	"[session]",
	"[session_append]",
	"[session_form]",
	"[attachment_name]",
	"[attachment_type]",
	"[attachment_size]"
);

$CodeReplace = array (
	$id,
	$_SESSION['folder'],
	urlencode($_SESSION['folder']),
	$pidparsed,
	$MainSettings->SessAppend_noecho($TransIDEnabled, 1),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 0),
	$MainSettings->SessAppend_form($TransIDEnabled),
	$filename,
	$type,
	$decodedsize2
);

$PageAttachment = str_replace ($CodeSearch, $CodeReplace, $PageAttachment);


if(!$_GET['submit']) {
	include ("./includes/folderpane.inc.php");
	$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);

	$PageHeader = LangReplace('Generic', $PageHeader, $lang);
	$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
	$PageFooter = LangReplace('Generic', $PageFooter, $lang);
	$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

	$filenamedetails = explode(".", $filename);
	$arrysize = sizeof($filenamedetails);
	$fileext = $filenamedetails[$arrysize - 1];
	if ($fileext == "exe" || $fileext == "pif" || $fileext == "bat" || $fileext == "com" || $fileext == "scr") {
		$warning = $lang['SView']['FileWarning'];
	}
	else {
		$warning = '';
	}

	if ($allowzip == 1) {
		$PageAttachment = str_replace("[ifzip]", "", $PageAttachment);
		$PageAttachment = str_replace("[/ifzip]", "", $PageAttachment);
		$PageAttachment = preg_replace("/(\[)(ifnozip)(])(\r\n)*(.*)(\[\/ifnozip\])/siU", "", $PageAttachment);
	}
	else {
		$PageAttachment = str_replace("[ifnozip]", "", $PageAttachment);
		$PageAttachment = str_replace("[/ifnozip]", "", $PageAttachment);
		$PageAttachment = preg_replace("/(\[)(ifzip)(])(\r\n)*(.*)(\[\/ifzip\])/siU", "", $PageAttachment);
	}

	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
	echo $PageHeader;
	$PageAttachment = str_replace("[typewarning]", $warning, $PageAttachment);
	echo $PageAttachment;
	echo $PageFooter;
}
else {

	// This content disposition header follows the RFC 1086 guidelines for 
	// Content-Disposition headers via http/1.1
	// If this fails to download it is most likely a quirk or bug in the browser.

	// See http://www.faqs.org/rfcs/rfc1086.html for more information about content-disposition.

	// See the HTTP/1.1 standard at http://www.w3.org/Protocols/rfc2616/rfc2616.html
	// for more information

	// Content-Length: is essential for an attachment content-disposition otherwise some browsers
	// corrupt the download


	// Prevent anything being sent to the browser until the entire attachment has been loaded
	if (!$_GET['dltype']) {
		$_GET['dltype'] = "file";
	}
	if ($_GET['dltype'] == "zip") {
		require ("./includes/zip.inc.php");

		$NewZip = new ZipCreate();
		$NewZip->AddFile($finalfile, $downloadfilename);
		$finalfile = $NewZip->GenerateZip();

		$decodedsize = strlen($finalfile);

		$downloadfilename = $downloadfilename . ".zip";
		$type = "application/x-zip";
		$now = gmdate('D, d M Y H:i:s') . ' GMT';
	}

	ob_start();

	if ($_GET['submit'] == "inline") {
		header ("Cache-control: private"); 
		header("Content-type: " . strtolower($type));
		header ("Content-Disposition: inline; filename=\"$downloadfilename\"");
		header ("Content-Description: File Attachment"); 
	}
	else {
		// Bizarre Internet Explorer bug here.
		// If you try to use a content-disposition of attachment under SSL it fails
		// Unless you specify a blank cache-control and Pragma header
		// Under standard http all is OK.  Mozilla is not affected by this.
		// We recommend forwarding this to an HTTP connection rather than HTTPS

		// And then comment the five lines below
		header("Cache-Control: "); // leave blank to avoid IE errors
		header("Pragma: "); // leave blank to avoid IE errors
		header("Content-type: " . strtolower($type));
		header("Content-Disposition: attachment; filename=\"" . $downloadfilename . "\"");
		header("Content-Length: $decodedsize");
		header("Content-Description: File Attachment");
	}

	echo $finalfile;

	ob_end_flush();

}
$IMAPConnection->WM_IMAPClose();

?>