<?php
/*
############################################################################

############################################################################
*/

class HTMLCleanup {
	var $_body;

	function HTMLCleanup($body) {
		$this->_body = $body;
	}

	function ChangeTarget($target = "_blank") {
	        $this->_body = preg_replace('|<a([^>]*href=["\']?#)|i', "<HIDEBOOKMARK\\1", $this->_body);
        	$this->_body = str_replace("<a", "<a target=\"$target\"", $this->_body);
	        $this->_body = str_replace("<A", "<a target=\"$target\"", $this->_body);
        	$this->_body = preg_replace("|HIDEBOOKMARK|", "a", $this->_body);
	}

	function RemoveScripting() {
		// This function searches for INLINE scripting (<script> tags are removed by the RemoveMalicious() function).
		// inline scripting means <a href="javascript:function()"> or <a href="#" onclick="function()"> for example
		$regexpression = '/(&#0*61;?|&#x0*3D;?|=)\s*(&#0*34;?|&#x0*22;?|")?[^>]*\s*(&#0*115;?|&#x0*73;?|s)\s*(&#0*99;?|&#x0*63;?|c)\s*(&#0*114;?|&#x0*72;?|r)\s*(&#0*105;?|&#x0*69;?|i)\s*(&#0*112;?|&#x0*70;?|p)\s*(&#0*116;?|&#x0*74;?|t)\s*(&#0*58;?|&#x0*3A;?|:)/i';
		$this->_body = preg_replace($regexpression, "=\2cleaned", $this->_body);
		$this->_body = preg_replace("/(\s+[Oo][Nn]\w+)=/", "\1cleaned=", $this->_body);
	}

	function RemoveMalicious() {
		// This function removes malicious tags such as <script>, <embed>, <iframe>, and replaces it with <cleaned>
		$SearchArry = array("|<([^>]*)s\s*c\s*r\s*i\s*p\s*t|i",
			"|<([^>]*)iframe|i",
			"|<([^>]*)embed|i",
			"|<([^>]*)object|i"
		);
		$this->_body = preg_replace($SearchArry, "<cleaned", $this->_body);
	}

}

function parseLinks($content, $internal, $force = 0) {
	// This function takes the body of an email and auto links hyperlinks and email addresses
/*
	$SearchArry = array(
		"#(^|(?<=[^_a-z0-9-=\]\"'/]))((https?|ftp|gopher|news|telnet)://)((\[(?!/)|[^\s[()^$!`\"'|{}<>])+)(?=[,.]*([\n\s)[]|$))#siU",
		"#(^|(?<=[^_a-z0-9-=\]\"'/]))(www\.)((\[(?!/)|[^\s[()^$!`\"'|{}<>])+)(?=[,.]*([\s)[]|$))#siU",
		"/(^|(?<=[\r\n\t]))(www\.)([^ \r\n\(\)\^\$!`\"'\|\[\]\{\}<>]*)/si",
	);

	$ReplaceArry = array(
		"\\1<a href=\"\\2\\4\" target=\"blank\" title=\"Visit \\2\\4\">\\2\\4</a>",
		"\\1<a href=\"http://\\2\\3\" target=\"blank\" title=\"Visit http://\\2\\3\">\\2\\3</a>",
		"\\1<a href=\"http://\\2\\3\" target=\"blank\" title=\"Visit http://\\2\\3\">\\2\\3</a>"
	);
*/

	$SearchArry = array(
		"/([^]_a-z0-9-=\"'\/])(https?|ftp|gopher|news|telnet):\/\/([^ \r\n\(\)\^\$!`\"'\|\[\]\{\}<>]*)/si",
		"/^(https?|ftp|gopher|news|telnet):\/\/([^ \r\n\(\)\^\$!`\"'\|\[\]\{\}<>]*)/si",
		"#(^|(?<=[^_a-z0-9-=\]\"'/]))(www\.)((\[(?!/)|[^\s[()^$!`\"'|{}<>])+)(?=[,.]*([\s)[]|$))#siU",
		"/(^|(?<=[\r\n\t]))(www\.)([^ \r\n\(\)\^\$!`\"'\|\[\]\{\}<>]*)/si",
	);

	$ReplaceArry = array(
		"\\1<a href=\"\\2://\\3\" target=\"blank\" title=\"Visit \\2://\\3\">\\2://\\3</a>",
		"<a href=\"\\1://\\2\" target=\"blank\" title=\"Visit \\1://\\2\">\\1://\\2</a>",
		"\\1<a href=\"http://\\2\\3\" target=\"blank\" title=\"Visit http://\\2\\3\">\\2\\3</a>",
		"\\1<a href=\"http://\\2\\3\" target=\"blank\" title=\"Visit http://\\2\\3\">\\2\\3</a>"
	);

	$content = preg_replace($SearchArry, $ReplaceArry, $content);

	$emailSearchArry = array(
		"/([ <;\n\r\t])([_a-zA-Z0-9-]+(\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,4}))/si",
		"/^([_a-zA-Z0-9-]+(\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,4}))/si"
	);

	if ($internal <> 1) {
		$emailReplaceArry = array(
			"\\1<a href=\"mailto:\\2\">\\2</a>",
			"<a href=\"mailto:\\0\">\\0</a>"
		);
	}
	else {
		$MainSettings = new GlobalInit();
		$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');
		if ($force == 1) {
			$sessappend = "&amp;" . strip_tags(SID);
		}
		else {
			$sessappend = $MainSettings->SessAppend_noecho($TransIDEnabled, 0);
		}

		$langcomposemess = $lang['AutoComposeLink'];

		$emailReplaceArry = array(
			"\\1<a href=\"compose.php?newto=\\2$sessappend\" title=\"$langcomposemess \\2\">\\2</a>",
			"<a href=\"compose.php?newto=\\0$sessappend\" title=\"$langcomposemess \\0\">\\0</a>"
		);
	}
	if (strpos($content, "@")) {
		$content = preg_replace($emailSearchArry, $emailReplaceArry, $content);
	}
	return $content;
}

function unhtmlentities ($string) {
	$trans_tbl = get_html_translation_table (HTML_ENTITIES);
	$trans_tbl = array_flip ($trans_tbl);
	$ret = strtr ($string, $trans_tbl);
	return preg_replace('/&#(\d+);/me', "chr('\\1')", $ret);
}
?>
