<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");

require ("./includes/options.inc.php");

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SMove']['Title'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);
$PageFolders = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageFolders);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

$PageGenericMessage = $getFile->fileRead('generic_message');
$PageGenericMessage = str_replace("[pagetitle]", $lang['SMove']['Title'], $PageGenericMessage);

if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
	if ($_GET['df'] == "") {
		$returnmessage = $lang['SMove']['NoFolder'];
	}
	elseif ($_GET['selection'] == "") {
		$returnmessage = $lang['SMove']['NoMessage'];
	}
	else {
		$movemessages = $IMAPConnection->WM_IMAPMove($_GET['selection'], $_GET['df'], $CyrusIMAP);

		if ($movemessages == TRUE) {
			// Uncomment this next line if you want a delete success page instead of a redirect to the folder
			// $returnmessage = "Message(s) moved successfully";
		}
		else {
			$returnmessage = $lang['SErrors']['MoveError'];
		}
	}
}
else {
	$returnmessage = $lang['SErrors']['IMAPRequired'];
}

if ($returnmessage) {
	include ("./includes/folderpane.inc.php");
	$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
	$PageHeader = LangReplace('Generic', $PageHeader, $lang);
	$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
	$PageFooter = LangReplace('Generic', $PageFooter, $lang);
	$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
	echo $PageHeader;

	$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
	echo $PageGenericMessage;
	$IMAPConnection->WM_IMAPClose();
	echo $PageFooter;
}
else {
	$IMAPConnection->WM_IMAPClose();
	header("Location: ./mailbox.php?f=" . $_SESSION['folder'] . "&" . strip_tags(SID)); 
	exit;
}

?>