<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");
require ("./includes/browser.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/view.inc.php");

require ("./includes/options.inc.php");

$id = $_GET['id'];
$pid = $_GET['pid'];

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);

$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();
$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$allowzip = 0;
if (function_exists('gzcompress')) {
	$allowzip = 1;
	require ("./includes/zip.inc.php");
}

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

if (!empty($pid) && $pid >= 1) {

	require ("./includes/rfc822.inc.php");
	require ("./includes/3rdparty/MIME/mimeDecode.inc.php");

	$headerfull = $IMAPConnection->WM_IMAPRFCHeader($id);
	$bodyfull = $IMAPConnection->WM_IMAPGetBody($id, -1, -1, 1);

	$RFC822Message = new RFC822($_SESSION);
	$RFC822Parts = $RFC822Message->GetParts($headerfull, $bodyfull);

	$RFC822Content = $RFC822Parts[$pid];

	$params['include_bodies'] = true;
	$params['decode_bodies']  = true;
	$params['decode_headers'] = true;

	$RFCDecode = new Mail_mimeDecode($RFC822Content);
	$ReturnMessage = $RFCDecode->decode($params);

	// Get Standard Attachments
	$attachments = get_rfc_attachments($ReturnMessage);

	// Get Inline/Embedded Attachments
	$embeddedattachments = get_rfc_embeddedattachments($sections);

	// All attachments (it's possible that embedded attachments could duplicate standard attachments 'if' the disposition of 'inline' is not set
	if (is_array($attachments) && is_array($embeddedattachments)) {
		$allattachments = array_merge($attachments, $embeddedattachments);
	}
	elseif (is_array($embeddedattachments)) {
		$allattachments = $embeddedattachments;
	}
	else {
		$allattachments = $attachments;
	}

	$NewZip = new ZipCreate();

	while (list($key, $value) = each($allattachments)) {
		$filedescription = $allattachments[$key]->ctype_parameters['description'];
		$filename = $allattachments[$key]->ctype_parameters['name'];
		if ($filename == "") {
			$filename = urlencode($filedescription);
		}
		if ($filename == "") {
			$filename = urlencode($lang['SView']['NoAttachmentName']);
		}
		$finalfile = $allattachments[$key]->body;
		$NewZip->AddFile($finalfile, $filename);
		unset ($filename);
		unset ($filedescription);
		unset ($finalfile);
	}
}
elseif ($pid == 0 && !empty($pid)) {

	$NewZip = new ZipCreate();

	$structure = $IMAPConnection->WM_IMAPGetStructure($id);
	$encoding2 = $encoding[$structure->encoding];
	$encoding = $encoding2;
	$size = $structure->bytes;
	$filedescription = $structure->description;
	if ($structure->parameters) {
		foreach ($structure->parameters as $p2) {
			$filename = $p2->value;
		}
	}

	if (strtolower($structure->disposition) == "attachment" || strtolower($structure->disposition) == "inline") {
		$params = $structure->dparameters;
		if ($params) {
			foreach ($params as $p) {
				if($p->attribute == "FILENAME" || $p->attribute == "filename")	{
					$filename = $p->value;
					break;
				}
			}
		}
	}
	if ($filename == "") {
		$filename = urlencode($filedescription);
	}
	if ($filename == "") {
		$filename = urlencode($lang['SView']['NoAttachmentName']);
	}

	$attachment = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
	$finalfile = parseEncoding($attachment, $encoding);

	$NewZip->AddFile($finalfile, $filename);
	
}
else {
	$structure = $IMAPConnection->WM_IMAPGetStructure($id);
	$sections = parseBody($structure);

	// Get Standard Attachments
	$attachments = get_attachments($sections);

	// Get Inline/Embedded Attachments
	$embeddedattachments = get_embeddedattachments($sections);

	// All attachments (it's possible that embedded attachments could duplicate standard attachments 'if' the disposition of 'inline' is not set
	if (is_array($attachments) && is_array($embeddedattachments)) {
		$allattachments = array_merge($attachments, $embeddedattachments);
	}
	elseif (is_array($embeddedattachments)) {
		$allattachments = $embeddedattachments;
	}
	else {
		$allattachments = $attachments;
	}

	$NewZip = new ZipCreate();

	for($x=0; $x<sizeof($allattachments); $x++) {
		for($x1=0; $x1<sizeof($sections); $x1++) {
			if($sections[$x1]["pid"] == $allattachments[$x]['pid']) {
				$encoding = $sections[$x1]["encoding"];
				$filedescription = $sections[$x1]["description"];
				$filename = $sections[$x1]["name"];
				if ($filename == "") {
					$filename = urlencode($filedescription);
				}
				if ($filename == "") {
					$filename = urlencode($lang['SView']['NoAttachmentName']);
				}

				$attachment = $IMAPConnection->WM_IMAPGetBody($id, $allattachments[$x]['pid'], -1);
				$finalfile = parseEncoding($attachment, $encoding);
				$NewZip->AddFile($finalfile, $filename);
				unset ($attachment);
				unset ($encoding);
				unset ($filename);
				unset ($filedescription);
				unset ($finalfile);
			}
		}
	}
}

$finalzip = $NewZip->GenerateZip();
$decodedsize = strlen($finalzip);
$downloadfilename = "attachments_" . $id . ".zip";
$type = "application/x-zip";
$now = gmdate('D, d M Y H:i:s') . ' GMT';

header("Cache-Control: "); // leave blank to avoid IE errors
header("Pragma: "); // leave blank to avoid IE errors
header("Content-type: $type");
header("Content-Disposition: attachment; filename=\"".$downloadfilename."\"");
header("Content-Length: $decodedsize");
header("Content-Description: File Attachment");
echo $finalzip;

$IMAPConnection->WM_IMAPClose();

?>