<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/login.inc.php");

require ("./includes/options.inc.php");

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SExternal']['Title'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);
$PageFolders = str_replace("[session]", $MainSettings->SessAppend_form($TransIDEnabled), $PageFolders);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

if ($_GET['mode']) {
	$mode = $_GET['mode'];
}
elseif ($_POST['mode']) {
	$mode = $_POST['mode'];
}
else {
	$mode = "check";
}

if ($UseDatabase == 1) {
	if ($AllowExternal == 1) {
	if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
		if ($MySQLMakeConnection) {
			$externallist = $MySQLConnection->DB_GetExternalList();
			if (is_array($externallist) && $_REQUEST['mode'] <> 'update') {
				$countexternal = sizeof($externallist);
				if ($mode == "check" && $countexternal >= 1) {
					// We are in check mode AND we have at least one account defined
					// To do this we form a SECOND connnection under a new class

					$e = $_GET['e'];
					if ($e == "") {
						// If we haven't started yet we display an initial interstitial page for the first account
						// and then redirect to the real work
						$e = 0;

						include ("./includes/folderpane.inc.php");
						$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
						$PageHeader = LangReplace('Generic', $PageHeader, $lang);
						$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
						$PageFooter = LangReplace('Generic', $PageFooter, $lang);
						$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);
						$PageHeader = str_replace("[header_refresh]", "<meta http-equiv=\"refresh\" content=\"0;URL=external.php?e=" . $e . "&" . strip_tags(SID) . "\" />", $PageHeader);

						$PageGenericMessage = $getFile->fileRead('generic_message');
						$PageGenericMessage = str_replace("[pagetitle]", $lang['SExternal']['Title'], $PageGenericMessage);

						$PageExternal = $getFile->fileRead('db_checkexternal_interstitial');
						$PageExternal = str_replace("[external_username]", $externallist[$e]['sess_u'], $PageExternal);
						$PageExternal = str_replace("[external_server]", $externallist[$e]['mailserver'], $PageExternal);

						$PageGenericMessage = str_replace("[pagemessage]", $PageExternal, $PageGenericMessage);

						header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
						echo $PageHeader;
						$PageGenericMessage = LangReplace('SExternal', $PageGenericMessage, $lang);
						echo $PageGenericMessage;
						echo $PageFooter;
					}
					else {
						// This is where we check the account for the parsed value of e in the array $externallist
						// Increment e by one, test if it is the SAME as $countexternal and if so redirect to mailbox.php,
						// otherwise display another interstitial page and repeat the process
						$ExternalIMAPConnection = new WM_IMAPConnection($externallist[$e]);
						$ExternalIMAPConnection->_compatibilitymode = $compatibilitymode;
						$ExternalMailbox = $ExternalIMAPConnection->WM_IMAPConnect();
						checkexternal_active($ExternalMailbox, $ExternalIMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

						// Get Email from INBOX in $ExternalMailbox and append it to INBOX in $mailbox
						$numberofmessages = $ExternalIMAPConnection->WM_IMAPNumMessages();
						$sortmessages = $ExternalIMAPConnection->WM_IMAPList(1, $numberofmessages, 0, 0);
						if ($sortmessages <> "") {
							while(list($key, $value) = each($sortmessages)) { 
								$header = $ExternalIMAPConnection->WM_IMAPRFCHeader($sortmessages[$key]['message_uid']);
								$body = $ExternalIMAPConnection->WM_IMAPGetBody($sortmessages[$key]['message_uid'], -1, -1);
								$copymessage = $IMAPConnection->WM_IMAPCopy('INBOX', $CyrusIMAP, $header, $body);
								if ($externallist[$e]['leave'] == 0) {
									// Delete messages off server
									$ExternalIMAPConnection->WM_IMAPDelete($sortmessages[$key]['message_uid']);
								}
								unset ($header);
								unset ($body);
							}
						}
						if ($externallist[$e]['leave'] == 0) {
							$ExternalIMAPConnection->WM_IMAPExpungeMailbox();
						}

						$ExternalIMAPConnection->WM_IMAPClose();

						$e++;
						if ($e == $countexternal) {
							// Redirect to mailbox.php after the work is done
							header ("Location: ./mailbox.php?f=INBOX&" . strip_tags(SID));
						}
						else {

							// Display interstitial redirect page for next account
							include ("./includes/folderpane.inc.php");
							$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
							$PageHeader = LangReplace('Generic', $PageHeader, $lang);
							$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
							$PageFooter = LangReplace('Generic', $PageFooter, $lang);
							$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

							$PageHeader = str_replace("[header_refresh]", "<meta http-equiv=\"refresh\" content=\"0;URL=external.php?e=" . $e . "&" . strip_tags(SID) . "\" />", $PageHeader);
							$PageGenericMessage = $getFile->fileRead('generic_message');
							$PageGenericMessage = str_replace("[pagetitle]", $lang['SExternal']['Title'], $PageGenericMessage);

							$PageExternal = $getFile->fileRead('db_checkexternal_interstitial');
							$PageExternal = str_replace("[external_username]", $externallist[$e]['sess_u'], $PageExternal);
							$PageExternal = str_replace("[external_server]", $externallist[$e]['mailserver'], $PageExternal);

							$PageGenericMessage = str_replace("[pagemessage]", $PageExternal, $PageGenericMessage);

							header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
							echo $PageHeader;
							$PageGenericMessage = LangReplace('SExternal', $PageGenericMessage, $lang);
							echo $PageGenericMessage;
							echo $PageFooter;
						}
					}
					
				}
				else {
					// This is the settings mode

					// Why are we calling folderpane.inc.php a number of times?
					// Because this page alters the number of emails in the INBOX we must call folderpane.inc.php
					// AFTER all email moving has taken place, otherwise the folder totals will be inaccurate
					include ("./includes/folderpane.inc.php");
					$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
					$PageHeader = LangReplace('Generic', $PageHeader, $lang);
					$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
					$PageFooter = LangReplace('Generic', $PageFooter, $lang);
					$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

					$PageExternal = $getFile->fileRead('db_checkexternal_settings');
					$PageExternalList = $getFile->fileRead('db_checkexternal_accountlist');
					$PageExternalAccountList == '';

					for ($ln=0; $ln<sizeof($externallist); $ln++) {
						$PageExternalTmp = $PageExternalList;

						$PageExternalTmp = str_replace("[external_username]" , '<input type="text" name="u[' . $ln . ']" value="' . $externallist[$ln]['sess_u'] . '" />', $PageExternalTmp);
						$PageExternalTmp = str_replace("[external_password]" , '<input type="password" name="p[' . $ln . ']" value="' . $externallist[$ln]['sess_p'] . '" />', $PageExternalTmp);
						$PageExternalTmp = str_replace("[external_server]" , '<input type="text" name="m[' . $ln . ']" value="' . $externallist[$ln]['mailserver'] . '" />', $PageExternalTmp);
						if ($externallist[$ln]['portnumber'] == "") {
							$PageExternalTmp = str_replace("[external_port]" , '<input type="text" name="pn[' . $ln . ']" value="110" />', $PageExternalTmp);
						}
						else {
							$PageExternalTmp = str_replace("[external_port]" , '<input type="text" name="pn[' . $ln . ']" value="' . $externallist[$ln]['portnumber'] . '" />', $PageExternalTmp);
						}
						if ($externallist[$ln]['leave'] <> "1" && isset($externallist[$ln]['leave'])) {
							$PageExternalTmp = str_replace("[external_leave]" , '<input type="checkbox" name="l[' . $ln . ']" value="1" />', $PageExternalTmp);
						}
						else {
							$PageExternalTmp = str_replace("[external_leave]" , '<input type="checkbox" name="l[' . $ln . ']" value="1" checked="checked" />', $PageExternalTmp);
						}
						if ($externallist[$ln]['servertype'] <> "imap" && isset($externallist[$ln]['servertype'])) {
							$PageExternalTmp = str_replace("[external_servertype]" , '<input type="radio" name="t[' . $ln . ']" value="pop3" checked="checked" /> POP3 <input type="radio" name="t[' . $ln . ']" value="imap" /> IMAP4', $PageExternalTmp);
						}
						else {
							$PageExternalTmp = str_replace("[external_servertype]" , '<input type="radio" name="t[' . $ln . ']" value="pop3" /> POP3 <input type="radio" name="t[' . $ln . ']" value="imap" checked="checked" /> IMAP4', $PageExternalTmp);
						}
						$PageExternalTmp = str_replace("[accountnumber]" , ($ln + 1), $PageExternalTmp);
						$PageExternalAccountList .= $PageExternalTmp;
						unset ($PageExternalTmp);
					}

					$PageExternalList = str_replace("[external_username]" , '<input type="text" name="u[' . sizeof($externallist) . ']" value="" />', $PageExternalList);
					$PageExternalList = str_replace("[external_password]" , '<input type="password" name="p[' . sizeof($externallist) . ']" value="" />', $PageExternalList);
					$PageExternalList = str_replace("[external_server]" , '<input type="text" name="m[' . sizeof($externallist) . ']" value="" />', $PageExternalList);
					$PageExternalList = str_replace("[external_port]" , '<input type="text" name="pn[' . sizeof($externallist) . ']" value="110" />', $PageExternalList);
					$PageExternalList = str_replace("[external_leave]" , '<input type="checkbox" name="l[' . sizeof($externallist) . ']" value="1" checked="checked" />', $PageExternalList);
					$PageExternalList = str_replace("[external_servertype]" , '<input type="radio" name="t[' . sizeof($externallist) . ']" value="pop3" checked="checked" /> POP3 <input type="radio" name="t[' . sizeof($externallist) . ']" value="imap" /> IMAP4', $PageExternalList);
					$PageExternalList = str_replace("[accountnumber]" , (sizeof($externallist) + 1), $PageExternalList);

					$PageExternalAccountList .= $PageExternalList;

					$PageExternal = str_replace("[externalaccounts]" , $PageExternalAccountList, $PageExternal);
					
					$PageExternal = str_replace("[session_form]" , $MainSettings->SessAppend_form($TransIDEnabled), $PageExternal);

					$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
					header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
					echo $PageHeader;
					$PageExternal = LangReplace('SExternal', $PageExternal, $lang);
					echo $PageExternal;
					echo $PageFooter;

				}
			}
			elseif ($_REQUEST['mode'] == 'update') {
				for ($ln=0; $ln<sizeof($_POST['u']); $ln++) {

					$externallist_update[$ln]['sess_u'] = strip_tags($_POST['u'][$ln]);
					$externallist_update[$ln]['sess_p'] = strip_tags($_POST['p'][$ln]);
					$externallist_update[$ln]['mailserver'] = strip_tags($_POST['m'][$ln]);
					$externallist_update[$ln]['portnumber'] = strip_tags($_POST['pn'][$ln]);
					$externallist_update[$ln]['servertype'] = strip_tags($_POST['t'][$ln]);
					if (strip_tags($_POST['l'][$ln]) <> 1) {
						$externallist_update[$ln]['leave'] = 0;
					}
					else {
						$externallist_update[$ln]['leave'] = 1;
					}
				}

				$updatelist = $MySQLConnection->DB_UpdateExternalList($externallist_update);
				header ("Location: ./options.php?" . strip_tags(SID));
				
			}
			else {
				include ("./includes/folderpane.inc.php");
				$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
				$PageHeader = LangReplace('Generic', $PageHeader, $lang);
				$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
				$PageFooter = LangReplace('Generic', $PageFooter, $lang);
				$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

				$PageExternal = $getFile->fileRead('db_checkexternal_settings');
				$PageExternalList = $getFile->fileRead('db_checkexternal_accountlist');

				$PageExternal = str_replace("[externalaccounts]" , $PageExternalList, $PageExternal);

				$PageExternal = str_replace("[external_username]" , '<input type="text" name="u[]" value="" />', $PageExternal);
				$PageExternal = str_replace("[external_password]" , '<input type="password" name="p[]" value="" />', $PageExternal);
				$PageExternal = str_replace("[external_server]" , '<input type="text" name="m[]" value="" />', $PageExternal);
				$PageExternal = str_replace("[external_port]" , '<input type="text" name="pn[]" value="110" />', $PageExternal);
				$PageExternal = str_replace("[external_leave]" , '<input type="checkbox" name="l[]" value="1" checked="checked" />', $PageExternal);
				$PageExternal = str_replace("[external_servertype]" , '<input type="radio" name="t[]" value="pop3" checked="checked" /> POP3 <input type="radio" name="t[]" value="imap" /> IMAP4', $PageExternal);
				$PageExternal = str_replace("[accountnumber]" , '1', $PageExternal);

				$PageExternal = str_replace("[session_form]" , $MainSettings->SessAppend_form($TransIDEnabled), $PageExternal);

				$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
				header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
				echo $PageHeader;
				$PageExternal = LangReplace('SExternal', $PageExternal, $lang);
				echo $PageExternal;
				echo $PageFooter;
			}
		}
	}
	else {
		// IMAP Disabled
		include ("./includes/folderpane.inc.php");
		$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
		$PageHeader = LangReplace('Generic', $PageHeader, $lang);
		$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
		$PageFooter = LangReplace('Generic', $PageFooter, $lang);
		$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

		$PageGenericMessage = $getFile->fileRead('generic_message');
		$PageGenericMessage = str_replace("[pagetitle]", $lang['SExternal']['Title'], $PageGenericMessage);
		$PageGenericMessage = str_replace("[pagemessage]", $lang['SErrors']['ExternalIMAP'], $PageGenericMessage);

		$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageGenericMessage;
		echo $PageFooter;
	}
	}
	else {
		// External Checking disabled
		include ("./includes/folderpane.inc.php");
		$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
		$PageHeader = LangReplace('Generic', $PageHeader, $lang);
		$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
		$PageFooter = LangReplace('Generic', $PageFooter, $lang);
		$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

		$PageGenericMessage = $getFile->fileRead('generic_message');
		$ExternalError = $lang['SErrors']['ExternalDisabled'];
		$PageGenericMessage = str_replace("[pagetitle]", $lang['SExternal']['Title'], $PageGenericMessage);
		$PageGenericMessage = str_replace("[pagemessage]", $ExternalError, $PageGenericMessage);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
		echo $PageHeader;
		echo $PageGenericMessage;
		echo $PageFooter;
	}

}
else {
	// Database mode disabled
	include ("./includes/folderpane.inc.php");
	$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
	$PageHeader = LangReplace('Generic', $PageHeader, $lang);
	$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
	$PageFooter = LangReplace('Generic', $PageFooter, $lang);
	$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

	$PageGenericMessage = $getFile->fileRead('generic_message');
	$DatabaseError = $lang['SErrors']['Database'];
	$PageGenericMessage = str_replace("[pagetitle]", $lang['SExternal']['Title'], $PageGenericMessage);
	$PageGenericMessage = str_replace("[pagemessage]", $DatabaseError, $PageGenericMessage);

	$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
	echo $PageHeader;
	echo $PageGenericMessage;
	echo $PageFooter;
}

$IMAPConnection->WM_IMAPClose();
?>