<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");

require ("./includes/options.inc.php");

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageFolders = $getFile->fileRead('folders');
$PageFolderList = $getFile->fileRead('folderlist');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SFolders']['Title'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);
$PageFolders = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageFolders);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

include ("./includes/folderpane.inc.php");
$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);
header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
echo $PageHeader;

$PageGenericMessage = $getFile->fileRead('generic_message');
$PageGenericMessage = str_replace("[pagetitle]", $lang['Folders'], $PageGenericMessage);

$IMAPConnection->WM_IMAPClose();

if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {

	if (!$_REQUEST['mode']) {

		$mailbox = $IMAPConnection->WM_IMAPConnect();
		$folderget = $IMAPConnection->WM_IMAPFolders($IMAPSubscriptions);
		$folders = $IMAPConnection->_folders;
		sort($folders);
		$folderselect = "<select name=\"folderselect\"><option value=\"\">" . $lang['SFolders']['RootFolder'] . "</option>";
		$folderselect2 = "<select name=\"currentname\">";


		
for($i=0; $i<count($folders); $i++) {
			$mailbox = $IMAPConnection->WM_IMAPClose();
			$_SESSION['folder'] = $folders[$i]['id'];
			$IMAPConnection->_sessionvars = $_SESSION;
			$mailbox = $IMAPConnection->WM_IMAPConnect();
			$mailboxinfo = $IMAPConnection->WM_IMAPMailboxInfo();
			if ($mailboxinfo->Size >= 1073741824) { 
				$mailboxsize = round(round($mailboxinfo->Size / 1073741824 * 100) / 100) . " Gb"; 
			}
			elseif ($mailboxinfo->Size >= 1048576) { 
				$mailboxsize = round(round($mailboxinfo->Size / 1048576 * 100) / 100) . " Mb"; 
			}
			elseif ($mailboxinfo->Size >= 1024) { 
				$mailboxsize = round(round($mailboxinfo->Size / 1024 * 100) / 100) . " Kb"; 
			}
			else { 
				$mailboxsize = round($mailboxinfo->Size) . " b"; 
			}

			$currentfolder = str_replace("[foldertotal]", $mailboxinfo->Nmsgs, $PageFolderList);
			$currentfolder = str_replace("[foldersize]", $mailboxsize, $currentfolder);
			$currentfolder = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $currentfolder);
			$currentfolder = str_replace("[session_force]", "&amp;" . strip_tags(SID), $currentfolder);
			$currentfolder = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $currentfolder);
			$currentfolder = str_replace("[folderid]", urlencode($folders[$i]['id']), $currentfolder);
			$currentfolder = str_replace("[entry_number]", $folders[$i]['id'], $currentfolder);
			$currentfolder = str_replace("[foldername]", str_replace($IMAPConnection->_folderdelimiter, " &raquo; ", str_replace("INBOX" . $IMAPConnection->_folderdelimiter, '', $folders[$i]['name'])), $currentfolder);
			$currentfolder = str_replace("[rowcolor]", "col1", $currentfolder);
			if ($folders[$i]['name'] == $Trsh) {
				$currentfolder = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_trash.gif\" border=\"0\" alt=\"" . str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $folders[$i]['name']) . "\" />", $currentfolder);
			}
			elseif ($folders[$i]['name'] == $Outbx) {
				$currentfolder = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_sent.gif\" border=\"0\" alt=\"" . str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $folders[$i]['name']) . "\" />", $currentfolder);
			}
			elseif ($folders[$i]['name'] == $Inbx) {
				$currentfolder = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_inbox.gif\" border=\"0\" alt=\"" . str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $folders[$i]['name']) . "\" />", $currentfolder);
			}
			elseif ($folders[$i]['name'] == $Drf) {
				$currentfolder = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_drafts.gif\" border=\"0\" alt=\"" . str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $folders[$i]['name']) . "\" />", $currentfolder);
			}
			else {
				$currentfolder = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_blank.gif\" border=\"0\" alt=\"" . str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $folders[$i]['name']) . "\" />", $currentfolder);
			}
			if ($folders[$i]['name'] == 'INBOX' || $folders[$i]['name'] == $IMAPSentMail || $folders[$i]['name'] == $IMAPTrash || $folders[$i]['name'] == $IMAPDrafts) {
				$currentfolder = preg_replace("/(\[)(ifselectable)(])(\r\n)*(.*)(\[\/ifselectable\])/siU", "", $currentfolder);
			}
			else {
				$currentfolder = str_replace("[ifselectable]", "", $currentfolder);
				$currentfolder = str_replace("[/ifselectable]", "", $currentfolder);
			}

			$generatefolders .= $currentfolder;

			$folderselect .= "<option value=\"" . $folders[$i]['id'] . "\"";
			if ($folders[$i]['id'] == "INBOX") {
				$folderselect .= " selected=\"selected\"";
			}
			$folderselect .= ">" . $folders[$i]['name'] ."</option>\n";

			if ($folders[$i]['name'] <> 'INBOX' && $folders[$i]['name'] <> $IMAPSentMail && $folders[$i]['name'] <> $IMAPTrash && $folders[$i]['name'] <> $IMAPDrafts) {
				$folderselect2 .= "<option value=\"" . $folders[$i]['id'] . "\"";
				$folderselect2 .= ">" . str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $folders[$i]['name']) ."</option>\n";
			}

		}
		

		
		
		
		
		$folderselect .= "</select>\n";
		$folderselect2 .= "</select>\n";

		$PageFolders = str_replace("[folderlist]", $generatefolders, $PageFolders);
		$PageFolders = str_replace("[renamelist]", $folderselect2, $PageFolders);
		$PageFolders = str_replace("[folderselect]", $folderselect, $PageFolders);

		if ($IMAPSubscriptions == 1) {
			$PageFolders = str_replace("[ifsubscriptions]", "", $PageFolders);
			$PageFolders = str_replace("[/ifsubscriptions]", "", $PageFolders);
		}
		else {
			$PageFolders = preg_replace("/(\[)(ifsubscriptions)(])(\r\n)*(.*)(\[\/ifsubscriptions\])/siU", "", $PageFolders);
		}

		$IMAPConnection->WM_IMAPClose();

		// Reset folder to inbox otherwise we will have problems with search
		$_SESSION['folder'] = "INBOX";
		$IMAPConnection->_sessionvars = $_SESSION;
		$mailbox = $IMAPConnection->WM_IMAPConnect();
		$IMAPConnection->WM_IMAPClose();
	}
	elseif ($_REQUEST['mode'] == "delete") {
		$mailbox = $IMAPConnection->WM_IMAPHalfConnect();
		if ($_GET['f'] == "INBOX") {
			$returnmessage = $lang['SFolders']['DeleteInbox'];
		}
		else {
			$folder = strip_tags(trim($_GET['f']));
			$deletefolder = $IMAPConnection->WM_IMAPFolderDelete($folder, $CyrusIMAP);
			if ($deletefolder == TRUE && !is_array($deletefolder)) {
				$returnmessage = $lang['SFolders']['FolderDelete'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
			else {
				if (is_array($deletefolder)) {
					$imapreturn = $lang['SErrors']['IMAPError'] . ": '" . implode("<br />\n", $deletefolder) . "'";
				}
				$returnmessage = $lang['SFolders']['FolderDeleteError'] . "  $imapreturn <br /><br />  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
		}

		$IMAPConnection->WM_IMAPClose();
		$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
	}
	elseif ($_REQUEST['mode'] == "deleteselection") {
		$mailbox = $IMAPConnection->WM_IMAPHalfConnect();

		if ($_GET['f'] == "INBOX") {
			$returnmessage = $lang['SFolders']['DeleteInbox'];
		}
		else {
			// Delete a selection of folders

			$deleteerrors = 0;

			if ($_POST['selection'] <> "") {
				if (is_array($_POST['selection'])) {
					while(list($key, $value) = each($_POST['selection'])) { 
						$currentkey = urldecode(stripslashes($key));
						$currentkey2 = substr($currentkey, 1, (strlen($currentkey) -2));
						$deletefolder = $IMAPConnection->WM_IMAPFolderDelete($currentkey2, $CyrusIMAP);
						if ($deletefolder == TRUE && !is_array($deletefolder)) {
						}
						else {
							$deleteerrors .= implode("<br />\n", $deletefolder);
						}
						unset ($deletefolder);
						unset ($currentkey);
					}
				}
			}

			if ($deleteerrors <> 0) {
				$imapreturn = $lang['SErrors']['IMAPError'] . ": '" . $deleteerrors . "'";
				$returnmessage = $lang['SFolders']['FolderDeleteError'] . "  $imapreturn <br /><br />  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
			else {
				$returnmessage = $lang['SFolders']['FolderDelete'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
		}


		$IMAPConnection->WM_IMAPClose();
		$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
	}
	elseif ($_REQUEST['mode'] == "unsubscribe") {
		$mailbox = $IMAPConnection->WM_IMAPHalfConnect();

		if ($_GET['f'] == "INBOX") {
		}
		else {
			// Unsubscribe from a selection of folders

			$unsuberrors = 0;

			if ($_POST['selection'] <> "") {
				if (is_array($_POST['selection'])) {
					while(list($key, $value) = each($_POST['selection'])) { 
						$currentkey = urldecode(stripslashes($key));
						$currentkey2 = substr($currentkey, 1, (strlen($currentkey) -2));
						$unsubfolder = $IMAPConnection->WM_IMAPFolderUnsubscribe($currentkey2);
						if ($unsubfolder == TRUE && !is_array($unsubfolder)) {
						}
						else {
							$unsuberrors .= implode("<br />\n", $unsubfolder);
						}
						unset ($unsubfolder);
						unset ($currentkey);
					}
				}
			}

			if ($unsuberrors <> 0) {
				$imapreturn = $lang['SErrors']['IMAPError'] . ": '" . $unsuberrors . "'";
				$returnmessage = $lang['SFolders']['FolderUnsubError'] . "  $imapreturn <br /><br />  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
			else {
				$returnmessage = $lang['SFolders']['FolderUnsub'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
		}


		$IMAPConnection->WM_IMAPClose();
		$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
	}
	elseif ($_REQUEST['mode'] == "subscribe") {
		$mailbox = $IMAPConnection->WM_IMAPConnect();
		$foldername = strip_tags(trim($_POST['foldername']));
		if ($foldername == "" || $foldername == "INBOX" . $IMAPConnection->_folderdelimiter) {
			$returnmessage = $lang['SFolders']['FolderNewName'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
		}
		else {
			$subfolder = $IMAPConnection->WM_IMAPFolderSubscribe($foldername, '');
			if ($subfolder == TRUE && !is_array($subfolder)) {
				$returnmessage = $lang['SFolders']['FolderSub'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
			else {
				if (is_array($subfolder)) {
					$imapreturn = $lang['SErrors']['IMAPError'] . ": '" . implode("<br />\n", $subfolder) . "'";
				}
				$returnmessage = $lang['SFolders']['FolderSubError'] . " $imapreturn <br /><br />  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
		}

		$IMAPConnection->WM_IMAPClose();
		$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
	}
	elseif ($_REQUEST['mode'] == "rename") {

		$mailbox = $IMAPConnection->WM_IMAPHalfConnect();
		if (trim(urldecode($_POST['newname'])) == "") {
			$returnmessage = $lang['FolderNewName'];
		}
		elseif (trim(urldecode($_POST['currentname'])) == "INBOX") {
			$returnmessage = $lang['FolderInbox'];
		}
		else {
			$currentfolder = strip_tags(trim($_POST['currentname']));
			$newfolder = strip_tags(trim($_POST['newname']));

			$renamefolder = $IMAPConnection->WM_IMAPFolderRename($currentfolder, $newfolder);
			if ($renamefolder == TRUE && !is_array($renamefolder)) {
				$returnmessage = $lang['SFolders']['FolderRename'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
			else {
				if (is_array($renamefolder)) {
					$imapreturn = $lang['SErrors']['IMAPError'] . ": '" . implode("<br />\n", $renamefolder) . "'";
				}
				$returnmessage = $lang['SFolders']['FolderRenameError'] . " $imapreturn <br /><br />  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
		}

		$IMAPConnection->WM_IMAPClose();
		$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

	}
	elseif ($_REQUEST['mode'] == "create") {
		$mailbox = $IMAPConnection->WM_IMAPConnect();
		$foldername = strip_tags(trim($_POST['foldername']));
		$folderselect = strip_tags(trim($_POST['folderselect']));
		if ($foldername == "") {
			$returnmessage = $lang['SFolders']['FolderNewName'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
		}
		else {
			$createfolder = $IMAPConnection->WM_IMAPFolderCreate($foldername, $folderselect);
			if ($createfolder == TRUE && !is_array($createfolder)) {
				if ($IMAPSubscriptions == 1) {
					$subscribefolder = $IMAPConnection->WM_IMAPFolderSubscribe($foldername, $folderselect);
				}
				$returnmessage = $lang['SFolders']['FolderCreate'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
			else {
				if (is_array($createfolder)) {
					$imapreturn = $lang['SErrors']['IMAPError'] . ": '" . implode("<br />\n", $createfolder) . "'";
				}
				$returnmessage = $lang['SFolders']['FolderCreateError'] . " $imapreturn <br /><br />" . $lang['SFolders']['FolderCreateErrorDesc'] . "  <a href=\"folders.php" . $MainSettings->SessAppend_noecho($TransIDEnabled, 1) . "\">" . $lang['SFolders']['FolderBack'] . "</a>";
			}
		}

		$IMAPConnection->WM_IMAPClose();
		$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
	}
}
else {
	$returnmessage = $lang['SErrors']['IMAPRequired'];
	$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
}

if (!$_REQUEST['mode'] && ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl")) {
	$PageFolders = LangReplace('SFolders', $PageFolders, $lang);
	echo $PageFolders;
}
else {
	$PageGenericMessage = LangReplace('SFolders', $PageGenericMessage, $lang);
	echo $PageGenericMessage;
}

echo $PageFooter;

?>