<?php
/*
// Config.inc.php
// This is the only file you need to edit to get DWmail working
// on your server.  You may also wish to edit the files in the 
// ./templates/ directory to intergrate into your site design

// Not every configuration option that can be used are in this file with
// a default installation.  Look in options.inc.php for user preferences
// that can be set in this file in addition to the options below

// ############ PROTOCOL CONFIGURATION ############

// Default ports
// Default for POP3 is 110
// Default for IMAP4 is 143
// Default for POP3/SSL is 995
// Default for IMAP4/SSL is 993

$DefaultPOP3Port = 110;
$DefaultIMAPPort = 143;
$DefaultPOP3SSLPort = 995;
$DefaultIMAPSSLPort = 993;

// Default server type
// This is the protocol which will be used if a server type is not
// specified in advanced login
// Valid settings:
// - pop3 (default)
// - imap
// - pop3ssl (not recommended as a default)
// - imapssl (not recommended as a default)

$DefaultType = 'imap';

// Allow SSL connections
// you will need the SSL ports open though any firewall that you may have
// You will additionally need --with-imap-ssl configured to PHP to use this
// Valid settings:
// 1 - enable
// 0 - disable (default)

$AllowSSLConnections = 0;


// ############ ABUSE PREVENTION SETTINGS ############

// Flood filter in seconds
// This limits the amount of time in between
// email sends.  This is to help prevent sending spam through your mail
// server. Default is 30 seconds

$floodfilter = 5;

// Maximum number of recipients
// How many email addresses can a single email be sent to
// Total of to:, cc: and bcc fields
// Default: 50

$recipientmaximum = 500;

// Advanced spoofing protection
// By default in the advanced login you can enter any email address
// you like.  Spoof protection checks that the domain after the @
// is contained in the mail server details
// This means that the part in front of the @ can still set to something
// different but at the very least the domain will be correct
// This will only be used if 1) advanced login is used and 2) DWmail is in remote mode

// 1 - Enable (default)
// 0 - Disable

$SpoofProtection = 0;


// ############ GENERAL SETTINGS ############

// Allow user to send email attachments
// Note: your PHP must be able to accept file uploads and open_basedir have access
// to the upload directory (usually /tmp)
// Messages with attachments will be sent as Multipart, messages without will be sent as plain
// 1 - Allow Attachments
// 0 - Disallow Attachments

$AllowAttachments = 1;

// Number of attachment boxes
// Limit the number of attachments people can send in compose.php
// Default: 2

$AttachmentNumber = 5;

// Append a signature to the bottom of every email?
// 1 - Yes
// 0 - No

$AppendSignature = 0;

// Allow read receipts?
// Useful for IMAP connections, however with POP3 connections the email always displays
// as a new message so always asks if you wish to send a reciept
// This function makes use of pop-up windows.  Software such as Norton Internet Security
// Opera pop-up blocker may conflict with this functionality.
// 1 - Will ask about read receipts
// 0 - Ignore read receipts (default)

$AllowReadReceipts = 0;

// Which template set to use
// Template sets are stored in directories off the main templates directory
// e.g. if you create a template set directory called mytemplate then you 
// enter 'mytemplate' below
// Default template is 'silver'

$DefaultTemplate = 'silver';

// Set the default session cache properties
// See http://www.php.net/manual/en/ref.session.php#ini.session.cache-limiter
// for allowable values, however we recommend the following
// 'nocache' - don't cache pages in the browser (default)

$DefaultSessionCache = 'nocache';

// Default domain name
// If someone only enters a username into the login box (i.e. no @ or anything after it)
// DWmail will automatically append the following domain name to that username.
// Very useful for ISP based webmail
// Default setting - localhost

$DefaultDomain = 'mail.ru';

// Interstitial page
// Make use of an temporary refresh page when logging in
// 1 - Yes (default)
// 0 - No

$InterstitialLogin = 1;

// Enable Statistic Logging
// Logs all successful logins to the system by a timestamp
// 1 - Yes
// 0 - No (default)

$StatsLogging = 0;

// Log IP addresses
// If $StatsLogging is enabled you can optionally log all access attempts against IP
// address.  If you enable this setting you should make your users aware that you are capturing
// this informationn
// 1 - Yes
// 0 - No (default)

$IPLogging = 0;

// Available languages array
// This generates a list of available languages in the format
// e.g. $AvailLangs['en']['charset'] = 'iso-8859-1';
// And language array entry must be defined by it's ISO country code and contain
// 'charset', 'desc' and 'spell' options.
//   'charset' is the characterset
//   'desc' is the displayed name of the language
//   'spell' is subdivided into enable and dictionary charset (this is often slightly different to the HTML charset)
//   'locale' is the PHP compatible locale for the language e.g. en_GB, fr_FR, etc
//   See http://aspell.sourceforge.net/man-html/7_Adding.html for information about adding
//   other languages to the aspell program
//
// Note: DWmail only ships with the English language files at present, see readme.txt
// in the 'lang' directory for more information
//
// Note: DWmail has NOT been tested with multibyte language handling

$AvailLangs['en']['charset'] = 'iso-8859-1';
$AvailLangs['en']['desc'] = 'English';
$AvailLangs['en']['spell']['enable'] = 0;
$AvailLangs['en']['spell']['charset'] = 'iso8859-1';
$AvailLangs['en']['locale'] = 'en_GB';

$AvailLangs['ru']['charset'] = 'win-1251';
$AvailLangs['ru']['desc'] = 'Russian';
$AvailLangs['ru']['spell']['enable'] = 1;
$AvailLangs['ru']['spell']['charset'] = 'win-1251';
$AvailLangs['ru']['locale'] = 'ru_USSR';
// Default language file
// The key from the $AvailLangs array
// e.g. for $AvailLangs['en'] use 'en' below

$DefaultLang = 'ru';

// ############ DISPLAY SETTINGS ############

// Messages per page
// How many messages to display per page.
// Default - 25

$messagesperpage = 25;

// HTML email settings
// This allows you to set HTML emails to one of four settings
// 1 - Allow (no content checking is done on the HTML emails)
// 2 - Use text/plain if available for multipart MIME
// 3 - Render all HTML as text (but still display tags).  Multipart mime text/plain version used
// 4 - Strip all HTML tags to plain text (you may find this removes a large chunk of the email)
// 5 - Allow HTML email but disable internet images
//
// Note: Some HTML email may be incorrectly sent as text/plain which means
// it will always be displayed as plain text in DWmail

$HTMLemail = 1;

// Default compose editor mode?
// text - Use plain text
// html - Use rich text mode (note message must be entirely HTML, <html> and <body>
//        appended automatically)
// wysiwyg - Use V-editor (note you should only use this if you can guarantee
//           that your audience will all be using a compatible browser.  Supported
//           browsers include IE5.5+, Mozilla 1.3+ and Mozilla Firebird 0.6.1+

$DefaultComposeMode = 'wysiwyg';

// Seperate signature
// This will allow you to seperate the signature from the rest of the body elements
// 1 - Yes (default)
// 0 - No

$SeperateSignature = 1;

// Auto-preview JPEG, GIF and PNG image attachments at the bottom of an email when viewing
// 1 - Yes (default)
// 0 - No

$AutoPreview = 1;

// Default timezone
// Default - 0 (GMT)
// Format takes minutes +/- GMT e.g. -60 is GMT-1 hour

$tz = '0';

// Date format
// Note this will be displayed automatically converted to the default or user's timezone preference
// This must be in the form of a valid PHP date format
// http://uk.php.net/date
// Default setting - d/m/y
// Default settingb - %d/%m/%y

// These two formats MUST match each other, however the second takes the format from
// http://uk.php.net/strftime

$DateFormatting = "d/m/y";
$DateFormattingb = "%d/%m/%y";

// Full date format
// Note this will be displayed automatically converted to the default or user's timezone preference
// This must be in the form of a valid PHP date format
// http://uk.php.net/strftime
// Default setting - %a, %d %B %Y %H:%M:%S
$DateFormattingFull = "%a, %d %B %Y %H:%M:%S";


// ############ IMAP SPECIFIC SETTINGS ############

// Folder delimiter
// This is usually a single dot, but it could be a slash or anything else
// Bear this in mind when you are giving your default folder names below
//  If we detect a different delimiter in use on your server, this value will be changed
//  automatically for that session

$DefaultDelimiter = '.';

// Default select saving sent email to the sent-mail folder (***IMAP only***)
// DWmail will use the folder specified below, if this does not exist one will be created
// 1 - enable (default)
// 0 - disable

$AllowSentMail = 1;

// When deleting move to Trash instead (***IMAP only***)
// DWmail will use the folder Trash, if this does not exist one will be created
// If disabled messages will be deleted automatically
// 1 - enable (default)
// 0 - disable

$UseTrash = 1;

// Default Sent messages folder
// Unless you know what you are doing we advise leaving this setting alone
// For advanced users, this is folder for saved messages.  Note that sub-folders take the form
// folder.subfolder so for a subfolder of the inbox it becomes INBOX.subfolder.
// Some IMAP servers do not allow folders to be created above the inbox so changing this 
// could break DWmail.  You have been warned.
// Default: INBOX.sent-mail

$IMAPSentMail = 'INBOX.sent-mail';

// Default Trash folder
// Unless you know what you are doing we advise leaving this setting alone
// For advanced users, this is folder for deleted messages.  Note that sub-folders take the form
// folder.subfolder so for a subfolder of the inbox it becomes INBOX.subfolder.
// Some IMAP servers do not allow folders to be created above the inbox so changing this 
// could break DWmail.  You have been warned.
// Default: INBOX.Trash

$IMAPTrash = 'INBOX.Trash';

// Default Drafts folder
// Unless you know what you are doing we advise leaving this setting alone
// For advanced users, this is folder for deleted messages.  Note that sub-folders take the form
// folder.subfolder so for a subfolder of the inbox it becomes INBOX.subfolder.
// Some IMAP servers do not allow folders to be created above the inbox so changing this 
// could break DWmail.  You have been warned.
// Default: INBOX.Drafts

$IMAPDrafts = 'INBOX.Drafts';

// Use folder subscriptions
// If you use this we will only display folders you are currently subscribed to
// INBOX will automatically be subscribed to if it isn't when you login
// 1 - enable
// 0 - disable (default)
// NOTE: This is an EXPERIMENTAL extension and should only be enabled for testing purposes
//     (       )
$Inbx = '';
$Outbx = '';
$Trsh = '';
$Drf = '';
/*
###############################################################################################################
## P.S.          , 
##    
##     ,  ,   !    ,   
## ,    htmlentities!      ! 
##    Dominion Web you self woodpecker! 
###############################################################################################################
*/
$IMAPSubscriptions = 0;


// ############ USER PREFERENCES ############

// Allow users to define their own settings
// 1 - enable (default)
// 0 - disable

$AllowUserOptions = 1;

// Allow cookie support
// This is used for user preferences ONLY.  Login details are not stored by cookie
// If disabled preferences will only apply to that session
// This setting is not necessary if DWmail is in database mode
// as the preferences will be stored in the database
// 1 - enable (default)
// 0 - disable

$AllowCookies = 1;


// ############ EXTENDED USER PREFERENCES ############

// Extended user preferences are the defaults for additional configuration by
// the user.  However these preferences can only be set by the user if DWmail is 
// running in Database mode.  Otherwise these settings are used

// Mailbox auto-refresh (in seconds)
// 0 - NEVER (default)

$mboxrefresh = 0;

// Turn inbox filtering on (IMAP4 only)
// You should not enable this by default unless you have already added your own filter
// rules to the database
// 1 - enable
// 0 - disable (default)

$usefilters = 0;


// ############ LOCAL, REMOTE OR DOMAIN MODE ############

// DWmail Mode
// There are three modes in which DWmail can be run.  By default DWmail allows users
// to connect to any POP3 or IMAP4 email account whether remotely serviced OR on your
// local server.  Other modes include, 'local mode', which only allows connections
// to a single mailserver (for as many domains can be accessed through that mail server)
// and domain mode which is an array of domain names that you wish to allow access
// to through DWmail.
// 2 - Domain Mode
// 1 - Local Mode
// 0 - Remote Mode (default)

$DWmailMode = 0;

// ----------- LOCAL MODE SPECIFIC SETTINGS -----------

// Default server information for LOCAL mode
// This is your default IMAP or POP3 server. 
// If the IMAP server is on this machine than you can use 'localhost'
// Only required if $ForceLocal = 1
// We recommend using IMAP as a default mode if you use local mode

$DefaultServer = 'localhost';

// Full email address as username
// Does your local IMAP/POP3 server use the full email address as
// a username, this will affect the standard login only
// 1 - Use email address as username
// 0 - Use part in front of @ as a username (default)

$FullLogin = 1;

// Use SMTP
// Set whether to use SMTP or PHP mail()
// You can only use this if you are in local mode
// 1 - Use SMTP
// 0 - Use PHP mail() (default)

$UseSMTP = 0;

// SMTP Server
// What is the location of your SMTP server
// You only need to set this is $UseSMTP = 1

$DefaultSMTP = 'localhost';

// Use SMTP authentication
// Does your SMTP server require SMTP authentication
// Note: If you require SMTP authentication then PHP mail()
// mode may not work
// 1 - Use SMTP authentication
// 0 - Don't use SMTP authentication (default)

$UseSMTPAuth = 0;

// Server name used for HELO connections
//   If the SMTP server is on the SAME server as the current webserver you can use
//   localhost otherwise you should put the current name of your server

$HELOServerName = 'localhost';

// ----------- DOMAIN MODE SETTINGS -----------

// If DWMail is set to 'domain mode' then you must also set the array below
// This contains the list of domain names you wish to allow users to check their email
// under.
// The format must be $AllowedDomains = array('domain1.com', 'domain2.com', 'domain3.com');
// Where you can seperate each domain by commas
// We include 'localhost' as a default

$AllowedDomains = array('localhost');

// ############ DATABASE SETTINGS ############
// You might see some references to MySQL throughout the code in the form of function
// and variable names even if you are using PostgreSQL, this is because DWmail formerly
// only supported MySQL and the variable names haven't been updated yet.

// Use database
// If this is disabled user preferences will be stored by cookie or session (see
// $AllowUserOptions and $UseCookies) and the calendar/address book functionality
// will not work
// 1 - Use database
// 0 - Don't use database (default)

$UseDatabase = 1;

// Database library type
//  The function library to use for your database connections and queries
// mysql  - MySQL functions (default)
//            For PHP versions 4 & 5 and MySQL 3.x+
//            If you are using MySQL 4.1+ there is a new password hashing system
//            in place for this version and PHP can't connect under the mysql
//            function libraries because it cannot send the correct password.
//            You MUST use the MySQL command OLD_PASSWORD() when you add the user
//            to the database (other wise try mysqli extensions)
// mysqli - MySQLi functions (experimental, use at your own risk)
//            For PHP version 5+ ONLY and MySQL 4.1+ ONLY
//            You do not need to use the OLD_PASSWORD() function when creating a
//            user if you intend to use the mysqli library
// postgresql - PostgreSQL functions
//                Use a PostgreSQL database instead of MySQL

$DatabaseType = 'mysql';

// Default Database Server location
// Default - localhost

$MySQLServer = 'localhost';

// Database server username

$MySQLUsername = 'root';

// Database server password
//  Note: See database library notes above about MySQL 4.1+ password hashing problems

$MySQLPassword = 'thagi3Vey';

// DWmail database name
// The database name created for DWmail
// default - dwmail

$MySQLDBName = 'dwmail';

// User expiry cleanup
// How many days shall users who haven't been logged in
// be deleted from the database (ALL records including
// addressbook and calendar entries will be deleted)
// To disabled set this value to 0

$MySQLCleanUp = 120;

// Allow external POP3 account retrieval
// Users can import email from remote POP3 accounts to their mailbox
// 1 - Enable (default)
// 0 - Disable

$AllowExternal = 1;

// Enable Calendar
// 1 - Enable (default)
// 0 - Disable

$EnableCalendar = 0;

// Enable Contacts
// 1 - Enable (default)
// 0 - Disable

$EnableContacts = 1;


// ############ COMPATIBILITY SETTINGS ############

// Compatibility mode
// If for some reason your IMAP server refuses to login with the default settings
// you might want to try this compatibility mode.
// This is most relevant to RedHat 8.0+ or Apache 2.0 systems
//   Note: Some systems will work in both modes
//   If your system logs in ok, then you don't need to change this setting

// If you get a 'Document contains no data' error or an Internet Explorer DNS
// error page this is explained at
// http://www.dominion-w3b.c0m/products/knowledgebase/index.php?option=display&question=206

// 1 - Yes run in compatibility mode
// 0 - No run in normal mode (default)

$CompatibilityMode = 1;

// Are you using Cyrus IMAP server or SIMS IMAP server (***IMAP only***)
// This is only relevant if you are using extended IMAP functionality
// such as moving messages between folders or saving sent email
// This is because these servers handle end-of-line terminators differently to most

// If you are using qmail, exim or postfix we strongly recommend using Courier IMAP
// http://www.inter7.com/courierimap.html
// which does not require this setting to be enabled.
// DWmail is developed using Courier IMAP

// 1 - Yes we are using Cyrus or SIMS IMAP server 
// 0 - No we are not (default)

$CyrusIMAP = 0;


// ############ SOFTWARE VERSION ############

// Software version - Do not edit
$version = "3.6.2";
?>