<?php
/*
############################################################################

############################################################################
*/

$type = array("text", "multipart", "message", "application", "audio", "image", "video", "other");
$encoding = array("7bit", "8bit", "binary", "base64", "quoted-printable", "other");

// Whilst DWmail's official system requirements are PHP 4.1.0 or better
// we'll be kind and run a pre-4.1.0 name standardisation routine
$PHPVersion = phpversion();
if ($PHPVersion  < '4.1.0') {
	$_GET = &$HTTP_GET_VARS;
	$_POST = &$HTTP_POST_VARS;
	$_COOKIE = &$HTTP_COOKIE_VARS;
	$_SERVER = &$HTTP_SERVER_VARS;
	$_ENV = &$HTTP_ENV_VARS;
	$_FILES = &$HTTP_POST_FILES;
	$_REQUEST = array_merge($_GET, $_POST, $_COOKIE);
}

class fileProperties {
	var $_file;
	var $_DefaultTemplate;

	function fileProperties($DefaultTemplate) {
		$this->_DefaultTemplate = $DefaultTemplate;
	}

	function fileRead($whichfile, $ext = '.tpl', $filelocation = './templates/') {
		if ($filelocation == "./templates/") {
			$filelocation = "./templates/" . $this->_DefaultTemplate . "/";
		}
		$this->_file = $filelocation . $whichfile . $ext;
		if (file_exists($this->_file)) {
			$fp = fopen($this->_file, "r");
			$filecontents = fread($fp, 200000);
			fclose($fp);
			return $filecontents;
		}
		else {
			echo ("<p>Error: template '" . $whichfile . "' does not exist in '" . $this->_DefaultTemplate . "' template</p>");
			return false;
		}
	}

}

function parseBody($structure) {
	global $type;
	global $encoding;

	$ret = array();

	$parts = $structure->parts;

	for($x=0; $x<sizeof($parts); $x++) {
		$ret[$x]["pid"] = ($x+1);

		$currpart = $parts[$x];

		if ($currpart->type == "") {
			$currpart->type = 0;
		}
		$ret[$x]["type"] = $type[$currpart->type] . "/" . strtolower($currpart->subtype);
		// Check for multipart/alternative which may exist in a multipart/mixed message
		if ($ret[$x]["type"] == "multipart/alternative") {
			$reloop = $x;
			$subpart = $ret[$x]["pid"];
		}

		// Check for multipart/related which may exist in a multipart/mixed message
		if ($ret[$x]["type"] == "multipart/related") {
			$reloop = $x;
			$subpart = $ret[$x]["pid"];
		}

		// Check for multipart/appledouble which may exist in a multipart/mixed message
		if ($ret[$x]["type"] == "multipart/appledouble") {
			$reloop = $x;
			$subpart = $ret[$x]["pid"];
		}

		if ($currpart->encoding == "") {
			$currpart->encoding = 0;
		}
		$ret[$x]["encoding"] = $encoding[$currpart->encoding];

		$ret[$x]["size"] = strtolower($currpart->bytes);

		if ($currpart->disposition <> "") {
			$ret[$x]["disposition"] = strtolower($currpart->disposition);
		}

		if ($currpart->description <> "") {
			$ret[$x]["description"] = $currpart->description;
		}

		$ret[$x]["id"] = $currpart->id;
		$ret[$x]["id"] = str_replace("<", "", $ret[$x]["id"]);
		$ret[$x]["id"] = str_replace(">", "", $ret[$x]["id"]);

		$ret[$x]["typeid"] = strtolower($currpart->type);

		$ret[$x]["subpart"] = -1;

		if ($currpart->ifparameters == 1) {
			if ($currpart->parameters) {
				foreach ($currpart->parameters as $p2) {
					if (strtolower($p2->attribute) == 'name') {
						$ret[$x]["name"] = $p2->value;
					}
					if (strtolower($p2->attribute) == 'charset') {
						$ret[$x]["charset"] = $p2->value;
					}
				}
			}
		}

		if ($currpart->ifdparameters == 1 && !$ret[$x]["name"]) {
			if (strtolower($currpart->disposition) == 'attachment' || strtolower($currpart->disposition) == 'inline') {
				$params = $currpart->dparameters;
				if ($params) {
					foreach ($params as $p) {
						if(strtolower($p->attribute) == 'filename') {
							$ret[$x]["name"] = $p->value;
							break;
						}
					}
				}
			}
		}
	}

	// This extra loop is for multipart/mixed
	// multipart mixed is structured:
	// - multipart/alternative
	// - - text/plain
	// - - text/html
	// - attachments/type
	//
	// So we need to log where the multipart/alternative is
	// and reloop to get the content part ids

	// It's also possible to have a multipart/related with a multipart/alternative in it, just to confuse things even more

	if ($reloop >= 0) {
		$parts2 = $structure->parts[$reloop]->parts;
		for($i=0; $i<sizeof($parts2); $i++) {
			$newx = $x;
			$x++;
			if (!empty($subpart)) {
				$ret[$newx]["pid"] = $subpart . "." . ($i+1);
			}
			else {
				$ret[$newx]["pid"] = ($i+1);
			}
			$currpart = $parts2[$i];

			if ($currpart->type == "") {
				$currpart->type = 0;
			}
			$ret[$newx]["type"] = $type[$currpart->type] . "/" . strtolower($currpart->subtype);

			// Check for multipart/alternative which may exist in a multipart/related message
			if ($ret[$newx]["type"] == "multipart/alternative") {
				$reloop2 = $i;
				$loopsubpart = $ret[$newx]["pid"];
			}

			if ($currpart->encoding == "") {
				$currpart->encoding = 0;
			}
			$ret[$newx]["encoding"] = $encoding[$currpart->encoding];

			$ret[$newx]["size"] = strtolower($currpart->bytes);

			if ($currpart->disposition <> "") {
				$ret[$newx]["disposition"] = strtolower($currpart->disposition);
			}

			if ($currpart->description <> "") {
				$ret[$newx]["description"] = $currpart->description;
			}

			$ret[$newx]["id"] = $currpart->id;
			$ret[$newx]["id"] = str_replace("<", "", $ret[$newx]["id"]);
			$ret[$newx]["id"] = str_replace(">", "", $ret[$newx]["id"]);

			$ret[$newx]["typeid"] = strtolower($currpart->type);

			$ret[$newx]["subpart"] = $i+1;


			if ($currpart->ifparameters == 1) {
				if ($currpart->parameters) {
					foreach ($currpart->parameters as $p2) {
						if (strtolower($p2->attribute) == 'name') {
							$ret[$newx]["name"] = $p2->value;
						}
						if (strtolower($p2->attribute) == 'charset') {
							$ret[$newx]["charset"] = $p2->value;
						}
					}
				}
			}

			if ($currpart->ifdparameters == 1 && !$ret[$newx]["name"]) {
				if (strtolower($currpart->disposition) == 'attachment' || strtolower($currpart->disposition) == 'inline') {
					$params = $currpart->dparameters;
					if ($params) {
						foreach ($params as $p) {
							if(strtolower($p->attribute) == 'filename') {
								$ret[$newx]["name"] = $p->value;
								break;
							}
						}
					}
				}
			}
		}
	}

	if ($reloop2 >= 0) {
		$parts2 = $structure->parts[$reloop]->parts[$reloop2]->parts;
		for($i=0; $i<sizeof($parts2); $i++) {
			$newx2 = $x;
			$x++;
			if (!empty($loopsubpart)) {
				$ret[$newx2]["pid"] = $loopsubpart . "." . ($reloop2+1);
			}
			else {
				$ret[$newx2]["pid"] = ($reloop2+1);
			}
			$currpart = $parts2[$i];

			if ($currpart->type == "") {
				$currpart->type = 0;
			}
			$ret[$newx2]["type"] = $type[$currpart->type] . "/" . strtolower($currpart->subtype);


			if ($currpart->encoding == "") {
				$currpart->encoding = 0;
			}
			$ret[$newx2]["encoding"] = $encoding[$currpart->encoding];

			$ret[$newx2]["size"] = strtolower($currpart->bytes);

			if ($currpart->disposition <> "") {
				$ret[$newx2]["disposition"] = strtolower($currpart->disposition);
			}

			if ($currpart->description <> "") {
				$ret[$newx2]["description"] = $currpart->description;
			}

			$ret[$newx2]["id"] = $currpart->id;
			$ret[$newx2]["id"] = str_replace("<", "", $ret[$newx2]["id"]);
			$ret[$newx2]["id"] = str_replace(">", "", $ret[$newx2]["id"]);

			$ret[$newx2]["typeid"] = strtolower($currpart->type);

			$ret[$newx2]["subpart"] = $loopsubpart . '.' . ($i+1);


			if ($currpart->ifparameters == 1) {
				if ($currpart->parameters) {
					foreach ($currpart->parameters as $p2) {
						if (strtolower($p2->attribute) == 'name') {
							$ret[$newx2]["name"] = $p2->value;
						}
						if (strtolower($p2->attribute) == 'charset') {
							$ret[$newx2]["charset"] = $p2->value;
						}
					}
				}
			}

			if ($currpart->ifdparameters == 1 && !$ret[$newx2]["name"]) {
				if (strtolower($currpart->disposition) == 'attachment' || strtolower($currpart->disposition) == 'inline') {
					$params = $currpart->dparameters;
					if ($params) {
						foreach ($params as $p) {
							if(strtolower($p->attribute) == 'filename') {
								$ret[$newx2]["name"] = $p->value;
								break;
							}
						}
					}
				}
			}
		}
	}

	return $ret;
}

function parseEncoding($body, $encoding) {
	if ($encoding == "base64") {
		return imap_base64($body);
	}
	elseif ($encoding == "quoted-printable") {
		return imap_qprint($body);
	}
	else {
		return $body;
	}
}

function get_attachments($arr) {
	for($x=0; $x<sizeof($arr); $x++) {
		if ($arr[$x]["disposition"] == "attachment" && $arr[$x]["disposition"] <> "inline") {
			// Get attachments with 'attachment' type defined
			$ret[] = $arr[$x];
		}
		elseif (($arr[$x]["type"] <> 'text/plain' && $arr[$x]["type"] <> 'text/html' && $arr[$x]["type"] <> 'multipart/alternative' && $arr[$x]["type"] <> 'multipart/related' && $arr[$x]["type"] <> 'message/disposition-notification' && $arr[$x]["type"] <> 'multipart/appledouble') && $arr[$x]["disposition"] <> "attachment" && $arr[$x]["disposition"] <> "inline" && $arr[$x]["id"] == "") {
			// Get all parts that aren't text/plain or text/html and also don't have a content-disposition attached (this should catch most if not all html and txt attachments too)
			$ret[] = $arr[$x];
		}
	}
	return $ret;
}

function get_embeddedattachments($arr) {
	for($x=0; $x<sizeof($arr); $x++) {
		if (($arr[$x]["id"] <> "" && $arr[$x]["typeid"] == "5") || $arr[$x]["disposition"] == "inline" && $arr[$x]["type"] <> 'multipart/alternative' && $arr[$x]["type"] <> 'multipart/related') {
			$ret[] = $arr[$x];
		}
		elseif (($arr[$x]["type"] == 'text/plain' || $arr[$x]["type"] == 'text/html' || $arr[$x]["type"] == 'text/xml' || $arr[$x]["type"] == 'text/css') && $arr[$x]["id"] <> '' && $arr[$x]["type"] <> 'multipart/alternative' && $arr[$x]["type"] <> 'multipart/related') {
			$ret[] = $arr[$x];
		}
	}
	return $ret;
}

function checkforreceipt($arr) {
	$receipt = FALSE;
	for($x=0; $x<sizeof($arr); $x++) {
		if ($arr[$x]["type"] == 'message/disposition-notification') {
			$receipt = TRUE;
		}
	}
	return $receipt;
}

function CheckValidSession($sessionvars, $PageFooter, $error_session, $PageHeader, $lang = '') {
	if (($sessionvars['sess_u'] == "") && ($sessionvars['sess_p'] == "")) {
		$PageHeader = str_replace ("[folders]", "", $PageHeader);
		$PageHeader = str_replace ("[header_refresh]", "", $PageHeader);
		$PageHeader = str_replace ("[pagetitle]", "", $PageHeader);
		$PageHeader = LangReplace('Generic', $PageHeader, $lang);
		$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
		$PageFooter = LangReplace('Generic', $PageFooter, $lang);
		$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);
		echo $PageHeader;
		echo $error_session;
		echo $PageFooter;
		exit;
	}
}

function CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang = '') {
	if ($securitycheck == 0) {
		$PageHeader = str_replace ("[folders]", "", $PageHeader);
		$PageHeader = str_replace ("[header_refresh]", "", $PageHeader);
		$PageHeader = str_replace ("[pagetitle]", "", $PageHeader);
		$PageHeader = LangReplace('Generic', $PageHeader, $lang);
		$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
		$PageFooter = LangReplace('Generic', $PageFooter, $lang);
		$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);
		echo $PageHeader;
		echo $error_ipfailure;
		echo $PageFooter;
		exit;
	}
}

function SeperateSignature($SeperateSignature, $content) {
	if ($SeperateSignature == 1) {
		$content_split = preg_split('|(\r\n--\s*\r\n)|', $content, 2, PREG_SPLIT_DELIM_CAPTURE);
		$content = array_shift($content_split);
		if (count($content_split)) {
			$content .= "<span class=\"signature\">" . $content_split[0];
			$content .= preg_replace('|class="[^"]+"|', "class=\"signatureblank\"", $content_split[1]);
			$content .= "</span>";
		}
	}
	return $content;
}

function checkmailbox_active ($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang = '', $genericerror = '') {

	// Check that connection was made or send errors back to the client
	if ($mailbox == "") {
		$error_connection = $getFile->fileRead('error_connection');
		$PageHeader = str_replace ("[folders]", "", $PageHeader);
		$PageHeader = str_replace ("[header_refresh]", "", $PageHeader);
		$PageHeader = str_replace ("[pagetitle]", "", $PageHeader);
		$PageHeader = LangReplace('Generic', $PageHeader, $lang);
		$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
		$PageFooter = LangReplace('Generic', $PageFooter, $lang);
		$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);
		if (isset($IMAPConnection->_mailboxerror)) {
			if (is_array($IMAPConnection->_mailboxerror)) {
				$servererrors = implode("<br />\n", $IMAPConnection->_mailboxerror);
			}
			else {
				$servererrors = $IMAPConnection->_mailboxerror;
			}
		}
		else {
			$servererrors .= "<br /><br />" . $lang['SErrors']['Connection'];
		}
		if (strstr($servererrors, "invalid remote specification")) {
			$servererrors .= "<br /><br />" . $lang['SErrors']['InvalidRemote'];
		}
		$error_connection = str_replace ('[servererror]', $servererrors, $error_connection);
		$error_connection = str_replace ('[lang=ConnectionDetails]', $lang['SErrors']['ConnectionDetails'], $error_connection);
		$genericerror = str_replace ('[pagemessage]', $error_connection, $genericerror);
		echo $PageHeader;
		echo $genericerror;
		echo $PageFooter;
		exit;
	}
}

function checkexternal_active ($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang = '', $genericerror = '') {

	// Check that connection was made or send errors back to the client
	if ($mailbox == "") {
		$PageHeader = str_replace ("[folders]", "", $PageHeader);
		$PageHeader = str_replace ("[header_refresh]", "", $PageHeader);
		$PageHeader = str_replace ("[pagetitle]", "", $PageHeader);
		$PageHeader = LangReplace('Generic', $PageHeader, $lang);
		$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
		$PageFooter = LangReplace('Generic', $PageFooter, $lang);
		$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);
		$genericerror = str_replace ('[pagemessage]', $lang['SErrors']['External'], $genericerror);
		echo $PageHeader;
		echo $genericerror;
		echo $PageFooter;
		exit;
	}
}

function LangReplace ($currentkey, $string, $lang) {
	if (is_array($lang[$currentkey])) {
		$langarry = $lang[$currentkey];
		while(list($key, $value) = each($langarry)) {
			$string = str_replace ("[lang=" . $key . "]", $value, $string);
		}
	}
	return $string;
}

function DateToLocal ($timezone, $originaldate, $formatting) {
	// Convert to a UNIX timestamp
	$datetimestamp = strtotime ($originaldate);

	// Now we have a GMT timestamp we can apply local timezone settings
	$localtimestamp = $datetimestamp + ($timezone * 60);

	// Reformat to just date and/or time based on user defined timezone
	$localtime_date = strftime ($formatting, $localtimestamp);

	return $localtime_date;
}

?>
