<?php
/*
############################################################################

############################################################################
*/

class SpellChecker {
	var $_dict;
	var $_ignorelength;
	var $_encoding;
	var $_pspell_cfg_handle;
	var $_pspell_handle;

	function SpellChecker($dict = 'ru', $encoding = 'win-1251', $ignorelength = '3') { 
		$this->_dict = $dict;
		$this->_ignorelength = $ignorelength;
		$this->_encoding = $encoding;

		$this->_pspell_cfg_handle = pspell_config_create($this->_dict, '', '', $this->_encoding);
		pspell_config_ignore($this->_pspell_cfg_handle, $this->_ignorelength); 
		pspell_config_mode($this->_pspell_cfg_handle, PSPELL_FAST); 
	}

	function OpenDictionary() {
		$this->_pspell_handle = pspell_new_config($this->_pspell_cfg_handle);
	}

	function check($word) { 
		return pspell_check($this->_pspell_handle, $word); 
	}

	function suggest($word) { 
		return pspell_suggest($this->_pspell_handle, $word); 
	}

	function close() {
		pspell_clear_session($this->_pspell_handle);
	}
}

?>
