<?php
/*
############################################################################

############################################################################
*/

// Zip file creation utilities
// Based on infomation from http://www.zend.com/zend/spotlight/creating-zip-files1.php

// Requires Zlib

class ZipCreate {
	var $dataarry = array();
	var $maindir = array();
	var $eofdir = "\x50\x4b\x05\x06\x00\x00\x00\x00";
	var $offset = 0;

	function TimeConvert($unixtime = 0) {
		if ($unixtime == 0) {
			$timearry = getdate();
		}
		else {
			$timearry = getdate($unixtime);
		}
		if ($timearry['year'] < 1980) {
			$timearry['year'] = 1980;
			$timearry['month'] = 1;
			$timearry['mday'] = 1;
			$timearry['hours'] = 0;
			$timearry['minutes'] = 0;
			$timearry['seconds'] = 0;
		}

		$formattedtime = (($timearry['year'] - 1980) << 25) | ($timearry['month'] << 21) | ($timearry['mday'] << 16) | ($timearry['hours'] << 11) | ($timearry['minutes'] << 5) | ($timearry['seconds'] >> 1);

		return $formattedtime;
	}

	function AddFile($filedata, $filename, $time = 0) {
		$filename = str_replace('\\', '/', $filename);
		// Convert decimal to hexidecimal
		$dtime = dechex($this->TimeConvert($time));
		$hexdtime = '\x' . $dtime[6] . $dtime[7] . '\x' . $dtime[4] . $dtime[5] . '\x' . $dtime[2] . $dtime[3] . '\x' . $dtime[0] . $dtime[1];
		eval('$hexdtime = "' . $hexdtime . '";');

		$crc = crc32($filedata);
		$origlen = strlen($filedata);
		$filedata = gzcompress($filedata);
		$filedata = substr(substr($filedata, 0, strlen($filedata) - 4), 2);
		$compressedlen = strlen($filedata);

		$filedetails = "\x50\x4b\x03\x04\x14\x00\x00\x00\x08\x00";
		$filedetails .= $hexdtime;

		$filedetails .= pack('V', $crc);
		$filedetails .= pack('V', $compressedlen);
		$filedetails .= pack('V', $origlen);
		$filedetails .= pack('v', strlen($filename));
		$filedetails .= pack('v', 0);
		$filedetails .= $filename;

		$filedetails .= $filedata;
		unset ($filedata);

		$filedetails .= pack('V', $crc);
		$filedetails .= pack('V', $compressedlen);
		$filedetails .= pack('V', $origlen);

		$this->dataarry[] = $filedetails;

		$centralrec = "\x50\x4b\x01\x02\x00\x00\x14\x00\x00\x00\x08\x00";
		$centralrec .= $hexdtime;
		$centralrec .= pack('V', $crc);
		$centralrec .= pack('V', $compressedlen);
		$centralrec .= pack('V', $origlen);
		$centralrec .= pack('v', strlen($filename));
		$centralrec .= pack('v', 0);
		$centralrec .= pack('v', 0);
		$centralrec .= pack('v', 0);
		$centralrec .= pack('v', 0);
		$centralrec .= pack('V', 32);

		$centralrec .= pack('V', $this->offset);
		$this->offset += strlen($filedetails);

		$centralrec .= $filename;

		$this->maindir[] = $centralrec;
	}

	function GenerateZip() {
		$data = implode('', $this->dataarry);
		$rootdir = implode('', $this->maindir);

		$output = $data . $rootdir . $this->eofdir .
			pack('v', sizeof($this->maindir)) .
			pack('v', sizeof($this->maindir)) .
			pack('V', strlen($rootdir)) .
			pack('V', strlen($data)) .
			"\x00\x00";

		return $output;
	}
}
?>
