<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/mailbox.inc.php");

if ($_GET['f'] == "") {
	$folder = "INBOX";
	$_SESSION['folder'] = $folder;
}
elseif ($_GET['f'] <> "") {
	$folder = $_GET['f'];
	$_SESSION['folder'] = $folder;
}
if ((isset($_SESSION['folder'])) && ($_SESSION['folder'] <> $_GET['f'])) {
	$_SESSION['folder'] = $_GET['f'];
}
$initiallogin = $_GET['il'];

$folderencode = urlencode($folder);
// Setup templates
$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageMenu = $getFile->fileRead('menu');
$PageInboxMenu = $getFile->fileRead('inboxmenu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

// options must be called after currentemailaddress in mailbox.php for the 
// database login to work
require ("./includes/options.inc.php");

if (!$_GET['sort'] && !$_SESSION['sort']) {
	if (!isset($MailboxSort)) {
		$_SESSION['sort'] = "SORTDATE";
	}
	else {
		$_SESSION['sort'] = $MailboxSort;
	}
}

if (!$_SESSION['order']) {
	if (!isset($SortOrder)) {
		$_SESSION['order'] = 1;
	}
	else {
		$_SESSION['order'] = $SortOrder;
	}
}

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageInboxMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageInboxMenu);
$PageInboxMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageInboxMenu);
$PageInboxMenu = str_replace("[message_folder]", $_SESSION['folder'], $PageInboxMenu);

// Set sort column and order
if ($_GET['sort']) {
	if ($_SESSION['sort'] == $_GET['sort']) {
		if ($_GET['order'] == 1) {
			$_SESSION['order'] = 1;
		}
		else {
			$_SESSION['order'] = 0;
		}
	}
	else {
		$_SESSION['order'] = 0;
	}
	$_SESSION['sort'] = $_GET['sort'];
}

$sorttext[0] = "Sorted in ascending order";
$sorttext[1] = "Sorted in decending order";

$CodeSearch = array (
	"[mainmenu]",
	"[copyright]",
	"[charset]",
	"[lang]"
);

$CodeReplace = array (
	$PageMenu,
	$PageCopyright,
	$_SESSION['DefaultCharSet'],
	$_SESSION['DefaultLang']
);


$PageHeader = str_replace ($CodeSearch, $CodeReplace, $PageHeader);
$PageFooter = str_replace ($CodeSearch, $CodeReplace, $PageFooter);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

if ($IMAPConnection->WM_FolderDecode($_SESSION['folder']) == $IMAPSentMail) {
	$PageInbox = $getFile->fileRead('sentitems');
	$PageInboxList = $getFile->fileRead('sentitemslist');
}
else {
	$PageInbox = $getFile->fileRead('inbox');
	$PageInboxList = $getFile->fileRead('inboxlist');
}

$PageInbox = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageInbox);
$PageInbox = str_replace("[session_force]", "&amp;" . strip_tags(SID), $PageInbox);

if ($_SESSION['sort'] == "SORTDATE") {
	$PageInbox = str_replace("[classname_date]", "TableHeaderSelected", $PageInbox);
	$sorticon_date = "<img src=\"templates/$DefaultTemplate/images/sort_" . strip_tags($_SESSION['order']) . ".gif\" border=\"0\" alt=\"" . $sorttext[$_SESSION['order']] . "\" />";
}
else {
	$PageInbox = str_replace("[classname_date]", "TableHeader", $PageInbox);
	$sorticon_date = "";
}
$PageInbox = str_replace("[sort_date]", $sorticon_date, $PageInbox);

if ($_SESSION['sort'] == "SORTFROM") {
	$PageInbox = str_replace("[classname_from]", "TableHeaderSelected", $PageInbox);
	$sorticon_from = "<img src=\"templates/$DefaultTemplate/images/sort_" . strip_tags($_SESSION['order']) . ".gif\" border=\"0\" alt=\"" . $sorttext[$_SESSION['order']] . "\" />";
}
else {
	$PageInbox = str_replace("[classname_from]", "TableHeader", $PageInbox);
	$sorticon_from = "";
}
$PageInbox = str_replace("[sort_from]", $sorticon_from, $PageInbox);

if ($_SESSION['sort'] == "SORTTO") {
	$PageInbox = str_replace("[classname_to]", "TableHeaderSelected", $PageInbox);
	$sorticon_to = "<img src=\"templates/$DefaultTemplate/images/sort_" . strip_tags($_SESSION['order']) . ".gif\" border=\"0\" alt=\"" . $sorttext[$_SESSION['order']] . "\" />";
}
else {
	$PageInbox = str_replace("[classname_to]", "TableHeader", $PageInbox);
	$sorticon_to = "";
}
$PageInbox = str_replace("[sort_to]", $sorticon_to, $PageInbox);

if ($_SESSION['sort'] == "SORTSUBJECT") {
	$PageInbox = str_replace("[classname_subject]", "TableHeaderSelected", $PageInbox);
	$sorticon_subject = "<img src=\"templates/$DefaultTemplate/images/sort_" . strip_tags($_SESSION['order']) . ".gif\" border=\"0\" alt=\"" . $sorttext[$_SESSION['order']] . "\" />";
}
else {
	$PageInbox = str_replace("[classname_subject]", "TableHeader", $PageInbox);
	$sorticon_subject = "";
}
$PageInbox = str_replace("[sort_subject]", $sorticon_subject, $PageInbox);

if ($_SESSION['sort'] == "SORTSIZE") {
	$PageInbox = str_replace("[classname_size]", "TableHeaderSelected", $PageInbox);
	$sorticon_size = "<img src=\"templates/$DefaultTemplate/images/sort_" . strip_tags($_SESSION['order']) . ".gif\" border=\"0\" alt=\"" . $sorttext[$_SESSION['order']] . "\" />";
}
else {
	$PageInbox = str_replace("[classname_size]", "TableHeader", $PageInbox);
	$sorticon_size = "";
}

if ($mboxrefresh > 0) {
	$headerrefresh = "<meta http-equiv=\"refresh\" content=\"$mboxrefresh;URL=mailbox.php?f=" . $_SESSION['folder'] . "&" . SID . "\" />";
}
else {
	$headerrefresh = "";
}

$PageInbox = str_replace("[sort_size]", $sorticon_size, $PageInbox);
if ($_SESSION['order'] == 0) {
	$PageInbox = str_replace("[sortorder]", 1, $PageInbox);
}
else {
	$PageInbox = str_replace("[sortorder]", 0, $PageInbox);
}

$PageInbox = str_replace("[currentfolder]", $_SESSION['folder'], $PageInbox);


$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

if ($UseDatabase == 1) {
	if ($MySQLMakeConnection) {
		$MySQLCleanup = $MySQLConnection->DB_Cleanup($MySQLCleanUp);
	}
}

if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
	$movemessage = "<script language=\"javascript\" type=\"text/javascript\">
<!--
function domove(select_box_name) {
	if (select_box_name.options[select_box_name.options.selectedIndex].value != '') {
		document.forms['inbox'].action = 'movemessage.php';
		document.forms['inbox'].method = 'GET';
		document.forms['inbox'].submit();
	}

}
// -->
</script>
<select name=\"df\" onchange=\"domove(this);\">
<option value=\"\">-- " . $lang['SMove']['MoveSelection'] . " --</option>";
	$folderget = $IMAPConnection->WM_IMAPFolders($IMAPSubscriptions);
	$folders = $IMAPConnection->_folders;
	if (is_array($folders)) {
		sort($folders);
		for($i=0; $i<count($folders); $i++) {
			$movemessage .= "<option value=\"" . urlencode($folders[$i]['id']) . "\">" . str_replace("INBOX.", " - ", $folders[$i]['name']) . "</option>\n";
		}
	}
	$movemessage .= "</select>";
}
else {
	$movemessage = "";
}

$PageInbox = str_replace("[imap_move]", $movemessage, $PageInbox);

$imapstatus = $IMAPConnection->WM_IMAPStatus($_SESSION['folder']);
$totalmessages = $imapstatus->messages;
$numberofnewmessages = $imapstatus->unseen;
$runfilter = 0;

// Detect whether we should run filters AND if there are any new messages as we have to download the entire mailbox to run filters
if (($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") && $UseDatabase == 1 && $usefilters == 1 && $numberofnewmessages >= 1 && $_SESSION['folder'] == "INBOX") {
	$runfilter = 1;
}

$mailboxinfo = $IMAPConnection->WM_IMAPMailboxInfo();

$currrow = 1;
$counter = 1;

if (!$_GET['n']) {
	$page = 1;
}
else {
	$page = $_GET['n'];
}
$nextpage = $page + 1;
$prevpage = $page - 1;

$numberofpages = ceil($totalmessages / $messagesperpage);

$startmessage = (($page * $messagesperpage) - $messagesperpage) + 1;
$lastmessage = $page * $messagesperpage;

$sortmessages = $IMAPConnection->WM_IMAPList($startmessage, $lastmessage, 1, $usefilters);
// Display the message list
if ($sortmessages <> "") {
	while(list($key, $value) = each($sortmessages)) {
		if (!is_null($value['message_number'])) {
		$messagenew = 0;

		// We need to update the current message number of the UID incase a filter has moved or deleted a message
 		// as the sequence number would have changed
		$sortmessages[$key]['message_number'] = $IMAPConnection->GetSeqNum($sortmessages[$key]['message_uid']);

		$IMAPConnection->WM_IMAPGetHeader($sortmessages[$key]['message_uid']);

		$headerdetails = $IMAPConnection->WM_IMAPFullHeaders();
		if (($IMAPConnection->_msgheader->Recent == "N" || $IMAPConnection->_msgheader->Unseen == "U")  && ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl")) {
			$messagenew = 1;
		}

		if ($messagenew == 1) {
			// We must reset the new header.  For some reason reading the headers
			// sets the message to read
			$IMAPConnection->WM_IMAPClearFlag($sortmessages[$key]['message_uid']);

			// Now reset any other flags back to their original values excluding read and unseen
			if ($IMAPConnection->_msgheader->Answered == "A") {
				$SetFlag = $IMAPConnection->WM_IMAPSetFlag("\\Answered", $sortmessages[$key]['message_uid']);
			}
			if ($IMAPConnection->_msgheader->Deleted == "D") {
				$SetFlag = $IMAPConnection->WM_IMAPSetFlag("\\Deleted", $sortmessages[$key]['message_uid']);
			}
			if ($IMAPConnection->_msgheader->Draft == "X") {
				$SetFlag = $IMAPConnection->WM_IMAPSetFlag("\\Draft", $sortmessages[$key]['message_uid']);
			}
			if ($IMAPConnection->_msgheader->Flagged == "F") {
				$SetFlag = $IMAPConnection->WM_IMAPSetFlag("\\Flagged", $sortmessages[$key]['message_uid']);
			}
		}

		// Check we if we should run some filters
		// We only run filters in IMAP/DATABASE mode with filters enabled and on NEW messages
		$actioncomplete = 0;
		if ($runfilter == 1 && $messagenew == 1) {
			include ("./includes/filters.inc.php");
		}
		if ($actioncomplete == 1) {
			$displaymessage = 0;
		}
		else {
			$displaymessage = 0;
			if ($counter >= $startmessage && $counter <= $lastmessage && $usefilters == 1) {
				$displaymessage = 1;
			}
			elseif ($usefilters == 0) {
				$displaymessage = 1;
			}
			if ($displaymessage == 1) {

				$mbox_to = '';
				$to_array  = imap_rfc822_parse_adrlist($headerdetails['toaddress'], '');
				if (is_array($to_array)) {
					for($i=0; $i<sizeof($to_array); $i++) {
						if ($to_array[$i]->mailbox <> "" && $to_array[$i]->host <> "") {
							if ($i <> 0) {
								$mbox_to .= ", ";
							}
							if ($to_array[$i]->personal <> "") {
								$mbox_to .= $to_array[$i]->personal;
							}
							else {
								$mbox_to .= $to_array[$i]->mailbox . "@" . $to_array[$i]->host;
							}
						}
					}
				}

				if (strstr($PageInboxList, '[message_attachment]')) {
					// Only detect attachments if the attachment variable is actually defined in the template
					// This can speed things up a bit if needed
					if (!isset($structure)) {
						$structure = $IMAPConnection->WM_IMAPGetStructure($sortmessages[$key]['message_uid']);
					}
					if (!isset($sections)) {
						$sections = parseBody($structure);
					}
					$attachments = get_attachments($sections);
					$embeddedattachments = get_embeddedattachments($sections);

					if (is_array($attachments) || is_array($embeddedattachments)) {
						$message_attachment = "<img alt=\"" . $lang['SMbox']['Attachment'] . "\" src=\"templates/silver/images/mailbox/attach.gif\" />";
					}
					else {
						$message_attachment = "&nbsp;";
					} 
				}

				if (strstr($PageInboxList, '[message_importance]')) {
					// Find an importance header
					$header_full = $IMAPConnection->WM_IMAPRFCHeader($sortmessages[$key]['message_uid']);
					if (strstr($header_full, 'Importance:')) {
						$header_arry = explode ("\n", $header_full);
						$line_number = 0; 
						$have_importance = 0;

						while ($line = $header_arry[$line_number]) { 
							$line = trim($line);
							if (strstr($line, "Importance:")) {
								$importancelevel = str_replace ("Importance:", "", $line);
								$importancelevel = trim($importancelevel);
								$have_importance = 1;
							}
							$line_number++; 
						}

					}
				}


				// Please note that we can only check for a receipt if the body has been downloaded
				if (isset($sections)) {
					$checkreadreceipt = checkforreceipt($sections);
				}

				if ($structure) {
					$contenttype = strtolower($type[$structure->type] . '/' . $structure->subtype);
				}
				else {
					unset ($contenttype);
				}

				if (($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") && $contenttype <> "text/calendar") {
					if (isset($checkreadreceipt) && $checkreadreceipt == TRUE) {
						$message_envelope = "<img src=\"templates/silver/images/mailbox/readreceipt.gif\" alt=\"" . $lang['SMbox']['Message'] . "\" />";
					}
					elseif (($IMAPConnection->_msgheader->Recent == "N") || ($IMAPConnection->_msgheader->Unseen == "U")) {
						$message_envelope = "<img src=\"templates/silver/images/mailbox/mail_new.gif\" alt=\"" . $lang['SMbox']['New'] . "\" />";
					}
					else {
						$message_envelope = "<img src=\"templates/silver/images/mailbox/mail_read.gif\" alt=\"" . $lang['SMbox']['Read'] . "\" />";
					}
					if ($IMAPConnection->_msgheader->Answered == "A") {
						$messageanswered = 1;
						$message_envelope = "<img src=\"templates/silver/images/mailbox/mail_reply.gif\" alt=\"" . $lang['SMbox']['Replied'] . "\" />";
					}
					else {
						$messageanswered = 0;
					}
				}
				elseif ($contenttype == "text/calendar") {
					$message_envelope = "<img src=\"templates/silver/images/mailbox/appointment.gif\" alt=\"" . $lang['SMbox']['Appointment'] . "\" />";

				}
				else {
					if (isset($checkreadreceipt) && $checkreadreceipt == TRUE) {
						$message_envelope = "<img src=\"templates/silver/images/mailbox/readreceipt.gif\" alt=\"" . $lang['SMbox']['Message'] . "\" />";
					}
					else {
						$message_envelope = "<img src=\"templates/silver/images/mailbox/mail_new.gif\" alt=\"" . $lang['SMbox']['Message'] . "\" />";
					}
				}

				if ($importancelevel == "High") {
					$importancegraphic = '<img src="templates/' . $DefaultTemplate . '/images/mailbox/important.gif" alt="' . $lang['SMbox']['Importance'] . ': ' . $lang['SMbox']['ImportanceHigh'] . '" />';	
				}
				elseif ($importancelevel == "Low") {
					$importancegraphic = '<img src="templates/' . $DefaultTemplate . '/images/mailbox/low.gif" alt="' . $lang['SMbox']['Importance'] . ': ' . $lang['SMbox']['ImportanceLow'] . '" />';	
				}
				else {
					$importancegraphic = '&nbsp;';	
				}
				unset ($importancelevel);


				$message_size = ceil(($IMAPConnection->_msgheader->Size/1024)) . " Kb"; 

				if ($currrow == 1) {
					$classid = "col1";
					$currrow = 2;
				}
				else {
					$classid = "col2";
					$currrow = 1;
				}
				if ($messagenew == 1) {
					$classid = "colnewmail";
				}
	
				if ($sortmessages[$key]['message_title'] == "") {
					$sortmessages[$key]['message_title'] = $lang['SMbox']['NoSubject'];
				}

				$localtime_hours = DateToLocal($tz, $sortmessages[$key]['message_date'], "%R");
				$localtime_date = DateToLocal($tz, $sortmessages[$key]['message_date'], "%a " . $DateFormattingb);

				// Convert to a UNIX timestamp
				$datetimestamp = strtotime ($sortmessages[$key]['message_date']);

				// Now we have a GMT timestamp we can apply local timezone settings
				$localtimestamp = $datetimestamp + ($tz * 60);

				if (strftime ($DateFormattingb, $localtimestamp) == date ($DateFormatting)) {
					$display_date = $lang['SMbox']['Today'] . " " . $localtime_hours;
				}
				else {
					$display_date = $localtime_date;
				}

				if (!isset($display_date)) {
					// Fall over option here to display the date/time from the message if for some reason we can't analyse it (some spam mail purposely corrupts the date header)
					$display_date = $sortmessages[$key]['message_date'];
				}

				if ($ViewPopUp == 1) {
					$messagewindow = "popup";
					$messagetarget = "_blank";
				}
				else {
					$messagewindow = "standard";
					$messagetarget = "_self";
				}

				if ($_SESSION['folder'] == $IMAPDrafts) {
					$messagewindow = "draft";
					$messagetarget = "_self";
				}

				if (isset($sortmessages[$key]['threadindent'])) {
					unset($indent);
					for ($j=0; $j<$sortmessages[$key]['threadindent']; $j++) {
						$indent .= "&nbsp;&nbsp;&nbsp;";
					}
				}

				// Note: [message_date] displays the reformatted date or time depending on the timezone
				// [message_fulldate] displays the original date in it's original timezone that the email was sent using

				$CodeSearch = array (
					"[message_number]",
					"[message_title]",
					"[message_from]",
					"[session]",
					"[session_append]",
					"[message_date]",
					"[message_fulldate]",
					"[message_attachment]",
					"[message_size]",
					"[rowcolor]",
					"[message_envelope]",
					"[message_folder]",
					"[message_to]",
					"[message_window]",
					"[message_target]",
					"[message_importance]",
					"[message_indent]"
				);
				$CodeReplace = array (
					$sortmessages[$key]['message_uid'],
					$sortmessages[$key]['message_title'],
					$sortmessages[$key]['message_from'],
					$MainSettings->SessAppend_noecho($TransIDEnabled, 1),
					$MainSettings->SessAppend_noecho($TransIDEnabled, 0),
					$display_date,
					$sortmessages[$key]['message_date'],
					$message_attachment,
					$message_size,
					$classid,
					$message_envelope,
					urlencode($_SESSION['folder']),
					$mbox_to,
					$messagewindow,
					$messagetarget,
					$importancegraphic,
					$indent
				);

	
				$CurrentMessage = str_replace ($CodeSearch, $CodeReplace, $PageInboxList);
				if ($_SESSION['folder'] == $IMAPDrafts) {
					// If we are in the Drafts folder change view to compose
					$CurrentMessage = str_replace ('view.php', 'compose.php', $CurrentMessage);
				}
				elseif ($contenttype == "text/calendar") {
					$CurrentMessage = str_replace ('view.php', 'view.ics.php', $CurrentMessage);

				}
				$FullList .= $CurrentMessage;
			}
			$counter++;

			if (isset($structure)) { unset($structure); }
			if (isset($sections)) { unset($sections); }
			if (isset($attachments)) { unset($attachments); }
			if (isset($embeddedattachments)) { unset($embeddedattachments); }
		}
		}
	}
}

// Calculate the total folder size
if ($mailboxinfo->Size >= 1073741824) { 
	$mailboxsize = round(round($mailboxinfo->Size / 1073741824 * 100) / 100) . " Gb"; 
}
elseif ($mailboxinfo->Size >= 1048576) { 
	$mailboxsize = round(round($mailboxinfo->Size / 1048576 * 100) / 100) . " Mb"; 
}
elseif ($mailboxinfo->Size >= 1024) { 
	$mailboxsize = round(round($mailboxinfo->Size / 1024 * 100) / 100) . " Kb"; 
}
else { 
	$mailboxsize = round($mailboxinfo->Size) . " b"; 
} 

if ($page == 1) {
	if ($numberofpages >= 3) {
		$displaypages = 3;
	}
	else {
		$displaypages = $numberofpages;
	}
	$PageInbox = preg_replace("/(\[)(ifprev)(])(\r\n)*(.*)(\[\/ifprev\])/siU", "", $PageInbox);
	for ($i = $page; $i <= $displaypages; $i++) {
		if ($page == $i) {
			$nextprev .= "<span class=\"page_current\">$i</span>";
		}
		else {
			$nextprev .= "<span class=\"page_nav\"><a class=\"page_link\" href=\"mailbox.php?n=" . $i . "&amp;f=" . $folder . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">$i</a></span>";
		}
	}
	if ($numberofpages > 1) {
		$PageInbox = str_replace("[ifnext]", "", $PageInbox);
		$PageInbox = str_replace("[/ifnext]", "", $PageInbox);
	}
	else {
		$PageInbox = preg_replace("/(\[)(ifnext)(])(\r\n)*(.*)(\[\/ifnext\])/siU", "", $PageInbox);
	}
}
elseif ($page > 1 && $page < $numberofpages) {
	if ($numberofpages >= $page + 2) {
		$offset = 2;
	}
	elseif ($numberofpages >= $page + 1) {
		$offset = 1;
	}
	$PageInbox = str_replace("[ifprev]", "", $PageInbox);
	$PageInbox = str_replace("[/ifprev]", "", $PageInbox);
	$PageInbox = str_replace("[ifnext]", "", $PageInbox);
	$PageInbox = str_replace("[/ifnext]", "", $PageInbox);
	for ($i = $page-1; $i <= $page+$offset; $i++) {
		if ($page == $i) {
			$nextprev .= "<span class=\"page_current\">$i</span>";
		}
		else {
			$nextprev .= "<span class=\"page_nav\"><a class=\"page_link\" href=\"mailbox.php?n=" . $i . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">$i</a></span>";
		}
	}
}
elseif ($page > 1 && $page == $numberofpages) {
	if ($numberofpages >= 3) {
		$displaypages = 3;
	}
	if ($numberofpages >= 2) {
		$displaypages = 2;
	}
	$PageInbox = str_replace("[ifprev]", "", $PageInbox);
	$PageInbox = str_replace("[/ifprev]", "", $PageInbox);
	$PageInbox = preg_replace("/(\[)(ifnext)(])(\r\n)*(.*)(\[\/ifnext\])/siU", "", $PageInbox);
	for ($i = $numberofpages-$displaypages; $i <= $numberofpages; $i++) {
		if ($page == $i) {
			$nextprev .= "<span class=\"page_current\">$i</span>";
		}
		else {
			if ($i <> 0) {
				$nextprev .= "<span class=\"page_nav\"><a class=\"page_link\" href=\"mailbox.php?n=" . $i . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">$i</a></span>";
			}
		}
	}
}

$PageInbox = str_replace("[prevpage]", $prevpage, $PageInbox);
$PageInbox = str_replace("[nextpage]", $nextpage, $PageInbox);
$PageInbox = str_replace("[folderencode]", $folderencode, $PageInbox);
$PageInbox = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageInbox);

$PageNavScript = "<script language=\"javascript\" type=\"text/javascript\">
<!--
function gopage(select_box_name) {
	if (select_box_name.options[select_box_name.options.selectedIndex].value != '') {
		var dest = 'mailbox.php?n=' + select_box_name.options[select_box_name.options.selectedIndex].value + '&f=" . $folderencode . "&" . strip_tags(SID) . "';
		document.location = dest;
	}

}
// -->
</script>";

for ($i=1; $i<=$numberofpages; $i++) {
	if ($i == $page) {
		$PageNavOptions .= "<option value=\"1\" selected=\"selected\">" . $lang['SMbox']['Page'] . " " . $page . " " .  $lang['SMbox']['of'] . " " . $numberofpages . "</option>";
	}
	else {
		$PageNavOptions .= "<option value=\"" . $i . "\">" . $lang['SMbox']['Page'] . " " . $i . "</option>";
	}
}
if ($numberofpages == 0) {
	$PageNavOptions .= "<option value=\"1\" selected=\"selected\">" . $lang['SMbox']['Page'] . " 1 " .  $lang['SMbox']['of'] . " 1</option>";
}

$PageInbox = str_replace("[page_navoptions]", $PageNavOptions, $PageInbox);
$PageInbox = str_replace("[page_navscript]", $PageNavScript, $PageInbox);

if ($numberofpages == 0) {
	$numberofpages = 1;
}

include ("./includes/folderpane.inc.php");

if ($IMAPConnection->_folderdelimiter <> '') {
	$summaryname = ucwords(strtolower(str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $IMAPConnection->WM_FolderDecode($_SESSION['folder']))));
}
else {
	$summaryname = ucwords(strtolower(str_replace("INBOX.", "", $IMAPConnection->WM_FolderDecode($_SESSION['folder']))));
}
$summaryname = str_replace($IMAPConnection->_folderdelimiter, " &raquo; ", $summaryname);
$inboxsummary = $summaryname . ": " . $totalmessages . " messages\n";

$CurrentInbox = str_replace("[messagelist]", $FullList, $PageInbox);
$CurrentInbox = str_replace("[inboxsummary]", $inboxsummary, $CurrentInbox);
$CurrentInbox = str_replace("[inboxmenu]", $PageInboxMenu, $CurrentInbox);

$CurrentInbox = str_replace("[page_current]", $page, $CurrentInbox);
$CurrentInbox = str_replace("[page_total]", $numberofpages, $CurrentInbox);
$CurrentInbox = str_replace("[page_nav]", $nextprev, $CurrentInbox);

$CurrentInbox = str_replace("[inboxtotalsize]", $mailboxsize, $CurrentInbox);

if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
	$CurrentInbox = str_replace("[ifimap]", "", $CurrentInbox);
	$CurrentInbox = str_replace("[/ifimap]", "", $CurrentInbox);
}
else {
	$CurrentInbox = preg_replace("/(\[)(ifimap)(])(\r\n)*(.*)(\[\/ifimap\])/siU", "", $CurrentInbox);
}

$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
$PageHeader = str_replace ("[header_refresh]", $headerrefresh, $PageHeader);
$PageHeader = str_replace ("[pagetitle]", " - " . str_replace($IMAPConnection->_folderdelimiter, " &raquo; ", $IMAPConnection->WM_FolderDecode($folder)), $PageHeader);

$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
echo $PageHeader;

$CurrentInbox = LangReplace('SMbox', $CurrentInbox, $lang);
echo $CurrentInbox;

if ($UseDatabase == 1) {
	$MySQLCloseConnection = $MySQLConnection->DB_CloseConnection();
}

$IMAPConnection->WM_IMAPClose();

echo $PageFooter;
?>