<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/html.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/view.inc.php");

require ("./includes/options.inc.php");

$id = $_GET['id'];

if ($_GET['f']) {
	$_SESSION['folder'] = strip_tags(trim($_GET['f']));
}

if (($_SESSION['sess_u'] == "") && ($_SESSION['sess_p'] == "")) {
	echo ("<p>" . $lang['SErrors']['Session'] . "</p>");
	exit;
}

$IMAPConnection = new WM_IMAPConnection($_SESSION);

$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();
if ($securitycheck == 0) {
	echo ("<p>" . $lang['SErrors']['IP'] . "</p>");
	exit;
}

$mailbox = $IMAPConnection->WM_IMAPConnect();


$numberofmessages = $IMAPConnection->WM_IMAPNumMessages();
$header = $IMAPConnection->WM_IMAPRFCHeader($id);

$crlf = $MainSettings->GetCRLF();
$IMAPConnection->_crlf = $crlf;

$structure = $IMAPConnection->WM_IMAPGetStructure($id);

if (sizeof($structure->parts) >= 1) {
	// Split the structure of the message into sections
	$sections = parseBody($structure);

	// Get Standard Attachments
	$attachments = get_attachments($sections);

	// Get Inline/Embedded Attachments
	$embeddedattachments = get_embeddedattachments($sections);
}

if (is_array($sections)) {
	for($x=0; $x<sizeof($sections); $x++) {
		if ($sections[$x]["type"] == "multipart/alternative" && $sections[$x]["disposition"] != "attachment") {
			$message["alternative"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
		}
		elseif ($sections[$x]["type"] == "text/html"  && $sections[$x]["disposition"] != "attachment") {
			$message["html"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
			$message["html"] = stripslashes(parseEncoding($message["html"], $sections[$x]["encoding"]));
		}
		elseif ($sections[$x]["type"] == "text/plain"  && $sections[$x]["disposition"] != "attachment") {
			$message["text"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
			$message["text"] = parseEncoding($message["text"], $sections[$x]["encoding"]);
			$message["text"] = nl2br(htmlspecialchars(stripslashes(trim($message["text"]))));
		}

	}
	if (isset($message["html"]) && ($HTMLemail == 1 || ($HTMLemail == 2 && !isset($message["text"])))) {
		$content = $message["html"];
		$view_styleformat = "view_html";
	}
	else {
		$content = parseLinks($message["text"], 1);
		$content = str_replace("\t", "&nbsp;&nbsp;", $content);
		$view_styleformat = "view_text";
	}
}
else {
	if (($structure->subtype == "HTML" || $structure->subtype == "ALTERNATIVE") && ($HTMLemail == 1 || $HTMLemail == 2)) {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = stripslashes(parseEncoding($content, $encoding[$structure->encoding]));
		$content = SeperateSignature($SeperateSignature, $content);
		$content = nl2br($content);
		$view_styleformat = "view_html";
	}
	elseif (($structure->subtype == "HTML" || $structure->subtype == "ALTERNATIVE") && ($HTMLemail == 3)) {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = parseEncoding($content, $encoding[$structure->encoding]);
		$content = htmlspecialchars(stripslashes(trim($content)));
		$content = SeperateSignature($SeperateSignature, $content);
		$content = nl2br($content);
		$content = parseLinks($content, 1);
		$view_styleformat = "view_text";
	}
	elseif (($structure->subtype == "HTML" || $structure->subtype == "ALTERNATIVE") && ($HTMLemail == 4)) {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = parseEncoding($content, $encoding[$structure->encoding]);
		$content = strip_tags(htmlspecialchars(stripslashes(trim($content))));
		$content = SeperateSignature($SeperateSignature, $content);
		$content = nl2br($content);
		$content = parseLinks($content, 1);
		$view_styleformat = "view_text";
	}
	else {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = parseEncoding($content, $encoding[$structure->encoding]);
		$content = htmlspecialchars(stripslashes(trim($content)));
		$content = SeperateSignature($SeperateSignature, $content);
		$content = str_replace("\t", "&nbsp;&nbsp;", $content);
		$content = nl2br($content);
		$content = parseLinks($content, 1);
		$view_styleformat = "view_text";
	}
}

// Find any embedded images and replace their ID in the body of the message so we can view them
if (is_array($embeddedattachments)) {
	if ($_SERVER['HTTPS'] == "on") {
		$currprot = 'https://';
	}
	else {
		$currprot = 'http://';
	}
	for($x=0; $x<sizeof($embeddedattachments); $x++) {
		// Note this calls the same file as attachment download but we must set submit=inline to allow display rather than download
		$content = str_replace("cid:" . $embeddedattachments[$x]["id"], $currprot . $_SERVER['HTTP_HOST'] . str_replace("print.php", "attachment.php?submit=inline&amp;id=$id&amp;pid=" . $embeddedattachments[$x]["pid"]  . "&amp;" . strip_tags(SID), $_SERVER['PHP_SELF']), $content);
	}
}

$IMAPConnection->WM_IMAPGetHeader($id);
$headerdetails = $IMAPConnection->WM_IMAPFullHeaders();
$subj = $IMAPConnection->WM_IMAPGetSubject();

$localtime_date = DateToLocal($tz, $headerdetails['date'], $DateFormattingFull);

header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
echo ("<html lang=\"" . $_SESSION['DefaultLang'] . "\">
<head>
<title>$subj</title>
<script language=\"JavaScript\" type=\"text/javascript\">
<!--

var docAll = (document.all) ? 1 : 0;
var iprint = (window.print) ? 1 : 0;
var mac = (navigator.userAgent.indexOf(\"Mac\") != -1);

function printPage() {

	if (iprint) // NS4, NS6, IE5, IE6
	{
		window.print();
	}

	else // all other browsers
	{
		alert(\"" . $lang['SErrors']['Print'] . "\");
	}

	return false;
}



// -->
</script>
<style type=\"text/css\">
td {
	font-family: arial,helvetica;
	color:#000000;
	font-size:12px;
}
</style>
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" . $_SESSION['DefaultCharSet'] . "\" />
</head>
<body onload=\"printPage();\">
");
if (isset($pname)) {
	echo ("<div style=\"font-family: arial,helvetica; color:#000000; font-weight:bold; border-bottom-style:solid; border-bottom-width: 2px; border-bottom-color: #000000; font-size:14px;\">$pname</div>");
}
else {
	echo ("<div style=\"font-family: arial,helvetica; color:#000000; font-weight:bold; border-bottom-style:solid; border-bottom-width: 2px; border-bottom-color: #000000; font-size:14px;\">" . $_SESSION['currentemailaddress'] . "</div>");
}
echo ("<table><tr><td><b>" . $lang['SView']['From'] . ":</b></td><td>" . htmlspecialchars($headerdetails['fromaddress']) . "</td></tr>");
echo ("<tr><td><b>" . $lang['SView']['Sent'] . ":</b></td><td>" . $localtime_date . "</td></tr>");
echo ("<tr><td><b>" . $lang['SView']['To'] . ":</b></td><td>" . htmlspecialchars($headerdetails['toaddress']) . "</td></tr>");
if ($headerdetails['ccaddress'] <> "") {
	echo ("<tr><td><b>" . $lang['SView']['Cc'] . ":</b></td><td>" . htmlspecialchars($headerdetails['ccaddress']) . "</td></tr>");
}
echo ("<tr><td><b>" . $lang['SView']['Subject'] . ":</b></td><td>" . $subj . "</td></tr></table><br /><br />");
echo ("<div style=\"font-family: courier new, courier; font-size:12px; color: #000000;\">$content</div>
</body></html>");
$IMAPConnection->WM_IMAPClose();

?>