<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/mailbox.inc.php");

require ("./includes/options.inc.php");

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageSearchResults = $getFile->fileRead('searchresults');
$PageSearchList = $getFile->fileRead('searchlist');
$PageSearchForm = $getFile->fileRead('searchform');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SMbox']['SearchTitle'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

include ("./includes/folderpane.inc.php");
$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
echo $PageHeader;

$IMAPConnection->WM_IMAPClose();

if (!$_POST['keywords']) {
	$search_form = "<form action=\"search.php\" method=\"post\">" . $MainSettings->SessAppend_form($TransIDEnabled);
	$PageSearchForm = str_replace ("[search_form]", $search_form, $PageSearchForm);
	$PageSearchFolders = $getFile->fileRead('search_folders');
	if ($folders) {
		for($i=0; $i<count($folders); $i++) {
			$currentfolder = str_replace("[folderid]", $folders[$i]['id'], $PageSearchFolders);
			if ($folders[$i]['id'] == "INBOX") {
				$currentfolder = str_replace("value=\"INBOX\"", "value=\"INBOX\" checked=\"checked\" selected=\"selected\"", $currentfolder);
			}
			$currentfolder = str_replace("[foldername]", str_replace("INBOX.", " - ", $folders[$i]['name']), $currentfolder);
			$generatefolders .= $currentfolder;
		}
	}
	else {
		$currentfolder = str_replace("[folderid]", "INBOX", $PageSearchFolders);
		$currentfolder = str_replace("value=\"INBOX\"", "value=\"INBOX\" checked=\"checked\" selected=\"selected\"", $currentfolder);
		$currentfolder = str_replace("[foldername]", "INBOX", $currentfolder);
		$generatefolders = $currentfolder;
	}

	$PageSearchForm = str_replace ("[folderlist]", $generatefolders, $PageSearchForm);
	$PageSearchForm = LangReplace('SMbox', $PageSearchForm, $lang);
	echo $PageSearchForm;
}
else {
	$PageGenericMessage = $getFile->fileRead('generic_message');
	$PageGenericMessage = str_replace("[pagetitle]", " - " . $lang['SMbox']['SearchTitle'], $PageGenericMessage);

	if (in_array ("FROM", $_POST['searchtype'])) {
		$buildphrase .= ' FROM "' . strip_tags(trim($_POST['keywords'])) . '"';
	}
	if (in_array ("TO", $_POST['searchtype'])) {
		$buildphrase .= ' TO "' . strip_tags(trim($_POST['keywords'])) . '"';
	}
	if (in_array ("CC", $_POST['searchtype'])) {
		$buildphrase .= ' CC "' . strip_tags(trim($_POST['keywords'])) . '"';
	}
	if (in_array ("BODY", $_POST['searchtype'])) {
		$buildphrase .= ' BODY "' . strip_tags(trim($_POST['keywords'])) . '"';
	}
	if (in_array ("SUBJECT", $_POST['searchtype'])) {
		$buildphrase .= ' SUBJECT "' . strip_tags(trim($_POST['keywords'])) . '"';
	}
	if ($_POST['searchtime'] >= 1) {
		$nowuts = time();
		$searchoffset = $_POST['searchtime'] * 86400;
		$searchuts = $nowuts - $searchoffset;
		$formattedoffset = date("D, d M Y", $searchuts);
		if ($_POST['beforeafter'] == "after") {
			$buildphrase .= ' SINCE "' . strip_tags(trim($formattedoffset)) . '"';
		}
		elseif ($_POST['beforeafter'] == "before") {
			$buildphrase .= ' BEFORE "' . strip_tags(trim($formattedoffset)) . '"';
		}
	}

	$buildphrase = trim ($buildphrase);
	$whichfolders = $_POST['search_folder'];
	$sortorder = $_POST['sortorder'];

	$sortcolumn = $_POST['sortcolumn'];

	if (!$whichfolders) {
		$PageGenericMessage = str_replace("[pagemessage]", $lang['SMbox']['SearchFolderError'], $PageGenericMessage);
		$PageGenericMessage = LangReplace('SMbox', $PageGenericMessage, $lang);
		echo $PageGenericMessage;
	}
	else {
		$noresults = 1;
		for ($i = 0; $i < sizeof($whichfolders); $i++) {
			$_SESSION['folder'] = $whichfolders[$i];
			$mailbox = $IMAPConnection->WM_IMAPConnect();
			$searchmessages = $IMAPConnection->WM_IMAPSearch($buildphrase, $sortcolumn, $sortorder);

			$currrow = 1;

			if (is_array($searchmessages)) {
				$noresults = 0;
				while(list($key, $value) = each($searchmessages)) { 

					$structure = $IMAPConnection->WM_IMAPGetStructure($searchmessages[$key]['message_uid']);
					$IMAPConnection->WM_IMAPGetHeader($searchmessages[$key]['message_uid']);
					if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
						if (($IMAPConnection->_msgheader->Recent == "N") || ($IMAPConnection->_msgheader->Unseen == "U")) {
							$messagenew = 1;
							$message_envelope = "<img src=\"images/mailbox/mail_new.gif\" alt=\"" . $lang['SMbox']['New'] . "\" />";
						}
						else {
							$messagenew = 0;
							$message_envelope = "<img src=\"images/mailbox/mail_read.gif\" alt=\"" . $lang['SMbox']['Read'] . "\" />";
						}
						if ($IMAPConnection->_msgheader->Answered == "A") {
							$messageanswered = 1;
							$message_envelope = "<img src=\"images/mailbox/mail_reply.gif\" alt=\"" . $lang['SMbox']['Replied'] . "\" />";
						}
						else {
							$messageanswered = 0;
						}
					}
					else {
						$message_envelope = "<img src=\"images/mailbox/mail_new.gif\" alt=\"" . $lang['SMbox']['Message'] . "\" />";
					}
					$sections = parseBody($structure);
					$attachments = get_attachments($sections);
					if (is_array($attachments)) {
						$message_attachment = "<img alt=\"" . $lang['SMbox']['Attachment'] . "\" width=\"10\" height=\"13\" src=\"images/mailbox/attach.gif\" />";
					}
					else {
						$message_attachment = "&nbsp;";
					} 
					$message_size = ceil(($IMAPConnection->_msgheader->Size/1024)) . " Kb"; 

					if ($currrow == 1) {
						$classid = "col1";
						$currrow = 2;
					}
					else {
						$classid = "col2";
						$currrow = 1;
					}
					if ($messagenew == 1) {
						$classid = "colnew";
					}

					$CodeSearch = array (
						"[message_number]",
						"[message_title]",
						"[message_from]",
						"[session_append]",
						"[message_date]",
						"[message_attachment]",
						"[message_size]",
						"[rowcolour]",
						"[folderid]",
						"[message_envelope]"
					);

					if ($searchmessages[$key]['message_title'] == "") {
						$searchmessages[$key]['message_title'] = $lang['NoSubject'];
					}

					$CodeReplace = array (
						$searchmessages[$key]['message_uid'],
						$searchmessages[$key]['message_title'],
						$searchmessages[$key]['message_from'],
						$MainSettings->SessAppend_noecho($TransIDEnabled, 0),
						substr($searchmessages[$key]['message_date'], 0, 22),
						$message_attachment,
						$message_size,
						$classid,
						urlencode($_SESSION['folder']),
						$message_envelope
					);
	
					$CurrentMessage = str_replace ($CodeSearch, $CodeReplace, $PageSearchList);
					$FullList .= $CurrentMessage;
				}
			}
			$IMAPConnection->WM_IMAPClose();
		}
		if ($noresults == 1) {
			$PageGenericMessage = str_replace("[pagemessage]", $lang['SMbox']['SearchResultsError'], $PageGenericMessage);
			$PageGenericMessage = LangReplace('SMbox', $PageGenericMessage, $lang);
			echo $PageGenericMessage;
		}

		$CurrentSearch = str_replace ("[messagelist]", $FullList, $PageSearchResults);
		$CurrentSearch = str_replace ("[searchsummary]", sizeof($searchmessages), $CurrentSearch);
		unset ($searchmessages);
		if ($noresults == 0) {
			$CurrentSearch = LangReplace('SMbox', $CurrentSearch, $lang);
			echo $CurrentSearch;
		}
	}
}

echo $PageFooter;
?>
