<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/html.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/view.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/mailbox.inc.php");

require ("./includes/options.inc.php");

$id = intval(strip_tags($_GET['id']));
$folder = strip_tags($_GET['f']);
$folderencode = urlencode($folder);
$rr = strip_tags($_GET['rr']);
$switch = strip_tags($_GET['switch']);

if ($_GET['f']) {
	$_SESSION['folder'] = strip_tags(trim($_GET['f']));
}

if (isset($_GET['w']) && $_GET['w'] == 'popup') {
	$prependheader = "popup_";
}
elseif (isset($_GET['w']) && $_GET['w'] == 'preview') {
	$prependheader = "preview_";
}
else {
	$prependheader = "";
}

if (isset($_GET['ap']) && $_GET['ap'] == 0) {
	$eoptions['AutoPreview'] = $_GET['ap'];
	$AutoPreview = 0;
	$_SESSION['extoptions'] = serialize($eoptions);
	if ($UseDatabase == 1) {
		$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($eoptions), 'extended');
	}
}

if ($switch == $lang['SView']['ViewHTML']) {
	$HTMLemailmode = "1";
}
elseif ($switch == $lang['SView']['ViewHTMLImages']) {
	$HTMLemailmode = "5";
}
elseif ($switch == $lang['SView']['ViewText']) {
	$HTMLemailmode = "4";
}

// If you want to display the file type instead of file icons, set this to 0
$useattachmenticons = 1;

if (isset($HTMLemailmode)) {
	$myoptions['HTMLemail'] = $HTMLemailmode;
	$_SESSION['dwmailoptions'] = serialize($myoptions);
	if ($UseDatabase == 1) {
		$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
	}
	else {
		if ($AllowCookies == 1) {
			$expiretime = 3600 * 8760;
			setcookie ("dwmailoptions", serialize($myoptions), time()+$expiretime);
		}
	}
	$HTMLemail = $HTMLemailmode;
}

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead($prependheader . 'header');
$PageFooter = $getFile->fileRead($prependheader . 'footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageView = $getFile->fileRead('viewmessage');
$PageViewMenu = $getFile->fileRead('viewmenu');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SView']['Title'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

$IMAPConnection->WM_IMAPGetHeader($id);
$headerdetails = $IMAPConnection->WM_IMAPFullHeaders();

if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
	$movemessage = "<script language=\"javascript\" type=\"text/javascript\">
<!--
function domove(select_box_name) {
	if (select_box_name.options[select_box_name.options.selectedIndex].value != '') {
		document.location = 'movemessage.php?selection=" . $id . "&f=' + select_box_name.options[select_box_name.options.selectedIndex].value + '&" . strip_tags(SID) . "';
	}

}
// -->
</script>
<select name=\"df\" onchange=\"domove(this);\">
<option value=\"\">-- " . $lang['SMove']['MoveSelection'] . " --</option>";
	$folderget = $IMAPConnection->WM_IMAPFolders($IMAPSubscriptions);
	$folders = $IMAPConnection->_folders;
	sort($folders);
	for($i=0; $i<count($folders); $i++) {
		$movemessage .= "<option value=\"" . urlencode($folders[$i]['id']) . "\">" . str_replace("INBOX.", " - ", $folders[$i]['name']) . "</option>\n";
	}
	$movemessage .= "</select>";
}
else {
	$movemessage = "";
}

include ("./includes/folderpane.inc.php");
$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

$subj = $IMAPConnection->WM_IMAPGetSubject();

if ($subj == "") {
	$subj = $lang['SView']['NoSubject'];
}

$CodeSearch = array (
	"[view_id]",
	"[session]",
	"[session_append]"
);

$CodeReplace = array (
	$id,
	$MainSettings->SessAppend_noecho($TransIDEnabled, 1),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 0)
);

$PageViewMenu = str_replace ($CodeSearch, $CodeReplace, $PageViewMenu);

$crlf = $MainSettings->GetCRLF();
$IMAPConnection->_crlf = $crlf;
$IMAPConnection->_charset = $_SESSION['DefaultCharSet'];

// Find a read receipt header
$header_full = $IMAPConnection->WM_IMAPRFCHeader($id);
$header_arry = explode ("\n", $header_full);
$line_number = 0; 
$have_notification = 0;

if (urldecode($_SESSION['folder'] <> $IMAPSentMail)) {

	while ($line = $header_arry[$line_number]) { 
		$line = trim($line);
		if ((strstr($line, "Disposition-Notification-To:")) || (strstr($line, "Return-Receipt-To:"))) {
			$notification_address = str_replace ("Disposition-Notification-To:", "", $line);
			$notification_address = str_replace ("Return-Receipt-To:", "", $line);
			$notification_address = str_replace ('"', "", $notification_address);
			$notification_address = trim($notification_address);
			if (eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*$", $notification_address)) {
				$notemail = $notification_address;
			}
			else {
				$notemail = $headerdetails['fromaddress'];
			}
			$have_notification = 1;
		}
		$line_number++; 
	}
	if (($have_notification == 1) && (($headerdetails['Unseen'] == "U") || ($headerdetails['Recent'] == "N"))) {
		$receipttext = $notemail . ' ' . $lang['SView']['ReadReceipt'];
		$receiptjs = "<script language=\"JavaScript\" type=\"text/javascript\">
<!--
if (confirm(\"$receipttext\")) {
	document.location = 'view.php?" . $_SERVER['QUERY_STRING'] . "&rr=1&" . strip_tags(SID) . "';
}
//-->
</script>";
		$ask_receipt = 1;
	}
}

// This sets the message headers to read
$SetRead = $IMAPConnection->WM_IMAPSetFlag("\\Seen", $id);

// Find an importance header
if (strstr($header_full, 'Importance:')) {
	$header_arry = explode ("\n", $header_full);
	$line_number = 0; 
	$have_importance = 0;
	while ($line = $header_arry[$line_number]) { 
		$line = trim($line);
		if (strstr($line, "Importance:")) {
			$importancelevel = str_replace ("Importance:", "", $line);
			$importancelevel = trim($importancelevel);
			$have_importance = 1;
		}
		$line_number++; 
	}
}

if ($importancelevel == "High") {
	$importancegraphic = '<img src="templates/' . $DefaultTemplate . '/images/mailbox/important.gif" alt="' . $lang['SMbox']['Importance'] . ': ' . $lang['SMbox']['ImportanceHigh'] . '" />';	
	$importancetext = $lang['SMbox']['ImportanceHighDesc'];
}
elseif ($importancelevel == "Low") {
	$importancegraphic = '<img src="templates/' . $DefaultTemplate . '/images/mailbox/low.gif" alt="' . $lang['SMbox']['Importance'] . ': ' . $lang['SMbox']['ImportanceLow'] . '" />';	
	$importancetext = $lang['SMbox']['ImportanceLowDesc'];
}
elseif ($importancelevel == "Normal") {
	$have_importance = 0;
}
else {
	$importancegraphic = '&nbsp;';	
}

if ($have_importance == 1) {
	$PageView = str_replace('[importance_icon]', $importancegraphic, $PageView);
	$PageView = str_replace('[importance_message]', $importancetext, $PageView);
	$PageView = str_replace('[ifimportance]', '', $PageView);
	$PageView = str_replace('[/ifimportance]', '', $PageView);
}
else {
	$PageView = preg_replace("/(\[)(ifimportance)(])(\r\n)*(.*)(\[\/ifimportance\])/siU", "", $PageView);
}

$PageView = preg_replace("/(\[)(ifcalendarerror)(])(\r\n)*(.*)(\[\/ifcalendarerror\])/siU", "", $PageView);

$structure = $IMAPConnection->WM_IMAPGetStructure($id);
$contenttype = strtolower($type[$structure->type] . '/' . $structure->subtype);

if (sizeof($structure->parts) >= 1) {
	// Split the structure of the message into sections
	$sections = parseBody($structure);

	// Get Standard Attachments
	$attachments = get_attachments($sections);

	// Get Inline/Embedded Attachments
	$embeddedattachments = get_embeddedattachments($sections);

	// All attachments (it's possible that embedded attachments could duplicate standard attachments 'if' the disposition of 'inline' is not set
	if (is_array($attachments) && is_array($embeddedattachments)) {
		$allattachments = array_merge($attachments, $embeddedattachments);
	}
	elseif (is_array($embeddedattachments)) {
		$allattachments = $embeddedattachments;
	}
	else {
		$allattachments = $attachments;
	}

}

// Sections is an array if the message is multipart
if (is_array($sections)) {
	for($x=0; $x<sizeof($sections); $x++) {
		if ($sections[$x]["type"] == "multipart/alternative" && $sections[$x]["disposition"] != "attachment") {
			$message["alternative"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
		}
		elseif ($sections[$x]["type"] == "text/html"  && $sections[$x]["disposition"] != "attachment") {
			$message["html"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
			$message["html"] = stripslashes(parseEncoding($message["html"], $sections[$x]["encoding"]));
			$charsetarry["html"] = $sections[$x]["charset"];
		}
		elseif ($sections[$x]["type"] == "text/plain"  && $sections[$x]["disposition"] != "attachment") {
			$message["text"] = $IMAPConnection->WM_IMAPGetBody($id, $sections[$x]["pid"], $sections[$x]["subpart"]);
			$message["text"] = parseEncoding($message["text"], $sections[$x]["encoding"]);
			$message["text"] = nl2br(htmlspecialchars(stripslashes(trim($message["text"]))));
			$charsetarry["text"] = $sections[$x]["charset"];
		}
	}
	if (isset($message["html"]) && ($HTMLemail == 1 || $HTMLemail == 5 || ($HTMLemail == 2 && !isset($message["text"])))) {
		$content = $message["html"];
		$charset = $charsetarry["html"];
		$view_styleformat = "view_html";
		if ($HTMLemail == "5") {
			$content = str_replace("src=", "removedsrc=", $content);
			$PageView = preg_replace("/(\[)(ifhtml)(])(\r\n)*(.*)(\[\/ifhtml\])/siU", "", $PageView);
			$PageView = preg_replace("/(\[)(iftext)(])(\r\n)*(.*)(\[\/iftext\])/siU", "", $PageView);
			$PageView = str_replace('[ifhtmlnoimages]', '', $PageView);
			$PageView = str_replace('[/ifhtmlnoimages]', '', $PageView);
		}
		else {
			$PageView = preg_replace("/(\[)(ifhtmlnoimages)(])(\r\n)*(.*)(\[\/ifhtmlnoimages\])/siU", "", $PageView);
			$PageView = preg_replace("/(\[)(iftext)(])(\r\n)*(.*)(\[\/iftext\])/siU", "", $PageView);
			$PageView = str_replace('[ifhtml]', '', $PageView);
			$PageView = str_replace('[/ifhtml]', '', $PageView);
		}
		$CleanUpHTML = new HTMLCleanup($content);
		$CleanUpHTML->ChangeTarget();
		$CleanUpHTML->RemoveScripting();
		$CleanUpHTML->RemoveMalicious();
		$content = $CleanUpHTML->_body;
	}
	elseif ((isset($message["html"])) && (!isset($message["text"])) && ($HTMLemail == 4)) {
		$content = nl2br(parseLinks(strip_tags($message["html"]), 1));
		$charset = $charsetarry["html"];
		$view_styleformat = "view_text";
		$PageView = preg_replace("/(\[)(ifhtmlnoimages)(])(\r\n)*(.*)(\[\/ifhtmlnoimages\])/siU", "", $PageView);
		$PageView = preg_replace("/(\[)(ifhtml)(])(\r\n)*(.*)(\[\/ifhtml\])/siU", "", $PageView);
		$PageView = str_replace('[iftext]', '', $PageView);
		$PageView = str_replace('[/iftext]', '', $PageView);
	}
	else {
		$content = parseLinks($message["text"], 1);
		$charset = $charsetarry["text"];
		$content = str_replace("\t", "&nbsp;&nbsp;", $content);
		$view_styleformat = "view_text";
		if (isset($message["html"])) {
			$PageView = preg_replace("/(\[)(ifhtmlnoimages)(])(\r\n)*(.*)(\[\/ifhtmlnoimages\])/siU", "", $PageView);
			$PageView = preg_replace("/(\[)(ifhtml)(])(\r\n)*(.*)(\[\/ifhtml\])/siU", "", $PageView);
			$PageView = str_replace('[iftext]', '', $PageView);
			$PageView = str_replace('[/iftext]', '', $PageView);
		}
	}
}
else {
	if ($currpart->ifparameters == 1) {
		if ($currpart->parameters) {
			foreach ($currpart->parameters as $p2) {
				if (strtolower($p2->attribute) == 'charset') {
					$charset = $p2->value;
				}
			}
		}
	}
	if (($structure->subtype == "HTML" || $structure->subtype == "ALTERNATIVE") && ($HTMLemail == 1 || $HTMLemail == 2 || $HTMLemail == 5)) {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = stripslashes(parseEncoding($content, $encoding[$structure->encoding]));
		$content = SeperateSignature($SeperateSignature, $content);
		$content = $content;
		$view_styleformat = "view_html";
		if ($HTMLemail == "5") {
			$content = str_replace("src=", "removedsrc=", $content);
			$PageView = preg_replace("/(\[)(ifhtml)(])(\r\n)*(.*)(\[\/ifhtml\])/siU", "", $PageView);
			$PageView = preg_replace("/(\[)(iftext)(])(\r\n)*(.*)(\[\/iftext\])/siU", "", $PageView);
			$PageView = str_replace('[ifhtmlnoimages]', '', $PageView);
			$PageView = str_replace('[/ifhtmlnoimages]', '', $PageView);
		}
		else {
			$PageView = preg_replace("/(\[)(ifhtmlnoimages)(])(\r\n)*(.*)(\[\/ifhtmlnoimages\])/siU", "", $PageView);
			$PageView = preg_replace("/(\[)(iftext)(])(\r\n)*(.*)(\[\/iftext\])/siU", "", $PageView);
			$PageView = str_replace('[ifhtml]', '', $PageView);
			$PageView = str_replace('[/ifhtml]', '', $PageView);
		}
		$CleanUpHTML = new HTMLCleanup($content);
		$CleanUpHTML->ChangeTarget();
		$CleanUpHTML->RemoveScripting();
		$CleanUpHTML->RemoveMalicious();
		$content = $CleanUpHTML->_body;
	}
	elseif (($structure->subtype == "HTML" || $structure->subtype == "ALTERNATIVE") && ($HTMLemail == 3)) {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = parseEncoding($content, $encoding[$structure->encoding]);
		$content = htmlspecialchars(stripslashes(trim($content)));
		$content = SeperateSignature($SeperateSignature, $content);
		$content = nl2br($content);
		$content = parseLinks($content, 1);
		$view_styleformat = "view_text";
		$PageView = preg_replace("/(\[)(ifhtmlnoimages)(])(\r\n)*(.*)(\[\/ifhtmlnoimages\])/siU", "", $PageView);
		$PageView = preg_replace("/(\[)(ifhtml)(])(\r\n)*(.*)(\[\/ifhtml\])/siU", "", $PageView);
		$PageView = str_replace('[iftext]', '', $PageView);
		$PageView = str_replace('[/iftext]', '', $PageView);
	}
	elseif (($structure->subtype == "HTML" || $structure->subtype == "ALTERNATIVE") && ($HTMLemail == 4)) {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = parseEncoding($content, $encoding[$structure->encoding]);
		$content = htmlspecialchars(strip_tags(stripslashes(trim($content))));
		$content = SeperateSignature($SeperateSignature, $content);
		$content = nl2br($content);
		$content = parseLinks($content, 1);
		$view_styleformat = "view_text";
		$PageView = preg_replace("/(\[)(ifhtmlnoimages)(])(\r\n)*(.*)(\[\/ifhtmlnoimages\])/siU", "", $PageView);
		$PageView = preg_replace("/(\[)(ifhtml)(])(\r\n)*(.*)(\[\/ifhtml\])/siU", "", $PageView);
		$PageView = str_replace('[iftext]', '', $PageView);
		$PageView = str_replace('[/iftext]', '', $PageView);
	}
	elseif ($structure->type >= 3) {
		// This is an attached file with NO plain text part
		// Add to $allattachments
		$allattachments[0]["pid"] = '0';
		$allattachments[0]["type"] = $type[$structure->type] . '/' . $structure->subtype;
		$allattachments[0]["encoding"] = $structure->encoding;
		$allattachments[0]["size"] = $structure->bytes;
		$allattachments[0]["disposition"] = $structure->disposition;
		$allattachments[0]["typeid"] = $structure->type;
		$allattachments[0]["subpart"] = -1;
		$allattachments[0]["description"] = $structure->description;

		if ($structure->parameters) {
			foreach ($structure->parameters as $p2) {
				$allattachments[0]["name"] = $p2->value;
			}
		}

		if (strtolower($structure->disposition) == "attachment" || strtolower($structure->disposition) == "inline") {
			$params = $structure->dparameters;
			if ($params) {
				foreach ($params as $p) {
					if($p->attribute == "FILENAME" || $p->attribute == "filename")	{
						$allattachments[0]["name"] = $p->value;
						break;
					}
				}
			}
		}
		$content = '';
		$view_styleformat = "view_text";
		$pid = 0;
	}
	else {
		$content = $IMAPConnection->WM_IMAPGetBody($id, -1, -1);
		$content = parseEncoding($content, $encoding[$structure->encoding]);
		$content = htmlspecialchars(stripslashes(trim($content)));
		$content = str_replace("\t", "&nbsp;&nbsp;", $content);
		$content = SeperateSignature($SeperateSignature, $content);
		$content = nl2br($content);
		$content = parseLinks($content, 1);
		$view_styleformat = "view_text";
	}
}

$PageView = preg_replace("/(\[)(ifhtmlnoimages)(])(\r\n)*(.*)(\[\/ifhtmlnoimages\])/siU", "", $PageView);
$PageView = preg_replace("/(\[)(iftext)(])(\r\n)*(.*)(\[\/iftext\])/siU", "", $PageView);
$PageView = preg_replace("/(\[)(ifhtml)(])(\r\n)*(.*)(\[\/ifhtml\])/siU", "", $PageView);

// Attachment size displayed here is the size it takes in the email, not the download size (as attachments are binary encoded)
// The Attachment download page displays the final decoded file size

$loadedrfc822 = 0;

// Display attachments
for($x=0; $x<sizeof($allattachments); $x++) {
	if ($allattachments[$x]["type"] == 'message/rfc822') {
		$attachmentlink = "view.rfc822.php?id=$id&amp;pid=" . $allattachments[$x]["pid"] . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0);
	}
	elseif ($allattachments[$x]["type"] == 'text/calendar') {
		$attachmentlink = "view.ics.php?id=$id&amp;pid=" . $allattachments[$x]["pid"] . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0);
	}
	else {
		$attachmentlink = "attachment.php?id=$id&amp;pid=" . $allattachments[$x]["pid"] . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0);
	}

	if ($allattachments[$x]["type"] == 'message/rfc822' && $loadedrfc822 == 0) {
		require_once ("./includes/rfc822.inc.php");
		require_once ("./includes/3rdparty/MIME/mimeDecode.inc.php");
		$loadedrfc822 = 1;

		$headerfull = $IMAPConnection->WM_IMAPRFCHeader($id);
		$bodyfull = $IMAPConnection->WM_IMAPGetBody($id, -1, -1, 1);

		$RFC822Message = new RFC822($_SESSION);
		$RFC822Parts = $RFC822Message->GetParts($headerfull, $bodyfull);

		$params['include_bodies'] = true;
		$params['decode_bodies']  = true;
		$params['decode_headers'] = true;
	}

	if ($allattachments[$x]["type"] == 'message/rfc822') {
		$RFC822Content = $RFC822Parts[$allattachments[$x]["pid"]];

		$RFCDecode = new Mail_mimeDecode($RFC822Content);
		$ReturnMessage = $RFCDecode->decode($params);
	}

	if ($useattachmenticons == 1) {
		if ($allattachments[$x]["type"] == 'image/gif') {
			$icongra = "images/icons/gif.gif";
		}
		elseif ($allattachments[$x]["type"] == 'message/rfc822') {
			$icongra = "images/icons/rfc822.gif";
		}
		elseif ($allattachments[$x]["type"] == 'text/calendar') {
			$icongra = "images/icons/appointment.gif";
		}
		elseif ($allattachments[$x]["type"] == 'image/png') {
			$icongra = "images/icons/png.gif";
		}
		elseif ($allattachments[$x]["type"] == 'image/jpeg' || $allattachments[$x]["type"] == 'image/pjpeg') {
			$icongra = "images/icons/jpg.gif";
		}
		elseif ($allattachments[$x]["type"] == 'application/x-zip' || $allattachments[$x]["type"] == 'application/zip') {
			$icongra = "images/icons/zip.gif";
		}
		elseif ($allattachments[$x]["type"] == 'application/pdf') {
			$icongra = "images/icons/pdf.gif";
		}
		elseif ($allattachments[$x]["type"] == 'text/plain') {
			$icongra = "images/icons/txt.gif";
		}
		elseif ($allattachments[$x]["type"] == 'text/richtext' || $allattachments[$x]["type"] == 'text/html') {
			$icongra = "images/icons/rtf.gif";
		}
		elseif ($allattachments[$x]["type"] == 'application/msword') {
			$icongra = "images/icons/doc.gif";
		}
		else {
			$icongra = "templates/$DefaultTemplate/images/mailbox/attach.gif";
		}
		$attachmentdetails .= "<img alt=\"" . $allattachments[$x]["type"] . "\" src=\"$icongra\" /> <a href=\"$attachmentlink\" title=\"" . $allattachments[$x]["type"] . "\">";
	}
	else {
		$attachmentdetails .= "<img alt=\"" . $lang['SView']['Attachment'] . "\" width=\"10\" height=\"13\" src=\"templates/' . $DefaultTemplate . '/images/mailbox/attach.gif\" /> " . $allattachments[$x]["type"] . " <a href=\"$attachmentlink\">";
	}
	if (isset($allattachments[$x]["name"])) {
		$attachmentdetails .= $allattachments[$x]["name"];
	}
	else {
		if (isset($ReturnMessage)) {
			if ($ReturnMessage->headers['subject'] == '') {
				$attachmentdetails .= $lang['SView']['NoSubject'];
			}
			else {
				$attachmentdetails .= $ReturnMessage->headers['subject'];
			}
		}
		elseif (isset($allattachments[$x]["description"])) {
			$attachmentdetails .= $allattachments[$x]["description"];
		}
		else {
			$attachmentdetails .= $lang['SView']['NoAttachmentName'];
		}
	}
	$attachmentdetails .= " (" . ceil($allattachments[$x]["size"]/1024). " Kb)</a><br />";
}

if ($attachmentdetails == "") {
	// Old 'No attachments' code displayed a 'none' instead of removing the header
	// $attachmentdetails = $lang['SView']['NoAttach'];
	$PageView = preg_replace("/(\[)(ifattachments)(])(\r\n)*(.*)(\[\/ifattachments\])/siU", "", $PageView);
}
else {
	$PageView = str_replace('[ifattachments]', '', $PageView);
	$PageView = str_replace('[/ifattachments]', '', $PageView);
}

$CurrentSeqNo = $IMAPConnection->GetSeqNum($id);

if ($CurrentSeqNo > 1) {
	$prevmsgid = $IMAPConnection->GetSeqNum($id) - 1;
	if ($_SESSION['servertype'] == 'imap' || $_SESSION['servertype'] == "imapssl") {
		$prevmsgid = $IMAPConnection->GetUID($prevmsgid);
	}
	$nextprev .= "<a href=\"view.php?id=" . $prevmsgid . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['SView']['PrevMess'] . "</a> | ";
}
else {
	$nextprev .= $lang['SView']['PrevMess'] . ' | ';
}

$numberofmessages = $IMAPConnection->WM_IMAPNumMessages();

if ($CurrentSeqNo < $numberofmessages) {
	$nextmsgid = $IMAPConnection->GetSeqNum($id) + 1;
	if ($_SESSION['servertype'] == 'imap' || $_SESSION['servertype'] == "imapssl") {
		$nextmsgid = $IMAPConnection->GetUID($nextmsgid);
	}
	$nextprev .= "<a href=\"view.php?id=" . $nextmsgid . "&amp;f=" . $folderencode . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['SView']['NextMess'] . "</a>";
}
else {
	$nextprev .= $lang['SView']['NextMess'];
}


// Find any embedded images and replace their ID in the body of the message so we can view them
if (is_array($embeddedattachments)) {
	if ($_SERVER['HTTPS'] == "on") {
		$currprot = 'https://';
	}
	else {
		$currprot = 'http://';
	}
	for($x=0; $x<sizeof($embeddedattachments); $x++) {
		// Note this calls the same file as attachment download but we must set submit=inline to allow display rather than download
		if ($embeddedattachments[$x]["id"] <> '') {
			$content = str_replace("cid:" . $embeddedattachments[$x]["id"], $currprot . $_SERVER['HTTP_HOST'] . str_replace("view.php", "attachment.php?submit=inline&amp;id=$id&amp;pid=" . $embeddedattachments[$x]["pid"]  . "&amp;f=" . $folderencode . "&amp;" . strip_tags(SID), $_SERVER['PHP_SELF']), $content);
			$embeddedattachments[$x]["displayinline"] = 0;
		}
		else {
			$embeddedattachments[$x]["displayinline"] = 1;
		}
	}
}

// Save from address to addressbook button
if ($UseDatabase == 1) {
	$from_array  = imap_rfc822_parse_adrlist($headerdetails['fromaddress'], 'localhost');
	if (($from_array[0]->mailbox <> "") && ($from_array[0]->host <> "") && ($from_array[0]->host <> "localhost")) {
		$urlenc_from_name = urlencode($from_array[0]->personal);
		$urlenc_from_email = urlencode($from_array[0]->mailbox) . "@" . urlencode($from_array[0]->host);
		$PageView = str_replace("[ifcontacts]", "", $PageView);
		$PageView = str_replace("[/ifcontacts]", "", $PageView);
	}
	else {
		$PageView = preg_replace("/(\[)(ifcontacts)(])(\r\n)*(.*)(\[\/ifcontacts\])/siU", "", $PageView);
	}
}
else {
	$savelink = "";
	$PageView = preg_replace("/(\[)(ifcontacts)(])(\r\n)*(.*)(\[\/ifcontacts\])/siU", "", $PageView);
}
if ($AutoPreview == 1 && is_array($attachments)) {
	$autopreviewimage = $getFile->fileRead('viewpreviewimage');
	for($x=0; $x<sizeof($attachments); $x++) {
		if ($attachments[$x]["type"] == "image/jpeg" || $attachments[$x]["type"] == "image/pjpeg" || $attachments[$x]["type"] == "image/gif" || $attachments[$x]["type"] == "image/png") {
			$imagetmp = $autopreviewimage;
			$imagetmp = str_replace("[preview_image]", "attachment.php?submit=inline&amp;id=$id&amp;pid=" . $attachments[$x]["pid"] . "&amp;f=" . $folderencode . "&amp;" . strip_tags(SID), $imagetmp);
			$imagetmp = str_replace("[preview_filename]", str_replace('"', "&quot;", $attachments[$x]["name"]), $imagetmp);
			$imagepreviews .= $imagetmp;
		}
	}
	if ($imagepreviews <> "") {
		$autopreviewimages = $getFile->fileRead('viewautopreview');
		$autopreviewimages = str_replace("[preview_images]", $imagepreviews, $autopreviewimages);
		$autopreviewimages = str_replace("[current_querystring]", "?" . $_SERVER["QUERY_STRING"], $autopreviewimages);
	}
	else {
		$autopreviewimages = "";
	}
}
elseif ($AutoPreview == 1 && is_array($embeddedattachments)) {
	for($x=0; $x<sizeof($embeddedattachments); $x++) {
		if (($embeddedattachments[$x]["type"] == "image/jpeg" || $embeddedattachments[$x]["type"] == "image/pjpeg" || $embeddedattachments[$x]["type"] == "image/gif" || $embeddedattachments[$x]["type"] == "image/png") && $embeddedattachments[$x]["displayinline"] == 1) {
			$imagetmp = $getFile->fileRead('viewpreviewimage');
			$imagetmp = str_replace("[preview_image]", "attachment.php?submit=inline&amp;id=$id&amp;pid=" . $embeddedattachments[$x]["pid"] . "&amp;f=" . $folderencode . "&amp;" . strip_tags(SID), $imagetmp);
			$imagetmp = str_replace("[preview_filename]", str_replace('"', "&quot;", $embeddedattachments[$x]["name"]), $imagetmp);
			$imagepreviews .= $imagetmp;
		}
	}
	if ($imagepreviews <> "") {
		$autopreviewimages = $getFile->fileRead('viewautopreview');
		$autopreviewimages = str_replace("[preview_images]", $imagepreviews, $autopreviewimages);
		$autopreviewimages = str_replace("[current_querystring]", "?" . $_SERVER["QUERY_STRING"], $autopreviewimages);
	}
	else {
		$autopreviewimages = "";
	}
}
else {
	$autopreviewimages = "";
}

if ($headerdetails['ccaddress'] == '') {
	$PageView = preg_replace("/(\[)(ifcc)(])(\r\n)*(.*)(\[\/ifcc\])/siU", "", $PageView);
}
else {
	$PageView = str_replace('[ifcc]', '', $PageView);
	$PageView = str_replace('[/ifcc]', '', $PageView);
}

if ($headerdetails['bccaddress'] == '') {
	$PageView = preg_replace("/(\[)(ifbcc)(])(\r\n)*(.*)(\[\/ifbcc\])/siU", "", $PageView);
}
else {
	$PageView = str_replace('[ifbcc]', '', $PageView);
	$PageView = str_replace('[/ifbcc]', '', $PageView);
}

$PageView = preg_replace("/(\[)(ifappointment)(])(\r\n)*(.*)(\[\/ifappointment\])/siU", "", $PageView);

$allowzip = 0;
if (function_exists('gzcompress')) {
	$allowzip = 1;
}

if ($allowzip == 1) {
	$PageView = str_replace("[ifzip]", "", $PageView);
	$PageView = str_replace("[/ifzip]", "", $PageView);
}
else {
	$PageView = preg_replace("/(\[)(ifzip)(])(\r\n)*(.*)(\[\/ifzip\])/siU", "", $PageView);
}

$localtime_date = DateToLocal($tz, $headerdetails['date'], $DateFormattingFull);

if ($charset == "") {
	$charset = $_SESSION['DefaultCharSet'];
}

if (isset($headerdetails['senderaddress']) && $headerdetails['senderaddress'] <> $headerdetails['fromaddress']) {
	$view_from = parseLinks(htmlspecialchars($headerdetails['senderaddress']), 1, 1) . ' ' . $lang['SView']['Sender'] . ' ' . parseLinks(htmlspecialchars($headerdetails['fromaddress']), 1, 1);
}
else {
	$view_from = parseLinks(htmlspecialchars($headerdetails['fromaddress']), 1, 1);
}

$CodeSearch = array (
	"[view_from]",
	"[view_to]",
	"[view_cc]",
	"[view_bcc]",
	"[view_subject]",
	"[view_date]",
	"[view_messagedate]",
	"[view_attachments]",
	"[view_body]",
	"[nextprev]",
	"[view_menu]",
	"[view_folder]",
	"[view_styleformat]",
	"[session_form]",
	"[session_append]",
	"[session_force]",
	"[session]",
	"[imap_move]",
	"[view_fromname_urlencoded]",
	"[view_fromemail_urlencoded]",
	"[view_autopreview]",
	"[view_id]",
	"[view_partid]",
	"[view]",
	"[view_charset]"
);

$CodeReplace = array (
	$view_from,
	parseLinks(htmlspecialchars($headerdetails['toaddress']), 1, 1),
	parseLinks(htmlspecialchars($headerdetails['ccaddress']), 1, 1),
	parseLinks(htmlspecialchars($headerdetails['bccaddress']), 1, 1),
	$subj,
	$localtime_date,
	$headerdetails['date'],
	$attachmentdetails,
	$content,
	$nextprev,
	$PageViewMenu,
	urlencode($_SESSION['folder']),
	$view_styleformat,
	$MainSettings->SessAppend_form($TransIDEnabled),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 0),
	"&amp;" . strip_tags(SID),
	$MainSettings->SessAppend_noecho($TransIDEnabled, 1),
	$movemessage,
	$urlenc_from_name,
	$urlenc_from_email,
	$autopreviewimages,
	$id,
	$pid,
	'view',
	$charset
);

// If we detect the message in a characterset OTHER than the default character set we are going to output the
// HTTP content-type header in the character set of the message.  This MAY cause template issues if the template uses
// characters unknown to that character set.  If this is a regular occurance we recommend setting message viewing
// to new windows
// However if you really don't like this feature, simply remove it and leave the LAST header() function in place
if ($charset <> $_SESSION['DefaultCharSet']) {
	header ("Content-Type: text/html; charset=" . $charset);
}
else {
	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
}

echo $PageHeader;

$PageView = str_replace ($CodeSearch, $CodeReplace, $PageView);
$PageView = LangReplace('SView', $PageView, $lang);
echo $PageView;

$IMAPConnection->WM_IMAPClose();

// Read Receipt popup code
if (($AllowReadReceipts == 1) && ($ask_receipt == 1) && ($rr <> 1)) {
	echo $receiptjs;
}
if ($rr == 1 && $AllowReadReceipts == 1) {
	if (($DWmailMode == 1) && ($UseSMTP == 1)) {
		require ("./includes/smtp.inc.php");
		$SMTPConnection = new WM_SMTPConnection($_SESSION);
		$SMTPConnection->_helodomain = $HELOServerName;
		$smtpconnect = $SMTPConnection->WM_SMTPConnect($DefaultSMTP);
		if (!$smtpconnect) {
			$smtperror[] = "Failed to connect to SMTP server";
		}
		$smtphelo = $SMTPConnection->WM_HELO();
		if (!$smtphelo) {
			$smtperror[] = "HELO to SMTP server failed";
		}
		if ($UseSMTPAuth == 1) {
			$smtpauth = $SMTPConnection->WM_SMTPAuth();
			if (!$smtpauth) {
				$smtperror[] = "Authentication to SMTP server failed";
			}
		}
		$smtpfrom = $SMTPConnection->WM_EnvelopeFROM($_SESSION['currentemailaddress']);
		if (!$smtpfrom) {
			$smtperror[] = "Could not set from address";
		}
		$to_array  = imap_rfc822_parse_adrlist($notemail, "localhost");
		if (is_array($to_array)) {
		while(list($key,$val) = each($to_array)){
			if ($val->mailbox <> "" && $val->host <> "") {
				$smtpto = $SMTPConnection->WM_EnvelopeTO($val->mailbox . "@" . $val->host);
				if (!$smtpto) {
					$smtperror[] = "Could not set to address";
				}
			}
		}
		}
		// Build the email first
		$sendemail = $IMAPConnection->WM_IMAPSendReceipt($notemail, $headerdetails['messageid'], $subj, $_SESSION['currentemailaddress'], 1, $headerdetails['date']);
	
		// Make sure all new lines are \n and then force all \n to \r\n
		// to strip and bare line feeds (as SMTP will not allow this)
		$sendemail['header'] = str_replace ("\r\n", "\n", $sendemail['header']);
		$sendemail['header'] = str_replace ("\n", "\r\n", $sendemail['header']);

		$sendemail['message'] = str_replace ("\r\n", "\n", $sendemail['message']);
		$sendemail['message'] = str_replace ("\n", "\r\n", $sendemail['message']);

		$emailsent = $SMTPConnection->WM_Data($sendemail['header'] . $sendemail['message']);
		if (!$emailsent) {
			$smtperror[] = "Could not send data";
			$emailsent = $smtperror;
		}

		$smtpclose = $SMTPConnection->WM_SMTPClose();

	}
	else {
		// Build the email first
		$sendemail = $IMAPConnection->WM_IMAPSendReceipt($notemail, $headerdetails['messageid'], $subj, $_SESSION['currentemailaddress'], 0, $headerdetails['date']);

		// This bit actually calls the sendmail routine
		$emailsent = $IMAPConnection->WM_IMAPSendMail($sendemail);
	}

}
echo $PageFooter;
?>