<?php
/*
       *  Script: JDC (Java Download Center)
       *  Avtor: Окулов Роман Вячеславович (J-mix) 
       *  Version: 1.1 alpha
       *  ICQ: 353332275
       *  E-mail: J-mix@list.ru
       *  Site: http://Jsf.pp.ua
       *  Copyright: Copyright (c) 2010, Roman Okulov (aka J-mix)
       *  License: GNU GENERAL PUBLIC LICENSE
       * About: Главный системный файл пользовательской части
       */
     define ('_IN_JOHNCMS', 1);
    $headmod = 'load';
    require_once ('../incfiles/core.php');  //  Подключаем ядро движка
/*

        * Основный функций для пользовательской части

 */
    function cnt_files ($id = 0, $refdir = '', $type = 'count', $time = 3600)
/*

        * Функция кэширование счетчиков к файлам

*/
     {
    global $db, $set_load, $realtime, $rootpath;
    if (!is_file ($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache'))
  {
    if ($type == 'count')
    $total = count_files ($id, $refdir);
    elseif ($type == 'new')
    $total = new_files ($id, $refdir);
    elseif ($type == 'top') 
    $total = top_cnt ();
    elseif ($type == 'vendor')
    $total = vendor_cnt ($id);
    elseif ($type == '3D')
    $total = cnt_3D ($id, $refdir); 
    elseif ($type == 'BT')
    $total = BT_cnt ($id, $refdir);
     elseif ($type == 'screen')
    $total = screen_cnt ($id);
     else
    $total = 'Error: Count files';
    $cache = fopen ($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache', 'w');
    fputs($cache, $total);
    fclose ($cache);
    chmod ($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache', 0666);
    } elseif (is_file ($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache') && $realtime >= (filemtime($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache') + $time))
  {  
    unlink ($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache');
    if ($type == 'count')
    $total = count_files ($id, $refdir);
    elseif ($type == 'new')
    $total = new_files ($id, $refdir);
    elseif ($type == 'top') 
    $total = top_cnt ();
    elseif ($type == 'vendor')
    $total = vendor_cnt($id); 
    elseif ($type == '3D')
    $total = cnt_3D ($id, $refdir); 
    elseif ($type == 'BT')
    $total = BT_cnt ($id, $refdir);
     elseif ($type == 'screen')
    $total = screen_cnt ($id);
     else
    $total = 'Error: Count files';
    $cache = fopen ($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache', 'w');
    fputs ($cache, $total);
    fclose ($cache);
    chmod ($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache', 0666);
  }
    $total = file_get_contents ($rootpath . $set_load['system']['dir_loads']. '/temp/cnt_' .$id. '_' .$type. '.cache');
    return $total;
  }
    function new_files ($id, $refdir = '')
/*

        * Функция подсчета только новых файлов

*/
    {
    global $db, $set_load, $realtime;
    if ($id == 0)
  {
    $total = $db->result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `time_update` > '" .($realtime - $set_load['default']['time_new'] * 60 * 60). "'
  AND `type` = 'files';");
    } else {
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `refdir` LIKE '" .($refdir) . "%'
  AND `time_update` > '" .($realtime - $set_load['default']['time_new'] * 60 * 60). "'
  AND `type` = 'files';");
  }
    return $total;
  }
    function count_files ($id, $refdir = '')
/*

        * Функция подсчета общего кол-во файлов

*/
    {
    global $db, $set_load;
    if ($id == 0)
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `type` = 'files';");
     else 
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `refdir` LIKE '" .($refdir) . "%'
  AND `type` = 'files';");
    return $total;
  }
    function top_cnt ()
/*

        * Функция подсчитывает кол-во файлов участвующих в топе файлов

*/
    {
    global $db, $set_load;
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `cnt_load` > '" .$set_load['default']['top_cnt']. "'
  AND `type` = 'files';");
    return $total;
    }
    function vendor_cnt ($vendor)
    {
    global $db;
    if ($vendor != 0)
    $total = $db -> result ("SELECT DISTINCT COUNT(`vendor`) FROM `" .prefix. "_loads`
  WHERE `vendor` LIKE '%$vendor%'
  AND `type` = 'files';");
    else
    $total = $db -> result ("SELECT DISTINCT COUNT(`vendor`) FROM `" .prefix. "_loads`
  WHERE `vendor` != ''
  AND `type` = 'files';");
    return $total;
    }
    function cnt_3D ($id, $refdir)
/*

        * Функция подсчета файлов в 3D категорий

*/
    {
    global $db, $set_load;
    if ($id == 0)
  {
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `3D` = 'yes'
  AND `type` = 'files';");
    } elseif ($id > 0)
  {
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `type` = 'files'
  AND `refdir` LIKE '" .($refdir) . "%' 
  AND `3D` = 'yes';");
}
    return $total;
 }
    function BT_cnt ($id, $refdir)
/*

        * Функция подсчета файлов в Bluetooth категорий

*/
    {
    global $db, $set_load;
    if ($id == 0)
  {
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `BT` = 'yes'
  AND `type` = 'files';");
    } elseif ($id > 0)
  {
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `type` = 'files'
  AND `refdir` LIKE '" .($refdir) . "%' 
  AND `BT` = 'yes';");
    
}
    return $total;
    }
    function screen_cnt ($id)
/*

        * Функция подсчета скриншотов

*/
    {
    global $db;
    if ($id == 0)
  {
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads_screen`;");
    } elseif ($id > 0)
  {
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads_screen`
  WHERE `refid` = '$id';");
    
}
    return $total;
    }
    function img_resize ($file = '', $save = '', $w = '', $h = '', $mark = '1')
/*

        * Функция изменение размера изображение

*/
  {
    if (!is_writable (dirname ($save)))
    return false;
    list ($wn, $hn, $type) = getimagesize ($file);
    $sxy = round ($wn / $hn, 3);
    if ($sxy < 1)
    $w = intval ($h * $sxy);
    else
    $h = intval ($w / $sxy);
    switch ($type)
  {
    case 1:
    //  Если GIF формат
    $old = imageCreateFromGif ($file);
    break;
    case 2:
    // Если JPEG формат
    $old = imageCreateFromJpeg ($file);
    break;
    case 3:
        // Если PNG формат
    $old = imageCreateFromPNG ($file);
    break;
    default:
    return false;
    break;
  }
    $new = imageCreateTrueColor ($w, $h);
    imageCopyResampled ($new, $old, 0, 0, 0, 0, $w, $h, $wn, $hn);
    if ($mark)
    $new = mark ($new);
    imageGif ($new, $save);
    imagedestroy ($old);
    imageDestroy ($new);
  }
    function mark ($files = '')
/*

        * Функция маркеровки изображение

*/
      {
    $copy = imagecreatefrompng ('images/copy.png');
    if (!is_resource ($files) || !is_resource ($copy))
    return;
    $imageWidth = imagesx ($files);
    $imageHeight = imagesy ($files);
    $copy_Width = imagesx ($copy);
    $copy_Height = imagesy ($copy);
    $new = imagecreatetruecolor ($imageWidth, $imageHeight);
    for ($j = 0; $j < $imageHeight; $j++)
  {
    for ($i = 0; $i < $imageWidth; $i++)
  {
    $rgb = imagecolorsforindex ($files, imagecolorat ($files, $i, $j));
    if ($j < $copy_Height && $i < $copy_Width)
  {
    $rgb2 = imagecolorsforindex ($copy, imagecolorat ($copy, $i, $j));
    if ($rgb2['alpha'] != 127)
  {
    $rgb['red'] = intval (($rgb['red'] + $rgb2['red']) / 2);
    $rgb['green'] = intval (($rgb['green'] + $rgb2['green']) / 2);
    $rgb['blue'] = intval (($rgb['blue'] + $rgb2['blue']) / 2);
    }
  }
    $ind = imagecolorexact ($new, $rgb['red'], $rgb['green'], $rgb['blue']);
    if ($ind < 1)
  {
    $ind = imagecolorallocate ($new, $rgb['red'], $rgb['green'], $rgb['blue']);
    if ($ind < 1)
  {
    $ind = imagecolorclosest ($new, $rgb['red'], $rgb['green'], $rgb['blue']);
    }
  }
    imagesetpixel ($new, $i, $j, $ind);
      }
   }
    return $new;
 }
    function meta_key ($str)
/*

        * Функция генираций ключивых слов для мета-тегов из описание файла.
        * За основу взята функция от Кrite

*/
   {
    $quote = array (
  '\x60', 
  '\x22',
  '\n',
  '\t',
  '"',
  '\r',
  '\\',
  "\r",
  "\n",
  "\t",
  '-',
  '{',
  '}',
  '[',
  ']');
    $str1 = str_replace ($quote, " ", $str);
    $str2 = preg_replace ("/[^\w\x7F-\xFF\s]/", " ", $str1);
    $str = preg_replace ("/ {,1}/", " ", $str2);
    $arr = @explode (" ", $str);
    foreach ($arr as $word)
  {
    if (mb_strlen ($word, 'UTF-8') > 4)
  $newarr[] = $word;
}
    $arr = @array_count_values ( $newarr );
    @arsort ($arr);
    $arr = @array_keys ($arr);
    $total = count ($arr);
    $arr = @array_slice ($arr, 0, 15);
  $r = ', ';
    $mkey= @implode ($r, $arr);
    return $mkey;
  }
    function copy_load ($body)
/*

        * Функция копирайта
        * Убирать / Изменять категорический запрещается
*/
        {
    $copy = str_replace ('</div></body></html>',
  '</div><div style="text-align:center">
  © Coding by <a href="http://jsf.pp.ua">J-mix</a>.
  </div></body></html>',
  $body);
    return $copy;
  }
    $lng_jdc = parse_ini_file ('setting/language/ru.ini');
    ob_start ('copy_load');    if ($user_id)
    $time_user = ($realtime + $set_user['sdvig'] * 3600);  //  Определяем время юзера
    $i = 0;
/*

        * Загрузка настроек системы

*/
    $set_base = opendir ('setting') or die ('Error: Loading settings');
    while ($file = readdir ($set_base))
    {
    if (is_file ('setting/'.$file) && preg_match ('#\.ini$#i', $file))
  {
   $arr_name = strtok ($file, '.');
    $set_load[$arr_name] = parse_ini_file ('setting/' .$file) or die ('Erorr: Loading settings files "' .$arr_name. '"');
    }
 }
    closedir ($set_base);
/*

        * Создание констактов

*/
    define ('prefix', $set_load['core']['prefix']);
    define ('ADMDIR', $set_load['system']['adm_dir']);
    $error = false;  //  Создание переменой ошибок
/*

        * Проверка статуса загруз-центра

*/
    if ($set_load['access']['Statys'] == 'close' && $rights <= 6)
    $error = $lаng['statys_close'];
    elseif ($set_load['access']['Statys'] == 'close_guest' && !$user_id)
    $error = $lng_jdc['statys_close_guest'];
    if ($error)
/*

        * Вывод ошибок
        * Если они есть :)

*/
  {
    require_once ('../incfiles/head.php');
    echo ( '<div class="rmenu">' . $error . '</div>' );
    require_once ("../incfiles/end.php");
   exit();
  }
/*

        * Удаление усторевших файлов,
       * из папки temp/

*/
    $dir = opendir ('temp') or die ('Error: No access cache');
    while ($file = readdir ($dir))
    {
    if (is_file ('temp/'.$file) && $realtime > (filemtime ('temp/' .$file) + ($set_load['system']['delete_cache']  * 3600)) && $file != "." && $file != ".." && $file != ".htaccess")
    unlink ("temp/$file");   
  }
    closedir ($dir);
/*

        * Проверка наличия таблиц.
        * Если их нет то останавливаем работу скрипта и,
        * выводим сообщение об ошибки.

*/
    require_once ('class/mysql.class.php');
    $db = new MySQL ();
    $db -> errors = true;
  //  $db -> connect ();
    $db -> query ("SELECT * FROM `" .prefix. "_loads`;") or die ('Error: No tables MySQL base');
    switch ($act) 
/*

        * Главная страница

*/
  {
    default:
    if (empty ($id))
/*

       * Если нет индификатора раздела
        * Выводим корнивую папку

*/
  {
    $textl = 'JAVA Downloads-Center';
    $id = 0;
    } else {
    if ($db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `id` = '$id'
  AND `type` = 'dir' LIMIT 1;") == 0)  //  Провера существование раздела
  {
    header ("Location: index.html?");
    exit ();
  }
    $textl = $db -> result ("SELECT `name` FROM `" .prefix. "_loads`
  WHERE `type` = 'dir'
  AND `id` = '$id' LIMIT 1;");  //  Получение имени раздела
  }
    if (isset ($_GET['sort']) && $id != 0)
/*

        * Модуль сортировки файлов

*/
  {
    $sort = isset ($_GET['sort']) ? check ($_GET['sort']) : 'false';
   $_SESSION['sort'] = $sort; //Создание сесий
  } elseif (isset ($_SESSION['sort']))
    $sort = isset ($_SESSION['sort']) ? trim ($_SESSION['sort']) : 'false';
  else 
    $sort = 'time';
     $arr = array (
  'time',
  'load',
  'vote',
  'imya');  // Проверка сортировки от умников
     $ext = array (
  'time' => 'time_update',
  'load' => 'cnt_load',
  'vote' => 'plus',
  'imya' => 'name');
    if (in_array ($sort, $arr))  //  Сверка с массивом
    $sort_sql = $ext[$sort];
  else
      $sort_sql = 'time_update';//Задаем сортировку по умолчанию
    $headmod = 'load';
    require_once ('../incfiles/head.php');
    echo ( '<div class="phdr">' .$textl. '</div>' );
/*

        * Выводим тело страницы

*/
    if ($id != 0)  //  Если не корнивая папка
  //  то выводим блок сортировки
  {
    echo ( '<div class="topmenu"><b>' .$lng_jdc['sort']. ':</b><br />' );
    echo  ($sort == 'time' ? '<b>' .$lng_jdc['sort_time']. '</b>|' : '<a href="?sort=time">' .$lng_jdc['sort_time']. '</a>|');
    echo  ($sort == 'vote' ? '<b>' .$lng_jdc['sort_vote']. '</b>|' : '<a href="?sort=vote">' .$lng_jdc['sort_vote']. '</a>|');
    echo  ($sort == 'load' ? '<b>' .$lng_jdc['sort_load']. '</b>|' : '<a href="?sort=load">' .$lng_jdc['sort_load']. '</a>|');
    echo  ($sort == 'imya' ? '<b>' .$lng_jdc['sort_name']. '</b>|' : '<a href="?sort=imya">' .$lng_jdc['sort_name']. '</a>|');
    echo ( '</div>' );
  }
    if ($set_load['access']['3D_Statys'] == 'open' && $id == 0)
/*

        * Вывод 3D Категорий
        * Если она включена

*/
  {
    $icon = (file_exists ($set_load['default']['3D_icon']) ? trim ($set_load['default']['3D_icon']) : 'images/cat/3d.png');  // Проверяем иконку на существование
    echo ( '<div class="list1"><img src="'.$icon. '" width="14" height="14" alt="3d_java"/>&nbsp;<a href="3d_java.html">' .$set_load['default']['3D_Name']. '</a> [' .cnt_files (0, '', '3D'). ']</div>');
  }
    if ($set_load['access']['BT_Statys'] == 'open' && $id == 0)
/*

        * Выводим Bluetooth категорию
        * Если она включена

*/
  {
    $icon = (file_exists ($set_load['default']['BT_icon']) ? trim ($set_load['default']['BT_icon']) : 'images/cat/bt.png');  //  Проверяем иконку на существование на сервере
    echo ( '<div class="list2"><img src="'.$icon. '" width="14" height="14" alt="BT_java"/>&nbsp;<a href="bt_java.html">' .$set_load['default']['BT_Name']. '</a> [' .cnt_files (0, '', 'BT'). ']</div>');
  }
    $total = $db -> result ("SELECT COUNT(*) FROM `" .prefix. "_loads`
  WHERE `refid` = '$id' ;" );  // Считаем кол-во файлов и папок
    if ($total == 0)
  // Если нет файлов сообщаем об этом пользователю
    echo ( '<div class="gmenu">' .$lng_jdc['no_files']. '</div>' );
    else { 
 $query = $db -> query ("SELECT * FROM `" .prefix. "_loads`
  WHERE `refid` = '$id'
  ORDER BY `type` ASC, `" .$sort_sql. "` DESC LIMIT " .$start. ", " .$kmess. ";");
    while ($row = $db -> fetch_array ($query))
/*

        * Выводим список файлов

*/
    { 
    echo is_integer ($i / 2) ? ( '<div class="list2">' ) : ( '<div class="list1">' );
    if ($row['type'] == 'dir')
  // Выводим список папок
  {
    $cnt = cnt_files ($row['id'], $row['refdir'], 'count');  //  Считаем кол-во файлов в категорий
    $cnt_new = cnt_files ($row['id'], $row['refdir'], 'new');//  Считаем кол-во новых файлов в папке
    $icon = (file_exists ($row['icon']) ? trim ($row['icon']) : 'images/dir.png'); // Проверка иконки
    if ($cnt_new != 0)
  // Если есть новый файлы то добавляем их в основной счетчик
    $cnt .= '/<span style="color:red">+' .$cnt_new. '</span>';
    echo ( '<img src="' .$icon. '" width="14" height="14" alt="dir"/>&#160;<a href="cat_' .$row['id']. '.html">' .$row['name']. '</a> [' .$cnt. ']' );
    if ($rights == 4 || $rights >= 6)
/*

        * Выводим сылки для управление разделами

*/
  {
    echo ( '<div class="func">' );
    echo ('<a href="' .ADMDIR. '/delete_cat_' .$row['id']. '.html">' .$lng_jdc['delete']. '</a>/<a href="' .ADMDIR. '/edit_cat_' .$row['id']. '.html">' .$lng_jdc['edit']. '</a></div>');
     }
  } elseif ($row['type'] == 'files')
/*

        * Выводим файлы

*/
  { 
    $time = ($row['time_update'] + $set_user['sdvig'] * 3600);
    echo ( '<table cellpadding="0" cellspacing="0"><tr><td><img src="icon_' .$row['id']. '.gif" width="48" height="48"  alt="file"/></td><td>' );
    echo ( '&#160;<a href="files_' .$row['id']. '-' .urlencode ($row['name']). '.html">' .$row['name']. '</a> [' .date ("d.m /H:i", $time). '] ');
    if ($row['time_update'] >= ($realtime - $set_load['default']['time_new'] * 60 * 60))
    echo ( '&#160;<span style="color:red">new!</span>' );
    echo ( $lng_jdc['loads']. ': ' .$row['cnt_load']. '</td></tr></table>');
    $desc = mb_substr ($row['desc'], 0, $set_load['default']['Limit_Desc']);
    $desc .= '...';
    echo (functions::checkout($desc, 0, 2));
    if ($rights == 4 || $rights >= 6)
/*

        * Выводим сылки для управление файлами

*/
  {
    echo ( '<div class="func">' );
    echo ('<a href="' .ADMDIR. '/delete_files_' .$row['id']. '.html">' .$lng_jdc['delete']. '</a>/<a href="' .ADMDIR. '/add_copy_files_' .$row['id']. '.html">' .$lng_jdc['new_load_files']. '</a>/<a href="' .ADMDIR. '/files_' .$row['id']. '.html">' .$lng_jdc['edit']. '</a></div>');
     }
  }
    echo ( '</div>' );
  ++$i;
    }
    if ($total > $kmess && $id == 0)  // Выводим постраничную навигацию для корневого раздела
    echo 
(functions::display_pagination ('index.html?sort=' .$sort. '&amp;', $start, $total, $kmess));
    if ($total > $kmess && $id != 0)  // Выводим постраничную навигацию для остальных папок
    echo 
(functions::display_pagination ('cat_' .$id. '.html?sort=' .$sort. '&amp;', $start, $total, $kmess));
 }
    if ($rights == 4 || $rights >= 6 && $id != 0)
/*

        * Выводим сыллки для админа

*/
  {
    echo ( '<div class="menu">
  <a href="' .ADMDIR. '/copy_files_' .$id. '.html">' .$lng_jdc['copy_files']. '</a>
<br />
  <a href="' .ADMDIR. '/upload_files_' .$id. '.html">' .$lng_jdc['upload_files']. '</a>
<br />
  <a href="' .ADMDIR. '/edit_cat_' .$id. '.html">' .$lng_jdc['edit_cat']. '</a>
<br />
  <a href="' .ADMDIR. '/delete_cat_' .$id. '.html">' .$lng_jdc['delete_cat']. '</a>
</div>' );
  }
  //  Выводим список доп модулей
if ($set_load['access']['Top_files_statys'] == 'close' && $set_load['access']['New_files_statys'] == 'close' && $set_load['access']['Search_files_statys'] == 'close' && $set_load['access']['Statistik_statys'] == 'close' && $set_load['access']['Vendor_statys'] == 'close')
  // Если все модули закрыты то скрываем все вмести с дивом
    echo ( '<!--no modules-->' );
    else {
    echo ( '<div class="gmenu">' );
    if ($set_load['access']['Top_files_statys'] == 'open' && $id == 0)  // Вывод модоля: Топа файлов
  echo ( '<img src="images/top.png" width="14" height="14" alt="top_files" />&#160;<a href="top_files.html">' .$lng_jdc['top_files']. '</a> [' .cnt_files ('', '', 'top'). ']<br />' );
    if ($set_load['access']['New_files_statys'] == 'open' && $id == 0)  // Вывод модуля: Новых файлов
    echo ( '<img src="images/new.png" width="14" height="14" alt="new_files"/>&#160;<a 
href="new_files.html">' .$lng_jdc['new_files']. '</a>&#160;[' .cnt_files (0, '', "new"). ']<br />' );
    if ($set_load['access']['Search_files_statys'] == 'open' && $id == 0)  // Вывод модуля: Пойска файлов
    echo ( '<img src="images/search.png" width="14" height="14" alt="search"/>&#160;<a href="search.html">' .$lng_jdc['search_files']. '</a>&#160;[' .cnt_files (0, '', 'count'). ']<br />' );
    if ($set_load['access']['Statistik_statys'] == 'open' && $id == 0) // Вывод модуля: статистики
    echo ( '<img src="images/stat.png" width="14" height="14" alt="stat"/>&#160;<a href="statistik.html">' .$lng_jdc['stat']. '</a><br />' );
    if ($id == 0)
    echo ( '<img src="images/pact.gif" width="14" height="14" alt="stat"/>&#160;<a href="pact.html">Соглашение</a><br />' );
    if ($set_load['access']['Vendor_statys'] == 'open' && $id == 0) // Вывод модуля: Пройзводители
    echo ( '<img src="images/vendor.png" width="14" height="14" alt="vendor"/>&#160;<a href="vendor.html">' .$lng_jdc['vendors']. '</a>&#160;[' .cnt_files(0, '', 'vendor'). ']');
  echo ( '</div>' );
  }
    break;
/*

        * Дальше идет подключение
        * дополнительных модулей
        * из папки moduls/

*/
    case 'modules':
    $modul = isset ($_REQUEST['modul']) ? trim ($_REQUEST['modul']) : 'err';
/*

        * Проверям модули на существование
        * и защищаемся от php inj

*/
    if (!preg_match ('#^([A-z0-9_\-\.])+$#', $modul))
exit ('Error: Sintax modules');
  $arr = array (
  'album_screen',
  'download',
  'files',
  'images',
  'search',
  'top_files',
  'new_files',
  '3d_java',
  'bt_java',
  'icon',
  'vendor',
  'err',
  'statistik',
  'pact');  // Массив разрешеных файлов для подключение
    if (in_array ($modul, $arr) && file_exists ('moduls/' .$modul. '.case'))  // Сверяемся с массивом и проверяем модуль на существование
   require_once ('moduls/' .$modul. '.case');  // Подключение модуля
    else
    header ("Location: err.html?");
    break;
 }
    if ($rights == 4 || $rights >= 6)
  //  Выводим  сылки админам
   {
echo ( '<div class="phdr"><a href="' .ADMDIR. '">' .$lng_jdc['adm_panel']. '</a></div>' );
   }
    require_once ('../incfiles/end.php');
?>