/*
 * Decompiled with CFR 0.152.
 */
package br;

import br.BookReader;
import br.Formatter;
import br.Text;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;

public class ReadCanvas
extends Canvas
implements Runnable,
CommandListener {
    Text myText = new Text();
    int myLastClickX = 0;
    int myLastClickY = 0;
    Display display;
    Thread myAutoScrollThread = null;
    private long myLastPaintTime = 0L;
    private boolean myAutoScrollAllowed = false;
    String myTextLabel = null;
    boolean myBkLightState = true;
    Image myNormalFontImage = null;
    Image myCwRotatedFontImage = null;
    Font myDisplayFont = null;
    Formatter myFormatter;
    int myNextPageStart = 0;
    int myNextLineStart = 0;
    boolean mySpareLineOnScroll = false;
    private char[] myTextMenuItems;
    public static final int TEXT = 0;
    public static final int AUTOSCROLL = 1;
    public static final int OPTIONSMENU = 2;
    public static final int SHOWNEXTBOOK = 3;
    int myDisplayMode = 0;
    int myAutoScrollDelayMs = 0;
    int AUTOSCROLL_MAX_MS = 20000;
    public final String HELP_MESSAGE = "Book Reader by Alex Vdovichenko aka tequilaCat\nDIAL-read /options\n*-backlight\n#-rotate\n2/4/6/8/ Arrows- scroll\n1-Home,7-End\n3,9-Autoscroll" + (this.hasPointerEvents() ? "\nClick upper/lower screen half: scroll up/down\nDrag up/left - toggle orientation" : "");
    public static int INC_HEIGHT = 0;
    public static int BGCOLOR = 0xFFFFFF;
    public static int FGCOLOR = 0;
    public static boolean HAS_DIR_BUTTONS = false;
    public Alert myMessageBox = new Alert("Book Reader", "", null, AlertType.INFO);
    TextBox myInputBox = new TextBox("", "", 50, 0);
    Image myDblBufImage = null;
    int myScrWidth;
    int myScrHeight;
    int myPosition;
    String mySearchPattern = "";
    int myInputMode = 0;
    private static final int SEARCH = 1;
    private static final int GOTOPERCENT = 2;

    public ReadCanvas(Display display) {
        this.display = display;
        this.myTextMenuItems = BookReader.instance.readChars("/menu.txt");
        this.myInputBox.addCommand(BookReader.CMD_OK);
        this.myInputBox.addCommand(BookReader.CMD_CANCEL);
        this.myScrWidth = this.getWidth();
        this.myScrHeight = this.getHeight() + INC_HEIGHT;
        try {
            this.myNormalFontImage = Image.createImage((String)"/font.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myCwRotatedFontImage = Image.createImage((String)"/font-lscp.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.isDoubleBuffered()) {
            this.myDblBufImage = Image.createImage((int)this.myScrWidth, (int)this.myScrHeight);
        }
        this.myFormatter = new Formatter(this.myText, this.myScrWidth > this.myScrHeight ? this.myScrWidth : this.myScrHeight);
        this.myFormatter.UnicodeConversionTable = BookReader.TEXT_ENCODING;
        this.mySpareLineOnScroll = "true".equals(BookReader.getProperty("main", "spareline"));
        BookReader.MENU.setMenu(this.myScrWidth, this.myScrHeight, this.myTextMenuItems, 0);
    }

    public void setText(String string, String string2) {
        this.myText.init(string);
        this.myTextLabel = string2;
        this.myAutoScrollAllowed = false;
        this.myDisplayMode = 0;
        if (string == null) {
            this.myAutoScrollThread = null;
        } else {
            this.myPosition = BookReader.getIntProperty(string, "position", 0);
        }
        this.myNextPageStart = 0;
        this.myNextLineStart = 0;
        if (string != null) {
            this.setDisplay(false);
        }
    }

    public void paint(Graphics graphics) {
        this.myLastPaintTime = System.currentTimeMillis();
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        if (this.myDisplayMode == 2) {
            BookReader.MENU.displayMenu(graphics);
        } else if (this.myDisplayMode == 1) {
            graphics.setColor(BGCOLOR);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(FGCOLOR);
            int n5 = graphics.getFont().getHeight();
            int n6 = n3 / 2;
            int n7 = n4 / 2 - n5 - n5;
            graphics.drawString("AutoScroll:", n6, n7, 1 | 0x10);
            String string = "OFF";
            if (this.myAutoScrollDelayMs != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.myAutoScrollDelayMs / 1000);
                if (this.myAutoScrollDelayMs % 1000 > 0) {
                    stringBuffer.append(",5");
                }
                stringBuffer.append(" sec");
                string = stringBuffer.toString();
            }
            graphics.drawString(string, n6, n7 += n5, 1 | 0x10);
            graphics.drawString("change-", n6, n7 += n5, 1 | 0x10);
            graphics.drawString("keys 3,9", n6, n7 += n5, 1 | 0x10);
        } else {
            String string = null;
            try {
                if (this.myText.getSize() == 0) {
                    string = "No text";
                } else {
                    Graphics graphics2;
                    Graphics graphics3 = graphics2 = this.myDblBufImage != null ? this.myDblBufImage.getGraphics() : graphics;
                    if (this.myDisplayFont != null) {
                        graphics2.setFont(this.myDisplayFont);
                    }
                    this.renderText(graphics2);
                    if (this.myDblBufImage != null) {
                        graphics.drawImage(this.myDblBufImage, 0, 0, 4 | 0x10);
                    }
                }
            }
            catch (Exception exception) {
                string = exception.toString();
                exception.printStackTrace();
            }
            if (string != null) {
                BookReader.instance.showBooksList();
                this.showMessage("Display Error", string, AlertType.ERROR, (Displayable)BookReader.instance.myBookList);
            }
        }
    }

    public void showMessage(String string, String string2, AlertType alertType, Displayable displayable) {
        Alert alert = this.myMessageBox;
        alert.setTitle(string);
        alert.setType(AlertType.ERROR);
        alert.setString(string2);
        if (displayable != null) {
            this.display.setCurrent(alert, displayable);
        } else {
            this.display.setCurrent((Displayable)alert);
        }
    }

    public void renderText(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        this.myNextPageStart = n4 = this.myPosition;
        this.myNextLineStart = n4;
        graphics.setColor(BGCOLOR);
        graphics.setClip(0, 0, this.myScrWidth, this.myScrHeight);
        graphics.fillRect(0, 0, this.myScrWidth, this.myScrHeight);
        graphics.setColor(FGCOLOR);
        int n5 = 0;
        int n6 = this.myScrWidth;
        int n7 = this.myScrHeight;
        Image image = null;
        String string = BookReader.getProperty(this.myText.id, "pagedisplay");
        boolean bl = false;
        boolean bl2 = false;
        if (string.startsWith("font")) {
            n3 = this.myDisplayFont.getHeight();
            bl = true;
        } else if (string.equals("normal")) {
            image = this.myNormalFontImage;
            n5 = image.getWidth() / 16;
            n3 = image.getHeight() / 14;
        } else {
            image = this.myCwRotatedFontImage;
            n5 = image.getHeight() / 16;
            n3 = image.getWidth() / 14;
            n6 = this.myScrHeight;
            n7 = this.myScrWidth;
            bl2 = true;
        }
        Formatter formatter = this.myFormatter;
        int n8 = formatter.init(n4, bl, n5, n6);
        int n9 = 0;
        int n10 = n3;
        if (this.mySpareLineOnScroll) {
            n10 += n3;
        }
        while (n8 != -1 && n9 < n7) {
            n8 = formatter.getLineBuffer(n8);
            if (n7 - n9 >= n10) {
                this.myNextPageStart = formatter.nextLineStart;
                if (this.myNextLineStart == n4) {
                    this.myNextLineStart = this.myNextPageStart;
                }
            }
            if ((n2 = formatter._bufFrom) < (n = this.myFormatter._bufTo)) {
                if (bl) {
                    graphics.drawChars(formatter.buffer, n2, n - n2, 0, n9, 0x10 | 4);
                } else {
                    this.drawGlyphLine(graphics, formatter.buffer, n2, n, n9, n5, n3, bl2, image);
                }
            }
            n9 += n3;
        }
        if (this.myNextLineStart == -1) {
            this.myNextLineStart = n4;
        }
        if (this.myNextPageStart == -1) {
            this.myNextPageStart = n4;
        }
        graphics.setClip(0, 0, this.myScrWidth, this.myScrHeight);
        n2 = this.myScrWidth - 1;
        n9 = this.myScrHeight - 1;
        n = this.myText.getSize();
        graphics.setColor(FGCOLOR);
        while (n2 >= 0 && n9 >= 0) {
            graphics.drawLine(n2, n9, n2 - 1, n9 - 1);
            if (bl2) {
                n2 -= 2;
                continue;
            }
            n9 -= 2;
        }
        graphics.setColor(BGCOLOR);
        if (bl2) {
            n2 = this.myScrWidth - (this.myScrWidth - 4) * n4 / n;
            graphics.drawLine(n2, n9, n2, n9 - 1);
            graphics.setColor(FGCOLOR);
            graphics.drawLine(--n2, n9, n2, n9 - 1);
            graphics.drawLine(--n2, n9, n2, n9 - 1);
            graphics.drawLine(--n2, n9, n2, n9 - 1);
            graphics.setColor(BGCOLOR);
            graphics.drawLine(--n2, n9, n2, n9 - 1);
            --n2;
        } else {
            n9 = (this.myScrHeight - 4) * n4 / n;
            graphics.drawLine(n2, n9, n2 - 1, n9);
            graphics.setColor(FGCOLOR);
            graphics.drawLine(n2, ++n9, n2 - 1, n9);
            graphics.drawLine(n2, ++n9, n2 - 1, n9);
            graphics.drawLine(n2, ++n9, n2 - 1, n9);
            graphics.setColor(BGCOLOR);
            graphics.drawLine(n2, ++n9, n2 - 1, n9);
            ++n9;
        }
    }

    private void drawGlyphLine(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, boolean bl, Image image) {
        int n6 = 0;
        int n7 = n;
        for (int i = n2 - n; i != 0; --i) {
            int n8 = cArray[n7] - 32;
            if (n8 > 0) {
                int n9 = n8 & 0xF;
                int n10 = n8 >> 4;
                if (bl) {
                    int n11 = this.myScrWidth - n3 - n5;
                    int n12 = n6;
                    graphics.setClip(n11, n12, n5, n4);
                    graphics.drawImage(image, n11 - (13 - n10) * n5, n12 - n9 * n4, 0x10 | 4);
                } else {
                    graphics.setClip(n6, n3, n4, n5);
                    graphics.drawImage(image, n6 - n9 * n4, n3 - n10 * n5, 0x10 | 4);
                }
            }
            n6 += n4;
            ++n7;
        }
    }

    private int getPositionNLinesUp(int n, int n2, int n3) {
        int n4 = this.myPosition;
        try {
            int n5;
            boolean bl;
            boolean bl2 = bl = this.myDisplayFont != null;
            while ((n5 = this.myFormatter.getPrevLineStart(n4, bl, n2, n3)) != n4) {
                n4 = n5;
                if (--n > 0) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n4;
    }

    private void scrollUp(boolean bl) {
        int n;
        int n2 = 0;
        int n3 = this.myScrWidth;
        int n4 = this.myScrHeight;
        if (this.myDisplayFont != null) {
            n = this.myDisplayFont.getHeight();
        } else {
            String string = BookReader.getProperty(this.myText.id, "pagedisplay");
            if (string.equals("normal")) {
                n2 = this.myNormalFontImage.getWidth() / 16;
                n = this.myNormalFontImage.getHeight() / 14;
            } else {
                n2 = this.myCwRotatedFontImage.getHeight() / 16;
                n = this.myCwRotatedFontImage.getWidth() / 14;
                n3 = this.myScrHeight;
                n4 = this.myScrWidth;
            }
        }
        int n5 = 1;
        if (bl) {
            n5 = n4 / n;
            if (this.mySpareLineOnScroll) {
                --n5;
            }
        }
        this.setViewPosition(this.getPositionNLinesUp(n5, n2, n3));
    }

    private void setViewPosition(int n) {
        if (n >= 0 && n < this.myText.getSize() && n != this.myPosition) {
            if (this.myText.isUnicode && n % 1 == 1) {
                --n;
            }
            if (n == this.myNextLineStart) {
                this.myAutoScrollAllowed = true;
            }
            this.myPosition = n;
            BookReader.setProperty(this.myText.id, "position", Integer.toString(n));
            this.repaint();
        }
    }

    private void goHome() {
        this.setViewPosition(0);
    }

    private void goEnd() {
        this.setViewPosition(this.myText.getSize() - (this.myText.isUnicode ? 2 : 1));
        this.scrollUp(true);
    }

    private void menuItemSelected(int n) {
        if (n < 0) {
            return;
        }
        String string = null;
        boolean bl = false;
        if (n == 0) {
            bl = true;
        } else if (n == 1) {
            BookReader.instance.showBooksList();
        } else if (n == 2) {
            BookReader.instance.destroyApp(true);
        } else if (n == 3) {
            this.initSearch();
        } else if (n == 4) {
            this.gotoPercent();
        } else if (n == 5) {
            this.myDisplayMode = 1;
            this.repaint();
        } else if (n == 6) {
            this.mySpareLineOnScroll = !this.mySpareLineOnScroll;
            BookReader.setProperty("main", "spareline", this.mySpareLineOnScroll ? "true" : "false");
            bl = true;
        } else if (n == 7) {
            this.setDisplay(true);
            bl = true;
        } else if (n == 8) {
            this.myBkLightState = !this.myBkLightState;
            BookReader.setBackLight(this.myBkLightState);
            bl = true;
        } else if (n == 9) {
            Form form = BookReader.instance.myLoadingForm;
            ((StringItem)form.get(0)).setText(this.getTimeStr());
            this.display.setCurrent((Displayable)form);
        }
        if (bl) {
            this.myDisplayMode = 0;
            this.repaint();
        } else if (string != null) {
            this.showMessage("(c)tequilaCat", string, AlertType.WARNING, null);
            this.myDisplayMode = 0;
        }
    }

    protected void keyPressed(int n) {
        BookReader.setBackLight(true);
        int n2 = this.getGameAction(n);
        if (this.myDisplayMode == 2) {
            int n3 = -1;
            if (n == 35) {
                n3 = 0;
            } else if (!(HAS_DIR_BUTTONS || n2 != 1 && n2 != 6)) {
                BookReader.MENU.moveMenuSelection(n2 == 6);
                this.repaint();
            } else if (n2 == 8) {
                n3 = BookReader.MENU.SELECTED_INDEX;
            } else if (n >= 48 && n <= 57) {
                n3 = n - 48;
            } else if (HAS_DIR_BUTTONS && (n2 == 1 || n2 == 6)) {
                BookReader.MENU.moveMenuSelection(n2 == 6);
                this.repaint();
            }
            this.menuItemSelected(n3);
            return;
        }
        this.myAutoScrollAllowed = false;
        boolean bl = "clockwise".equals(BookReader.getProperty(this.myText.id, "pagedisplay"));
        int n4 = 8;
        if (bl ? n == 57 : n == 51) {
            this.changeAutoScroll(-1);
            return;
        }
        if (bl ? n == 55 : n == 57) {
            this.changeAutoScroll(1);
            return;
        }
        if (this.myDisplayMode == 1) {
            this.myAutoScrollAllowed = true;
            this.myDisplayMode = 0;
        }
        if (n2 == 2 || n == 52) {
            n4 = bl ? 6 : 2;
        } else if (n2 == 5 || n == 54) {
            n4 = bl ? 1 : 5;
        } else if (n2 == 1 || n == 50) {
            n4 = bl ? 2 : 1;
        } else if (n2 == 6 || n == 56) {
            n4 = bl ? 5 : 6;
        } else if (bl ? n == 51 : n == 49) {
            this.goHome();
        } else if (bl ? n == 49 : n == 55) {
            this.goEnd();
        } else if (n2 == 8) {
            this.myDisplayMode = 2;
            this.repaint();
        } else if (n == 42) {
            this.myBkLightState = !this.myBkLightState;
            BookReader.setBackLight(this.myBkLightState);
        } else if (n == 35) {
            this.setDisplay(true);
            this.repaint();
        }
        switch (n4) {
            case 2: {
                this.scrollUp(true);
                break;
            }
            case 5: {
                this.setViewPosition(this.myNextPageStart);
                break;
            }
            case 1: {
                this.scrollUp(false);
                break;
            }
            case 6: {
                this.setViewPosition(this.myNextLineStart);
            }
        }
    }

    private void changeAutoScroll(int n) {
        this.myAutoScrollAllowed = true;
        int n2 = this.myAutoScrollDelayMs;
        if (n == 0) {
            n2 = 0;
        } else {
            int n3 = n2 >= 10000 ? 1000 : 500;
            if ((n2 += n > 0 ? n3 : -n3) < 0) {
                n2 = this.AUTOSCROLL_MAX_MS;
            } else if (n2 > this.AUTOSCROLL_MAX_MS) {
                n2 = 0;
            }
        }
        if (this.myAutoScrollDelayMs != n2) {
            this.myAutoScrollDelayMs = n2;
            this.myDisplayMode = 1;
            this.repaint();
            if (this.myAutoScrollThread == null && this.myAutoScrollDelayMs != 0) {
                this.myAutoScrollThread = new Thread(this);
                this.myAutoScrollThread.start();
            }
        }
    }

    public void run() {
        try {
            while (this.myText != null && this.myAutoScrollThread != null) {
                long l = System.currentTimeMillis();
                if (this.myDisplayMode == 0 && this.myAutoScrollAllowed && this.myAutoScrollDelayMs != 0 && (long)this.myAutoScrollDelayMs + this.myLastPaintTime < l && this.isShown()) {
                    this.setViewPosition(this.myNextPageStart);
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myAutoScrollThread = null;
    }

    public void pointerReleased(int n, int n2) {
        if (this.myDisplayMode == 0) {
            int n3;
            boolean bl = "clockwise".equals(BookReader.getProperty(this.myText.id, "pagedisplay"));
            if (this.myLastClickX - n > this.getWidth() / 5 || this.myLastClickY - n2 > this.getHeight() / 5) {
                this.setDisplay(true);
                this.repaint();
                return;
            }
            int n4 = bl ? this.myScrWidth : this.myScrHeight;
            int n5 = n3 = bl ? n4 - n : n2;
            if (n3 < n4 / 4) {
                this.scrollUp(true);
            } else if (n3 < n4 / 2) {
                this.scrollUp(false);
            } else if (n3 < n4 * 3 / 4) {
                this.setViewPosition(this.myNextLineStart);
            } else {
                this.setViewPosition(this.myNextPageStart);
            }
        }
    }

    public void pointerPressed(int n, int n2) {
        if (this.myDisplayMode == 0) {
            this.myLastClickX = n;
            this.myLastClickY = n2;
        } else if (this.myDisplayMode == 2) {
            this.menuItemSelected(BookReader.MENU.getClickedItem(n2));
        }
    }

    private String getTimeStr() {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        if (n > 12) {
            n -= 12;
        }
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(':');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2).append('\n');
        return stringBuffer.toString();
    }

    private void initSearch() {
        this.myInputMode = 1;
        this.input("Search", this.mySearchPattern, 0, this);
    }

    public void input(String string, String string2, int n, CommandListener commandListener) {
        TextBox textBox = this.myInputBox;
        textBox.setTitle(string);
        textBox.setString(string2);
        textBox.setConstraints(n);
        textBox.setCommandListener(commandListener);
        this.display.setCurrent((Displayable)textBox);
    }

    public boolean search() {
        String string = this.myInputBox.getString().toLowerCase();
        this.myInputBox.setString(string);
        if (string.length() == 0) {
            return false;
        }
        this.mySearchPattern = string;
        this.myInputBox.setTitle("searching...");
        int n = this.myText.isUnicode ? 2 : 1;
        int n2 = 0;
        int n3 = this.myPosition + n;
        if (n3 >= this.myText.getSize()) {
            n3 = 0;
        }
        int n4 = n3;
        boolean bl = false;
        char c = string.charAt(0);
        this.myText.setFrame(n3);
        byte[] byArray = this.myText.CUR_CHUNK;
        int n5 = this.myText.POS_IN_CHUNK;
        int n6 = this.myText.CUR_CHUNK_SIZE;
        char[] cArray = this.myText.isUnicode ? null : this.myFormatter.UnicodeConversionTable;
        while (n3 >= n4 != bl) {
            if (n5 >= n6) {
                this.myText.setFrame(this.myText.CUR_CHUNK_START + n5);
                byArray = this.myText.CUR_CHUNK;
                n5 = this.myText.POS_IN_CHUNK;
                n6 = this.myText.CUR_CHUNK_SIZE;
                if (byArray == null) {
                    System.out.println("Wrap search...");
                    bl = true;
                    n2 = 0;
                    c = string.charAt(0);
                    this.myText.setFrame(0);
                    byArray = this.myText.CUR_CHUNK;
                    n5 = this.myText.POS_IN_CHUNK;
                    n6 = this.myText.CUR_CHUNK_SIZE;
                    n3 = 0;
                    continue;
                }
            }
            int n7 = byArray[n5] & 0xFF;
            if (cArray == null) {
                n7 |= (0xFF & byArray[n5 + 1]) << 8;
            } else if (n7 > 127) {
                n7 = cArray[n7 - 128];
            }
            n5 += n;
            n3 += n;
            if (Character.toLowerCase((char)n7) == c) {
                if (++n2 == string.length()) break;
                c = string.charAt(n2);
                continue;
            }
            if (n2 == 0) continue;
            n2 = 0;
            c = string.charAt(0);
        }
        if (n2 == string.length()) {
            n3 -= n2;
            if (this.myText.isUnicode) {
                n3 -= n2;
            }
            this.setViewPosition(n3);
            return true;
        }
        return false;
    }

    private void gotoPercent() {
        this.myInputMode = 2;
        this.input("Go to %", Integer.toString(this.myPosition * 100 / this.myText.getSize()), 2, this);
    }

    public void commandAction(Command command, Displayable displayable) {
        boolean bl = true;
        if (command != BookReader.CMD_CANCEL) {
            if (this.myInputMode == 2) {
                int n = this.myText.getSize();
                int n2 = this.myPosition * 100 / n;
                int n3 = Integer.parseInt(this.myInputBox.getString());
                if (n3 != n2) {
                    if (n3 >= 0 && n3 <= 100) {
                        int n4 = n * n3 / 100;
                        if (n4 >= n) {
                            n4 = n - 1;
                        }
                        this.setViewPosition(n4);
                    } else {
                        this.myInputBox.setTitle("Enter %! 0-100");
                        bl = false;
                    }
                }
            } else if (this.myInputMode == 1 && !this.search()) {
                this.myInputBox.setTitle("Not Found");
                bl = false;
            }
        }
        if (bl) {
            this.myDisplayMode = 0;
            this.display.setCurrent((Displayable)this);
            this.repaint();
        }
    }

    private void setDisplay(boolean bl) {
        String string = BookReader.getProperty(this.myText.id, "pagedisplay");
        if (string == null) {
            string = "normal";
        }
        if (bl) {
            if (string.equals("normal")) {
                string = "clockwise";
            } else if (string.equals("clockwise")) {
                string = "fontsmall";
            } else if (string.equals("fontsmall")) {
                string = "font";
            } else if (string.equals("font")) {
                string = "fontbig";
            } else if (string.equals("fontbig")) {
                string = "normal";
            }
        }
        if (string.equals("normal") && this.myNormalFontImage == null) {
            string = "clockwise";
        }
        if (string.equals("clockwise") && this.myCwRotatedFontImage == null) {
            string = "fontsmall";
        }
        if (this.myText.isUnicode && !string.startsWith("font")) {
            string = "fontsmall";
        }
        Object object = this.myDisplayFont = string.startsWith("font") ? Font.getDefaultFont() : null;
        if (this.myDisplayFont != null && string.length() > 4) {
            try {
                this.myDisplayFont = Font.getFont((int)this.myDisplayFont.getFace(), (int)this.myDisplayFont.getStyle(), (int)(string.equals("fontbig") ? 16 : 8));
            }
            catch (Exception exception) {
                BookReader.setProperty(this.myText.id, "pagedisplay", "fontbig");
                this.setDisplay(bl);
                return;
            }
        }
        if (this.myDisplayFont != null) {
            this.myFormatter.setFont(this.myDisplayFont);
        }
        BookReader.setProperty(this.myText.id, "pagedisplay", string);
    }
}

