<?php

defined('__IN_iNF') or die('Error: Restricted Access!');
# mp3 info
class AudioInfo
{
	# VARIABLES
	var $wave_id;
	var $wave_type;
	var $wave_compression;
	var $wave_channels;
	var $wave_framerate;
	var $wave_byterate;
	var $wave_bits;
	var $wave_size;
	var $wave_file;
	var $wave_length;
	var $id3_tag;
	var $id3_title;
	var $id3_artist;
	var $id3_album;
	var $id3_year;
	var $id3_comment;
	var $id3_genre;

    # FUNCTION
	private function mp3info($file)
	{
		$this->wave_filename = $file;

		$byte = array('');
		$vrs = array('MPEG Version 2.5', false, 'MPEG Version 2 (ISO/IEC 13818-3)', 'MPEG Version 1 (ISO/IEC 11172-3)');
		$v_bit = array('1',false,'1','0');
		$v_s = array('2',false,'1','0');
		$layer = array(false,'Layer III','Layer II','Layer I');
		$l_bit = array(false,'2','1','0');
		$l_lengt = array(false,'1','1','0');
		$prt = array('Protected by CRC (16bit crc follows header)','Not protected');
		$b = array(
					array(
						array('free','32','64','96','128','160','192','224','256','288','320','352','384','416','448','bad'),
						array('free','32','48','56', '64', '80', '96', '112', '128','160','192','224','256','320','384','bad'),
						array('free', '32','40','48', '56', '64', '80', '96','112','128','160','192','224','256','320','bad')
					     ),
					array(
						array('free', '32','48','56', '64', '80', '96', '112', '128', '144', '160', '176', '192', '224', '256','bad'),
						array('free', '8','16','24', '32', '40', '48', '56', '64', '80', '96','112','128','144','160','bad'),
						array('free', '8','16','24', '32', '40', '48', '56', '64', '80', '96', '112','128','144','160','bad')
					     )
				       );
		$s = array(array('44100','48000','32000',false),array('22050','24000','16000',false),array('11025','12000', '8000',false));
		$c_m = array('Stereo', 'Joint stereo (Stereo)', 'Dual channel (Stereo)', 'Single channel (Mono)');
		$copy = array('Audio is not copyrighted', 'Audio is copyrighted ');
		$orig = array('Copy of original media', 'Original media');
		$emp = array('none','50/15 ms', false, 'CCIT J.17 ');
	# id3-stuff
		 $g = array('Blues','Classic Rock','Country','Dance','Disco','Funk','Grunge','Hip-Hop','Jazz','Metal','New Age','Oldies','Other','Pop','R&B',
					'Rap','Reggae','Rock','Techno','Industrial','Alternative','Ska','Death Metal','Pranks','Soundtrack','Euro-Techno','Ambient','Trip-Hop',
					'Vocal','Jazz+Funk','Fusion','Trance','Classical','Instrumental','Acid','House','Game','Sound Clip','Gospel','Noise','Alternative Rock',
					'Bass','Soul','Punk','Space','Meditative','Instrumental Pop','Instrumental Rock','Ethnic','Gothic','Darkwave','Techno-Industrial',
					'Electronic','Pop-Folk','Eurodance','Dream','Southern Rock','Comedy','Cult','Gangsta','Top 40','Christian Rap','Pop/Funk','Jungle',
					'Native US','Cabaret','New Wave','Psychadelic','Rave','Showtunes','Trailer','Lo-Fi','Tribal','Acid Punk','Acid Jazz','Polka','Retro',
					'Musical','Rock & Roll','Hard Rock','Folk','Folk-Rock','National Folk','Swing','Fast Fusion','Bebob','Latin','Revival','Celtic','Bluegrass',
					'Avantgarde','Gothic Rock','Progressive Rock','Psychedelic Rock','Symphonic Rock','Slow Rock','Big Band','Chorus','Easy Listening','Acoustic',
					'Humour','Speech','Chanson','Opera','Chamber Music','Sonata','Symphony','Booty Bass','Primus','Porn Groove','Satire','Slow Jam','Club',
					'Tango','Samba','Folklore','Ballad','Power Ballad','Rhytmic Soul','Freestyle','Duet','Punk Rock','Drum Solo','Acapella','Euro-House',
					'Dance Hall','Goa','Drum & Bass','Club-House','Hardcore','Terror','Indie','BritPop','Negerpunk','Polsk Punk','Beat','Christian Gangsta Rap',
					'Heavy Metal','Black Metal','Crossover','Contemporary Christian','Christian Rock','Merengue','Salsa','Trash Metal','Anime','Jpop','Synthpop');

	# id3v2 check
		$footer	= '0';
		$header = '0';
		$v1tag	= '0';
		$fp = fopen($this->wave_filename, 'r');
		$t = fread($fp, '3');
		if ($t == 'ID3')
		{
			$t = ord(fread($fp, '1'));
			$t2 = ord(fread($fp, '1'));
			$i['mpeg_id3v2_tag']['version'] = 'ID3v2.'.$t.'.'.$t2;
			$t = ord(fread($fp,'1'));
			if($t & 128) $i['mpeg_id3v2_tag']['flag']['unsync'] = 'set';
			if($t & 64) $i['mpeg_id3v2_tag']['flag']['extended'] = 'set';
			if($t & 32) $i['mpeg_id3v2_tag']['flag']['experimental'] = 'set';
			if($t & 16)
			{
				$i['mpeg_id3v2_tag']['flag']['footer'] = 'set';
				$footer = '10';
			}
			$t = ord(fread($fp, '1'))& 127;
			$t2 = ord(fread($fp, '1'))& 127;
			$t3 = ord(fread($fp, '1'))& 127;
			$t4 = ord(fread($fp, '1'))& 127;
			$i['mpeg_id3v2_tag']['header_lenght'] = ($t * 2097152) + ($t2 * 16384) + ($t3 * 128) + $t4 + 10 + $footer;
			fseek ($fp,$i['mpeg_id3v2_tag']['header_lenght']);
			$header = $i['mpeg_id3v2_tag']['header_lenght'];
		} else {
			fseek ($fp, '0');
			$i['mpeg_id3v2_tag'] = false;
		}
		#
		$byte['0'] = ord(fread($fp, '1'));
		$byte['1'] = ord(fread($fp, '1'));
		$byte['2'] = ord(fread($fp, '1'));
		$byte['3'] = ord(fread($fp, '1'));
        #
		fseek ($fp, -128, SEEK_END);
		$TaG = fread($fp, '128');
		fclose($fp);
	# id tag?
		if(substr($TaG, '0', '3') == 'TAG')
		{
			$v1tag = '128';
			$i['mpeg_id3v1_tag']['title'] = substr($TaG, '3', '30');
			$i['mpeg_id3v1_tag']['artist'] = substr($TaG, '33', '30');
			$i['mpeg_id3v1_tag']['album'] = substr($TaG, '63', '30');
			$i['mpeg_id3v1_tag']['year'] = substr($TaG, '93', '4');
			$i['mpeg_id3v1_tag']['comment'] = substr($TaG, '97', '30');
			$i['mpeg_id3v1_tag']['genre'] = '';
			$t = ord(substr($TaG, '127', '1'));
			if ($t < count($g)) $i['mpeg_id3v1_tag']['genre'] = $g[$t];
		}
		else $i['mpeg_id3v1_tag'] = false;

	# version
		$t = $byte['1'] & 24;
		$t = $t >> 3;
		$info_i['mpeg_vrs'] = $t;
		$byte_v = $v_bit[$t];
		$byte_vs = $v_s[$t];
		$i['mpeg_vrs'] = $vrs[$t];
	# layer
		$t = $byte['1'] & 6;
		$t = $t >> 1;
		$info_i['mpeg_layer'] = $t;
		$byte_l = $l_bit[$t];
		$byte_len = $l_lengt[$t];
		$i['mpeg_layer'] = $layer[$t];
	# bitrate
		$t = $byte['2'] & 240;
		$t = $t >> 4;
		$info_i['mpeg_bit'] = $t;
		$i['mpeg_bit'] = $b[$byte_v][$byte_l][$t].' Кбит/сек';
	# samplingrate
		$t = $byte['2'] & 1;
		$t = $t >> 2;
		$i['mpeg_sampling_rate'] = $s[$byte_vs][$t];
	# protection
		$t = $byte['1'] & 1;
		$i['mpeg_protection'] = $prt[$t];
	# paddingbit
		$t = $byte['2'] & 2;
		$t = $t >> 1;
		$byte_p = $t;
		$i['mpeg_padding_bit'] = $t;
	# privatebit
		$byte_prv = $byte['2'] & 1;
	# channel_mode
		$t = $byte['3'] & 192;
		$t = $t >> 6;
		$i['mpeg_channel_mode'] = $c_m[$t];
	# copyright
		$t = $byte['3'] & 8;
		$t = $t >> 3;
		$i['mpeg_copyright'] = $copy[$t];
	# original
		$t = $byte['3'] & 4;
		$t = $t >> 2;
		$i['mpeg_original'] = $orig[$t];
	# emphasis
		$t = $byte['3'] & 3;
		$i['mpeg_emphasis'] = $emp[$t];
	# framelenght
		if($byte_len == 0)
		{
			$r_tmp = $i['mpeg_bit'] * 1000;
			$i['mpeg_framelenght'] = (12 * $r_tmp / $i['mpeg_sampling_rate'] + $byte_p) * 4 ;
		} elseif($byte_len == '1')
		{
			$r_tmp = $i['mpeg_bit'] * 1000;
			$i['mpeg_framelenght'] = 144 * $r_tmp / $i['mpeg_sampling_rate'] + $byte_p;
		}
	# duration
		$fs = filesize($this->wave_filename);
		$t = $fs;
		$t = $t - $header - 4 - $v1tag;
		$t2 = '0';
		if ($i['mpeg_bit'] <> 0) $t2 = ((8 * $t) / 1000) / $i['mpeg_bit'];
		$i['mpeg_frames']='';
		if ($i['mpeg_framelenght'] <> 0) $i['mpeg_frames'] = floor($t/$i['mpeg_framelenght']);
		$t = $t * 8;
		$i['mpeg_ptime']='';
		if ($r_tmp <> 0) $i['mpeg_ptime'] = $t/$r_tmp;
		#$i['mpeg_ptime'] = $t2;

	defined('__IN_iNF') or die('Error: Restricted Access!');
	# transfer the extracted data into AudioFile-structure

		$this->wave_id = 'MPEG';
		$this->wave_type = $i['mpeg_vrs'];
		$this->wave_compression = $i['mpeg_layer'];
		$this->wave_channels = $i['mpeg_channel_mode'];
		$this->wave_framerate = $i['mpeg_sampling_rate'];
		$this->wave_byterate = $i['mpeg_bit'];
		$this->wave_bits = 'n/a';
		$this->wave_size = $fs;
		$this->wave_length = $t2;

		$this->id3_tag = $i['mpeg_id3v1_tag'];

		if ($this->id3_tag)
		{
			$this->id3_title = $i['mpeg_id3v1_tag']['title'];
			$this->id3_artist = $i['mpeg_id3v1_tag']['artist'];
			$this->id3_album = $i['mpeg_id3v1_tag']['album'];
			$this->id3_year = $i['mpeg_id3v1_tag']['year'];
			$this->id3_comment = $i['mpeg_id3v1_tag']['comment'];
			$this->id3_genre = $i['mpeg_id3v1_tag']['genre'];
		}
	}
    #
	private function w2u($text)
	{
	ReTurn iconv('windows-1251', 'utf-8', trim($text));
	}
	private function u2w($text)
	{
	ReTurn iconv('utf-8', 'windows-1251', trim($text));
	}

    # MP3 only
    # Полная информация
	public function iNF($file, $i = 'all')
	{
	$this->mp3info($file);
    $kgz = Round($this->wave_framerate / Pow('1000', Floor(Log($this->wave_framerate, '1000'))), '0');
	echo ' <div class="opis">',
	'Качество: ', $kgz, 'кГц, ', $this->wave_byterate ,', ', $this->wave_channels ,'  <br>',
	'Время: ', date('i:s', mktime('0','0',round($this->wave_length))) ,' мин <br>';
	    if ($i == 'all' && $this->id3_tag)
	    {
			if ($title = $this->w2u($this->id3_title)) echo 'Название: ', POST($title) ,' <br>';
			if ($artist = $this->w2u($this->id3_artist)) echo 'Исполнитель: ', POST($artist) ,' <br>';
			if ($album = $this->w2u($this->id3_album)) echo 'Альбом: ', POST($album) ,' <br>';
			if ($year = $this->w2u($this->id3_year)) echo 'Год: ', $year ,' <br>';
			if ($genre = $this->w2u($this->id3_genre)) echo 'Жанр: ', $genre ,' <br>';
			if ($comm = $this->w2u($this->id3_comment)) echo 'Комментарий: ', POST($comm) ,' <br>';
		}
	echo '</div>';
	}

}


## end Class
