CREATE TABLE IF NOT EXISTS `adm_forum_p` (
  `id` int(11) NOT NULL auto_increment,
  `t` int(11) NOT NULL,
  `c` int(11) default '0',
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_ed` int(11) default NULL,
  `ed` int(11) default '0',
  `user_ed` int(11) default NULL,
  `msg` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `them` (`t`),
  KEY `user` (`user`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `adm_forum_t` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(128) NOT NULL,
  `user` int(11) default NULL,
  `time` int(11) NOT NULL,
  `post` int(11) default '0',
  `time_last` int(11) NOT NULL,
  `user_last` int(11) default NULL,
  `up` set('0','1') NOT NULL default '0',
  `close` set('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ban_text` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `user` int(11) NOT NULL,
  `text` char(255) NOT NULL,
  `time` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `base_info` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` char(128) NOT NULL,
  `value` char(255) NOT NULL,
  `act` char(32) default 'base',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `files` (
  `id` bigint(16) unsigned NOT NULL auto_increment,
  `path` char(255) NOT NULL,
  `infolder` char(255) NOT NULL,
  `name` char(255) NOT NULL,
  `priority` tinyint(3) NOT NULL default '0',
  `size` int(11) unsigned NOT NULL,
  `about` varchar(2048) NOT NULL,
  `fastabout` varchar(1024) NOT NULL,
  `loads` int(16) unsigned NOT NULL default '0',
  `timeload` int(11) unsigned NOT NULL,
  `timeupload` int(11) unsigned NOT NULL,
  `lastedit` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `size` (`size`),
  KEY `path` (`path`),
  KEY `infolder` (`infolder`),
  KEY `name` (`name`),
  KEY `loads` (`loads`),
  KEY `priority` (`priority`),
  KEY `timeupload` (`timeupload`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `files_komm` (
  `id` bigint(16) unsigned NOT NULL auto_increment,
  `where` bigint(16) unsigned NOT NULL,
  `user` int(11) NOT NULL,
  `msg` varchar(500) NOT NULL,
  `time` int(11) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `file_id` (`where`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `files_screen` (
  `id` bigint(16) unsigned NOT NULL auto_increment,
  `path` char(255) NOT NULL,
  `id_file` bigint(16) unsigned NOT NULL,
  `alt` char(32) NOT NULL,
  `opis` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL default '0',
  `pr` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `id_file` (`id_file`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_f` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL,
  `mesto` int(11) NOT NULL,
  `opis` varchar(512) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `forum_p` (
  `id` int(11) NOT NULL auto_increment,
  `f` int(11) NOT NULL,
  `r` int(11) NOT NULL,
  `t` int(11) NOT NULL,
  `c` int(11) default '0',
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_ed` int(11) default NULL,
  `ed` int(11) default '0',
  `user_ed` int(11) default NULL,
  `msg` text NOT NULL,
  `file` varchar(250) default NULL,
  `fname` varchar(64) default NULL,
  `ext` varchar(32) default '',
  `fsize` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `them` (`f`,`r`,`t`),
  KEY `user` (`user`),
  KEY `time` (`time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_r` (
  `id` int(11) NOT NULL auto_increment,
  `f` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `opis` varchar(250) default NULL,
  `time` int(11) NOT NULL,
  `p` int(11) default '0',
  `t` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `forum` (`f`,`time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_t` (
  `id` int(11) NOT NULL auto_increment,
  `f` int(11) NOT NULL,
  `r` int(11) default NULL,
  `name` varchar(128) NOT NULL,
  `user` int(11) default NULL,
  `time` int(11) NOT NULL,
  `post` int(11) default '0',
  `time_last` int(11) NOT NULL,
  `user_last` int(11) default NULL,
  `up` set('0','1') NOT NULL default '0',
  `close` set('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `id_forum` (`f`,`r`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `foto_album` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(128) collate utf8_unicode_ci default NULL,
  `opis` char(255) collate utf8_unicode_ci default NULL,
  `user` int(11) NOT NULL default '0',
  `time` int(11) NOT NULL default '0',
  `last` int(11) NOT NULL default '0',
  `all` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `user` (`user`,`last`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `foto_file` (
  `id` int(11) NOT NULL auto_increment,
  `album` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `file` varchar(128) collate utf8_unicode_ci default NULL,
  `name` varchar(128) collate utf8_unicode_ci default NULL,
  `opis` varchar(255) collate utf8_unicode_ci default NULL,
  `size` int(11) default NULL,
  `x` int(6) default NULL,
  `y` int(6) default NULL,
  `komm` int(11) default '0',
  `time` int(11) NOT NULL,
  `V` int(11) default '0',
  `O` int(11) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `foto_komm` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(11) NOT NULL default '0',
  `where` int(11) NOT NULL default '0',
  `msg` varchar(500) collate utf8_unicode_ci default NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `foto_voice` (
  `user` int(11) NOT NULL default '0',
  `foto` int(11) NOT NULL default '0',
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `guest` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(11) NOT NULL default '0',
  `msg` varchar(1024) character set utf8 collate utf8_unicode_ci default NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `kl` (
  `user` int(11) NOT NULL,
  `kont` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `last` int(11) NOT NULL,
  `aut` set('0','1') collate utf8_unicode_ci NOT NULL default '1',
  PRIMARY KEY  (`user`,`kont`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `lib` (
  `id` int(11) NOT NULL auto_increment,
  `in_dir` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `is_dir` set('0','1') NOT NULL default '0',
  `posting` set('0','1') default '0',
  `name` char(250) NOT NULL,
  `opis` varchar(500) NOT NULL,
  `user` int(11) NOT NULL,
  `text` longtext NOT NULL,
  `is_mod` set('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `type` (`is_dir`),
  KEY `moder` (`is_mod`),
  KEY `time` (`time`),
  KEY `refid` (`in_dir`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `lib_moder` (
  `id` int(11) NOT NULL auto_increment,
  `in_dir` int(11) NOT NULL,
  `edit_id` int(11) default '0',
  `time` int(11) NOT NULL,
  `name` char(250) NOT NULL,
  `user` int(11) NOT NULL,
  `text` longtext NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mail` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(11) default NULL,
  `kont` int(11) default NULL,
  `msg` varchar(2000) collate utf8_unicode_ci default NULL,
  `read` set('0','1') collate utf8_unicode_ci default '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `ser` (`user`,`kont`),
  KEY `time` (`time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `mp3_file` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(11) NOT NULL,
  `file` varchar(128) collate utf8_unicode_ci default NULL,
  `name` varchar(128) collate utf8_unicode_ci default NULL,
  `opis` varchar(255) collate utf8_unicode_ci default NULL,
  `size` int(11) default NULL,
  `komm` int(11) default '0',
  `time` int(11) NOT NULL,
  `V` int(11) default '0',
  `O` int(11) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `mp3_komm` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(11) NOT NULL default '0',
  `mp3` int(11) NOT NULL default '0',
  `msg` varchar(500) collate utf8_unicode_ci default NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `mp3_voice` (
  `user` int(11) NOT NULL default '0',
  `mp3` int(11) NOT NULL default '0',
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `news` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(11) default NULL,
  `name` char(250) collate utf8_unicode_ci default NULL,
  `text` varchar(2000) collate utf8_unicode_ci default NULL,
  `time` int(11) NOT NULL,
  `is_komm` set('0','1') collate utf8_unicode_ci default '1',
  `komm` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `news_komm` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(11) NOT NULL default '0',
  `where` int(11) NOT NULL default '0',
  `msg` varchar(1024) collate utf8_unicode_ci default NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `new_action` (
  `id` bigint(16) NOT NULL auto_increment,
  `user` int(11) NOT NULL,
  `text` varchar(1000) character set utf8 collate utf8_unicode_ci NOT NULL default '',
  `time` int(11) NOT NULL default '0',
  `read` set('0','1') default '0',
  `act` char(128) default NULL,
  PRIMARY KEY  (`id`),
  KEY `id` (`user`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `pass_back` (
  `id` int(11) NOT NULL auto_increment,
  `user` int(11) NOT NULL,
  `mail` char(255) collate utf8_unicode_ci default NULL,
  `md5` char(250) collate utf8_unicode_ci NOT NULL,
  `time` int(11) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plagins` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` char(128) NOT NULL,
  `url` char(255) NOT NULL,
  `about` char(250) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `rules` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` char(128) NOT NULL,
  `text` text NOT NULL,
  `p` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `setting` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` char(128) NOT NULL,
  `value` char(255) NOT NULL,
  `act` char(32) default 'autoload',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

CREATE TABLE IF NOT EXISTS `styles` (
  `id` int(9) NOT NULL auto_increment,
  `dir` char(64) character set utf8 collate utf8_unicode_ci NOT NULL,
  `name` char(32) character set utf8 collate utf8_unicode_ci NOT NULL,
  `temp` char(128) default 'default',
  `css` char(255) default 'style.css',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(9) NOT NULL auto_increment,
  `nick` char(32) collate utf8_unicode_ci NOT NULL,
  `pass` char(75) collate utf8_unicode_ci NOT NULL,
  `mail` char(64) collate utf8_unicode_ci default NULL,
  `avatar` char(15) collate utf8_unicode_ci default NULL,
  `pol` tinyint(1) NOT NULL default '1',
  `wpost` int(11) default '0',
  `wtheme` int(11) default '0',
  `str` int(2) default '5',
  `style` char(64) collate utf8_unicode_ci NOT NULL default 'default',
  `datereg` int(11) default '0',
  `karma` int(11) default '0',
  `level` set('0','1','2','3') collate utf8_unicode_ci default '0',
  `ban` set('0','1') collate utf8_unicode_ci default '0',
  `ban_time` int(11) default '0',
  `timeaut` int(11) default '0',
  `ip` char(21) collate utf8_unicode_ci NOT NULL,
  `browser` char(128) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `users_profile` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(32) character set utf8 collate utf8_unicode_ci default NULL,
  `sname` char(32) character set utf8 collate utf8_unicode_ci default NULL,
  `o_sebe` varchar(500) character set utf8 collate utf8_unicode_ci default NULL,
  `dr` tinyint(2) NOT NULL default '0',
  `mr` tinyint(2) NOT NULL default '0',
  `gr` int(4) NOT NULL default '0',
  `tel` int(11) default NULL,
  `mail` varchar(64) character set utf8 collate utf8_unicode_ci default NULL,
  `icq` int(10) default NULL,
  `skype` char(100) default NULL,
  `jabber` char(100) default NULL,
  `city` char(64) character set utf8 collate utf8_unicode_ci default NULL,
  `www` char(32) character set utf8 collate utf8_unicode_ci default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `users_voice` (
  `user` int(11) NOT NULL default '0',
  `from` int(11) NOT NULL default '0',
  `last_time` int(11) NOT NULL default '0',
  KEY `user` (`user`,`last_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

