CREATE TABLE `jdc_loads` (
  `id` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `refid` int(12) NOT NULL DEFAULT '0',
  `refdir` text NOT NULL,
  `type` enum('dir', 'files') NOT NULL DEFAULT 'dir',
  `meta_key` text NOT NULL,
  `vendor` varchar(70) NOT NULL,
  `3D` enum('yes','no') NOT NULL DEFAULT 'no',
  `BT` enum('yes','no') NOT NULL DEFAULT 'no',
  `icon` varchar(100) NOT NULL,
  `id_them` int(12) NOT NULL DEFAULT '0',
  `time` int(20) NOT NULL DEFAULT '0',
  `time_load` int(20) NOT NULL DEFAULT '0',
  `time_update` int(20) NOT NULL DEFAULT '0',
  `user_id` int(12) NOT NULL DEFAULT '0',
  `login` varchar(32) NOT NULL,
  `minus` int(12) NOT NULL DEFAULT '0',
  `plus` int(12) NOT NULL DEFAULT '0',
  `cnt_load` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `name` (`name`),
  KEY `plus` (`plus`),
  KEY `time_update` (`time_update`),
  KEY `cnt_load` (`cnt_load`),
  KEY `3D` (`3D`),
  KEY `BT` (`BT`),
  FULLTEXT KEY `desc` (`desc`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `jdc_loads_screen` (
  `id` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `refid` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `jdc_loads_files` (
   `id` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `refid` int(12) NOT NULL DEFAULT '0',
  `version` varchar(5) NOT NULL DEFAULT '1.1',
  `lang` varchar(100) NOT NULL DEFAULT 'Rus',
  `server` enum ('home', 'other') NOT NULL DEFAULT 'home',
  `time` int(12) NOT NULL DEFAULT '0',
  `desc` text NOT NULL,
  `size` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;